/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryUtil;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.genscavenge.RuntimeCodeCacheWalker;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.ThreadLocalMTWalker;
import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.genscavenge.Timers;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.RuntimeCodeCacheCleaner;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class GCImpl
implements GC {
    private final RememberedSetConstructor rememberedSetConstructor = new RememberedSetConstructor();
    private final GreyToBlackObjRefVisitor greyToBlackObjRefVisitor = new GreyToBlackObjRefVisitor();
    private final GreyToBlackObjectVisitor greyToBlackObjectVisitor = new GreyToBlackObjectVisitor(this.greyToBlackObjRefVisitor);
    private final CollectionPolicy collectOnlyCompletelyPolicy = new CollectionPolicy.OnlyCompletely();
    private final BlackenImageHeapRootsVisitor blackenImageHeapRootsVisitor = new BlackenImageHeapRootsVisitor();
    private final RuntimeCodeCacheWalker runtimeCodeCacheWalker = new RuntimeCodeCacheWalker(this.greyToBlackObjRefVisitor);
    private final RuntimeCodeCacheCleaner runtimeCodeCacheCleaner = new RuntimeCodeCacheCleaner();
    private final GCAccounting accounting = new GCAccounting();
    private final Timers timers = new Timers();
    private final CollectionVMOperation collectOperation = new CollectionVMOperation();
    private final OutOfMemoryError oldGenerationSizeExceeded = new OutOfMemoryError("Garbage-collected heap size exceeded.");
    private final NoAllocationVerifier noAllocationVerifier = NoAllocationVerifier.factory("GCImpl.GCImpl()", false);
    private final ChunkReleaser chunkReleaser = new ChunkReleaser();
    private CollectionPolicy policy;
    private boolean completeCollection = false;
    private UnsignedWord sizeBefore = (UnsignedWord)WordFactory.zero();
    private boolean collectionInProgress = false;
    private UnsignedWord collectionEpoch = (UnsignedWord)WordFactory.zero();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GCImpl(Feature.FeatureAccess access) {
        this.policy = CollectionPolicy.getInitialPolicy(access);
        RuntimeSupport.getRuntimeSupport().addShutdownHook(this::printGCSummary);
    }

    @Override
    public void collect(GCCause cause) {
        UnsignedWord requestingEpoch = this.possibleCollectionPrologue();
        this.collectWithoutAllocating(cause);
        this.possibleCollectionEpilogue(requestingEpoch);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of garbage collection.")
    void collectWithoutAllocating(GCCause cause) {
        int size = SizeOf.get(CollectionVMOperationData.class);
        CollectionVMOperationData data = (CollectionVMOperationData)StackValue.get((int)size);
        MemoryUtil.fillToMemoryAtomic((Pointer)data, WordFactory.unsigned((int)size), (byte)0);
        data.setNativeVMOperation(this.collectOperation);
        data.setCauseId(cause.getId());
        data.setRequestingEpoch(this.getCollectionEpoch());
        this.collectOperation.enqueue(data);
        if (data.getOutOfMemory()) {
            throw this.oldGenerationSizeExceeded;
        }
    }

    private boolean collectOperation(GCCause cause, UnsignedWord requestingEpoch) {
        Log trace = Log.noopLog().string("[GCImpl.collectOperation:").newline().string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause.getName()).string("  requestingEpoch: ").unsigned((WordBase)requestingEpoch).newline();
        assert (VMOperation.isGCInProgress()) : "Collection should be a VMOperation.";
        assert (this.getCollectionEpoch().equal(requestingEpoch));
        this.timers.mutator.close();
        this.startCollectionOrExit();
        this.timers.resetAllExceptMutator();
        this.collectionEpoch = this.collectionEpoch.add(1);
        ThreadLocalAllocation.disableAndFlushForAllThreads();
        this.printGCBefore(cause.getName());
        boolean outOfMemory = this.collectImpl(cause.getName());
        HeapPolicy.setEdenAndYoungGenBytes(WordFactory.unsigned((int)0), this.accounting.getYoungChunkBytesAfter());
        this.printGCAfter(cause.getName());
        this.finishCollection();
        this.timers.mutator.open();
        trace.string("]").newline();
        return outOfMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectImpl(String cause) {
        boolean outOfMemory;
        Throwable throwable;
        Log trace;
        block40: {
            trace = Log.noopLog().string("[GCImpl.collectImpl:").newline().string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause).newline();
            GCImpl.precondition();
            trace.string("  Begin collection: ");
            throwable = null;
            try (NoAllocationVerifier nav = this.noAllocationVerifier.open();){
                trace.string("  Verify before: ");
                try (Timer vbt = this.timers.verifyBefore.open();){
                    HeapImpl.getHeapImpl().verifyBeforeGC(cause, this.getCollectionEpoch());
                }
                outOfMemory = this.doCollectImpl(this.getPolicy());
                if (!outOfMemory) break block40;
                ReferenceObjectProcessing.setSoftReferencesAreWeak(true);
                try {
                    outOfMemory = this.doCollectImpl(this.collectOnlyCompletelyPolicy);
                }
                finally {
                    ReferenceObjectProcessing.setSoftReferencesAreWeak(false);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        trace.string("  Verify after: ");
        throwable = null;
        try (Timer vat = this.timers.verifyAfter.open();){
            HeapImpl.getHeapImpl().verifyAfterGC(cause, this.getCollectionEpoch());
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        this.postcondition();
        trace.string("]").newline();
        return outOfMemory;
    }

    private boolean doCollectImpl(CollectionPolicy appliedPolicy) {
        CommittedMemoryProvider.get().beforeGarbageCollection();
        this.accounting.beforeCollection();
        try (Timer ct = this.timers.collection.open();){
            if (appliedPolicy.collectIncrementally()) {
                this.scavenge(true);
            }
            this.completeCollection = appliedPolicy.collectCompletely();
            if (this.completeCollection) {
                this.scavenge(false);
            }
        }
        CommittedMemoryProvider.get().afterGarbageCollection(this.completeCollection);
        this.accounting.afterCollection(this.completeCollection, this.timers.collection);
        UnsignedWord maxBytes = HeapPolicy.getMaximumHeapSize();
        UnsignedWord usedBytes = GCImpl.getChunkBytes();
        boolean outOfMemory = usedBytes.aboveThan(maxBytes);
        ReferenceObjectProcessing.afterCollection(usedBytes, maxBytes);
        return outOfMemory;
    }

    public static UnsignedWord getChunkBytes() {
        UnsignedWord youngBytes = HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes();
        UnsignedWord oldBytes = HeapImpl.getHeapImpl().getOldGeneration().getChunkBytes();
        return youngBytes.add(oldBytes);
    }

    private void printGCBefore(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        UnsignedWord unsignedWord = this.sizeBefore = SubstrateGCOptions.PrintGC.getValue() != false || HeapOptions.PrintHeapShape.getValue() != false ? GCImpl.getChunkBytes() : (UnsignedWord)WordFactory.zero();
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue() && this.getCollectionEpoch().equal(1)) {
            verboseGCLog.string("[Heap policy parameters: ").newline();
            verboseGCLog.string("  YoungGenerationSize: ").unsigned((WordBase)HeapPolicy.getMaximumYoungGenerationSize()).newline();
            verboseGCLog.string("      MaximumHeapSize: ").unsigned((WordBase)HeapPolicy.getMaximumHeapSize()).newline();
            verboseGCLog.string("      MinimumHeapSize: ").unsigned((WordBase)HeapPolicy.getMinimumHeapSize()).newline();
            verboseGCLog.string("     AlignedChunkSize: ").unsigned((WordBase)HeapPolicy.getAlignedHeapChunkSize()).newline();
            verboseGCLog.string("  LargeArrayThreshold: ").unsigned((WordBase)HeapPolicy.getLargeArrayThreshold()).string("]").newline();
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                HeapImpl.getHeapImpl().logImageHeapPartitionBoundaries(verboseGCLog).newline();
            }
        }
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            verboseGCLog.string("[");
            verboseGCLog.string("[");
            long startTime = System.nanoTime();
            if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(startTime))).string(" msec: ");
            } else {
                verboseGCLog.unsigned(startTime);
            }
            verboseGCLog.string(" GC:").string(" before").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                heap.report(verboseGCLog);
            }
            verboseGCLog.string("]").newline();
        }
    }

    private void printGCAfter(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        if (SubstrateGCOptions.PrintGC.getValue().booleanValue() || SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            if (SubstrateGCOptions.PrintGC.getValue().booleanValue()) {
                Log printGCLog = Log.log();
                UnsignedWord sizeAfter = GCImpl.getChunkBytes();
                printGCLog.string("[");
                if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    long finishNanos = this.timers.collection.getFinish();
                    printGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                }
                printGCLog.string(this.completeCollection ? "Full GC" : "Incremental GC");
                printGCLog.string(" (").string(cause).string(") ");
                printGCLog.unsigned((WordBase)this.sizeBefore.unsignedDivide(1024));
                printGCLog.string("K->");
                printGCLog.unsigned((WordBase)sizeAfter.unsignedDivide(1024)).string("K, ");
                printGCLog.rational(this.timers.collection.getMeasuredNanos(), 1000000000L, 7L).string(" secs");
                printGCLog.string("]").newline();
            }
            if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
                verboseGCLog.string(" [");
                long finishNanos = this.timers.collection.getFinish();
                if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                } else {
                    verboseGCLog.unsigned(finishNanos);
                }
                verboseGCLog.string(" GC:").string(" after ").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
                verboseGCLog.string("  policy: ");
                verboseGCLog.string(this.getPolicy().getName());
                verboseGCLog.string("  type: ").string(this.completeCollection ? "complete" : "incremental");
                if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                    heap.report(verboseGCLog);
                }
                if (!HeapOptions.PrintGCTimes.getValue().booleanValue()) {
                    verboseGCLog.newline();
                    verboseGCLog.string("  collection time: ").unsigned(this.timers.collection.getMeasuredNanos()).string(" nanoSeconds");
                } else {
                    this.timers.logAfterCollection(verboseGCLog);
                }
                verboseGCLog.string("]");
                verboseGCLog.string("]").newline();
            }
        }
    }

    private static void precondition() {
        OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty before a collection.";
    }

    private void postcondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        this.verbosePostCondition();
        assert (youngGen.getEden().isEmpty()) : "youngGen.getEden() should be empty after a collection.";
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty after a collection.";
    }

    private void verbosePostCondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        boolean forceForTesting = false;
        if (GCImpl.runtimeAssertions()) {
            Log witness = Log.log();
            if (!youngGen.getEden().isEmpty()) {
                witness.string("[GCImpl.postcondition: Eden space should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    Eden space first AlignedChunk:   ").hex((WordBase)youngGen.getEden().getFirstAlignedHeapChunk()).newline();
                witness.string("    Eden space last  AlignedChunk:   ").hex((WordBase)youngGen.getEden().getLastAlignedHeapChunk()).newline();
                witness.string("    Eden space first UnalignedChunk: ").hex((WordBase)youngGen.getEden().getFirstUnalignedHeapChunk()).newline();
                witness.string("    Eden space last  UnalignedChunk: ").hex((WordBase)youngGen.getEden().getLastUnalignedHeapChunk()).newline();
                youngGen.getEden().report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because Eden space is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
            for (int i = 0; i < HeapPolicy.getMaxSurvivorSpaces(); ++i) {
                if (youngGen.getSurvivorToSpaceAt(i).isEmpty()) continue;
                witness.string("[GCImpl.postcondition: Survivor toSpace should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    Survivor space ").signed(i).string(" first AlignedChunk:   ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getFirstAlignedHeapChunk()).newline();
                witness.string("    Survivor space ").signed(i).string(" last  AlignedChunk:   ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getLastAlignedHeapChunk()).newline();
                witness.string("    Survivor space ").signed(i).string(" first UnalignedChunk: ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getFirstUnalignedHeapChunk()).newline();
                witness.string("    Survivor space ").signed(i).string(" last  UnalignedChunk: ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getLastUnalignedHeapChunk()).newline();
                youngGen.getSurvivorToSpaceAt(i).report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because Survivor toSpace is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
            if (!oldGen.getToSpace().isEmpty()) {
                witness.string("[GCImpl.postcondition: oldGen toSpace should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    oldGen toSpace first AlignedChunk:   ").hex((WordBase)oldGen.getToSpace().getFirstAlignedHeapChunk()).newline();
                witness.string("    oldGen toSpace last  AlignedChunk:   ").hex((WordBase)oldGen.getToSpace().getLastAlignedHeapChunk()).newline();
                witness.string("    oldGen.toSpace first UnalignedChunk: ").hex((WordBase)oldGen.getToSpace().getFirstUnalignedHeapChunk()).newline();
                witness.string("    oldGen.toSpace last  UnalignedChunk: ").hex((WordBase)oldGen.getToSpace().getLastUnalignedHeapChunk()).newline();
                oldGen.getToSpace().report(witness, true).newline();
                oldGen.getFromSpace().report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because oldGen toSpace is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
        }
    }

    @Fold
    static boolean runtimeAssertions() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(GCImpl.class);
    }

    @Fold
    public static GCImpl getGCImpl() {
        GCImpl gcImpl = HeapImpl.getHeapImpl().getGCImpl();
        assert (gcImpl != null);
        return gcImpl;
    }

    @Override
    public void collectCompletely(GCCause cause) {
        CollectionPolicy oldPolicy = this.getPolicy();
        try {
            this.setPolicy(this.collectOnlyCompletelyPolicy);
            this.collect(cause);
        }
        finally {
            this.setPolicy(oldPolicy);
        }
    }

    boolean isCompleteCollection() {
        return this.completeCollection;
    }

    private void scavenge(boolean fromDirtyRoots) {
        try (GreyToBlackObjRefVisitor.Counters gtborv = this.greyToBlackObjRefVisitor.openCounters();){
            Timer drt;
            Log trace = Log.noopLog().string("[GCImpl.scavenge:").string("  fromDirtyRoots: ").bool(fromDirtyRoots).newline();
            try (Timer rst = this.timers.rootScan.open();){
                trace.string("  Cheney scan: ");
                if (fromDirtyRoots) {
                    this.cheneyScanFromDirtyRoots();
                } else {
                    this.cheneyScanFromRoots();
                }
            }
            if (DeoptimizationSupport.enabled()) {
                drt = this.timers.cleanCodeCache.open();
                var6_8 = null;
                try {
                    this.cleanRuntimeCodeCache();
                }
                catch (Throwable throwable) {
                    var6_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (drt != null) {
                        if (var6_8 != null) {
                            try {
                                drt.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            drt.close();
                        }
                    }
                }
            }
            trace.string("  Discovered references: ");
            drt = this.timers.referenceObjects.open();
            var6_8 = null;
            try {
                Reference<?> newlyPendingList = ReferenceObjectProcessing.processRememberedReferences();
                HeapImpl.getHeapImpl().addToReferencePendingList(newlyPendingList);
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (drt != null) {
                    if (var6_8 != null) {
                        try {
                            drt.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        drt.close();
                    }
                }
            }
            trace.string("  Release spaces: ");
            rst = this.timers.releaseSpaces.open();
            var6_8 = null;
            try {
                assert (this.chunkReleaser.isEmpty());
                this.releaseSpaces();
                this.chunkReleaser.release();
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (rst != null) {
                    if (var6_8 != null) {
                        try {
                            rst.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        rst.close();
                    }
                }
            }
            trace.string("  Swap spaces: ");
            GCImpl.swapSpaces();
            trace.string("]").newline();
        }
    }

    private void walkRuntimeCodeCache() {
        try (Timer wrm = this.timers.walkRuntimeCodeCache.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheWalker);
        }
    }

    private void cleanRuntimeCodeCache() {
        try (Timer wrm = this.timers.cleanRuntimeCodeCache.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheCleaner);
        }
    }

    private void cheneyScanFromRoots() {
        Log trace = Log.noopLog().string("[GCImpl.cheneyScanFromRoots:").newline();
        try (Timer csfrt = this.timers.cheneyScanFromRoots.open();){
            GCImpl.prepareForPromotion(false);
            this.promoteIndividualPinnedObjects();
            this.blackenStackRoots();
            this.walkThreadLocals();
            this.blackenImageHeapRoots();
            this.scanGreyObjects(false);
            if (DeoptimizationSupport.enabled()) {
                this.walkRuntimeCodeCache();
                this.scanGreyObjects(false);
            }
            this.greyToBlackObjectVisitor.reset();
        }
        trace.string("]").newline();
    }

    private void cheneyScanFromDirtyRoots() {
        Log trace = Log.noopLog().string("[GCImpl.cheneyScanFromDirtyRoots:").newline();
        try (Timer csfdrt = this.timers.cheneyScanFromDirtyRoots.open();){
            OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
            oldGen.emptyFromSpaceIntoToSpace();
            GCImpl.prepareForPromotion(true);
            this.promoteIndividualPinnedObjects();
            this.blackenDirtyCardRoots();
            this.blackenStackRoots();
            this.walkThreadLocals();
            this.blackenDirtyImageHeapRoots();
            this.scanGreyObjects(true);
            if (DeoptimizationSupport.enabled()) {
                this.walkRuntimeCodeCache();
                this.scanGreyObjects(true);
            }
            this.greyToBlackObjectVisitor.reset();
        }
        trace.string("]").newline();
    }

    private void promoteIndividualPinnedObjects() {
        Log trace = Log.noopLog().string("[GCImpl.promoteIndividualPinnedObjects:").newline();
        try (Timer ppot = this.timers.promotePinnedObjects.open();){
            PinnedObjectImpl rest = PinnedObjectImpl.claimPinnedObjectList();
            while (rest != null) {
                PinnedObjectImpl first = rest;
                PinnedObjectImpl next = first.getNext();
                if (first.isOpen()) {
                    GCImpl.promotePinnedObject(first);
                    PinnedObjectImpl.pushPinnedObject(first);
                }
                rest = next;
            }
        }
        trace.string("]").newline();
    }

    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because GC stack frames must not access any objects that are processed by the GC. But we don't store stack frame information for the first frame we would need to process.")
    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.", calleeMustBe=false)
    private void blackenStackRoots() {
        Log trace = Log.noopLog().string("[GCImpl.blackenStackRoots:").newline();
        try (Timer bsr = this.timers.blackenStackRoots.open();){
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            trace.string("[blackenStackRoots:").string("  sp: ").hex((WordBase)sp);
            CodePointer ip = KnownIntrinsics.readReturnAddress();
            trace.string("  ip: ").hex((WordBase)ip).newline();
            JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
            JavaStackWalker.initWalk(walk, sp, ip);
            this.walkStack(walk);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread()) {
                        if (JavaStackWalker.initWalk(walk, vmThread)) {
                            this.walkStack(walk);
                        }
                        trace.newline();
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
            trace.string("]").newline();
        }
        trace.string("]").newline();
    }

    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.", calleeMustBe=false)
    private void walkStack(JavaStackWalk walk) {
        DeoptimizedFrame deoptFrame;
        SimpleCodeInfoQueryResult queryResult;
        assert (VMOperation.isGCInProgress()) : "This methods accesses a CodeInfo without a tether";
        do {
            queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
            Pointer sp = walk.getSP();
            CodePointer ip = walk.getPossiblyStaleIP();
            CodeInfo codeInfo = CodeInfoAccess.convert(walk.getIPCodeInfo());
            deoptFrame = Deoptimizer.checkDeoptimized(sp);
            if (deoptFrame == null) {
                if (codeInfo.isNull()) {
                    throw JavaStackWalker.reportUnknownFrameEncountered(sp, ip, deoptFrame);
                }
                CodeInfoAccess.lookupCodeInfo(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip), queryResult);
                assert (Deoptimizer.checkDeoptimized(sp) == null) : "We are at a safepoint, so no deoptimization can have happened even though looking up the code info is not uninterruptible";
                NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
                long referenceMapIndex = queryResult.getReferenceMapIndex();
                if (referenceMapIndex == -1L) {
                    throw CodeInfoTable.reportNoReferenceMap(sp, ip, codeInfo);
                }
                CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)sp, referenceMapEncoding, referenceMapIndex, this.greyToBlackObjRefVisitor);
            }
            if (!DeoptimizationSupport.enabled() || codeInfo == CodeInfoTable.getImageCodeInfo()) continue;
            RuntimeCodeInfoAccess.walkStrongReferences(codeInfo, this.greyToBlackObjRefVisitor);
            RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.greyToBlackObjRefVisitor);
        } while (JavaStackWalker.continueWalk(walk, queryResult, deoptFrame));
    }

    private void walkThreadLocals() {
        Log trace = Log.noopLog().string("[walkRegisteredObjectReferences").string(":").newline();
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            try (Timer wrm = this.timers.walkThreadLocals.open();){
                trace.string("[ThreadLocalsWalker:").newline();
                ThreadLocalMTWalker.walk(this.greyToBlackObjRefVisitor);
                trace.string("]").newline();
            }
        }
        trace.string("]").newline();
    }

    private void blackenDirtyImageHeapRoots() {
        if (!HeapImpl.usesImageHeapCardMarking()) {
            this.blackenImageHeapRoots();
            return;
        }
        Log trace = Log.noopLog().string("[blackenDirtyImageHeapRoots:").newline();
        try (Timer timer = this.timers.blackenImageHeapRoots.open();){
            ImageHeapInfo info = HeapImpl.getImageHeapInfo();
            AlignedHeapChunk.AlignedHeader aligned = (AlignedHeapChunk.AlignedHeader)GCImpl.asImageHeapChunk(info.offsetOfFirstAlignedChunkWithRememberedSet);
            while (aligned.isNonNull()) {
                AlignedHeapChunk.walkDirtyObjects(aligned, this.greyToBlackObjectVisitor, true);
                aligned = HeapChunk.getNext(aligned);
            }
            UnalignedHeapChunk.UnalignedHeader unaligned = (UnalignedHeapChunk.UnalignedHeader)GCImpl.asImageHeapChunk(info.offsetOfFirstUnalignedChunkWithRememberedSet);
            while (unaligned.isNonNull()) {
                UnalignedHeapChunk.walkDirtyObjects(unaligned, this.greyToBlackObjectVisitor, true);
                unaligned = HeapChunk.getNext(unaligned);
            }
        }
        trace.string("]").newline();
    }

    private static <T extends HeapChunk.Header<T>> T asImageHeapChunk(long offsetInImageHeap) {
        if (offsetInImageHeap < 0L) {
            return (T)((HeapChunk.Header)WordFactory.nullPointer());
        }
        UnsignedWord offset = WordFactory.unsigned((long)offsetInImageHeap);
        return (T)((HeapChunk.Header)KnownIntrinsics.heapBase().add(offset));
    }

    private void blackenImageHeapRoots() {
        Log trace = Log.noopLog().string("[blackenImageHeapRoots:").newline();
        try (Timer timer = this.timers.blackenImageHeapRoots.open();){
            HeapImpl.getHeapImpl().walkNativeImageHeapRegions(this.blackenImageHeapRootsVisitor);
        }
        trace.string("]").newline();
    }

    private void blackenDirtyCardRoots() {
        Log trace = Log.noopLog().string("[GCImpl.blackenDirtyCardRoots:").newline();
        try (Timer bdcrt = this.timers.blackenDirtyCardRoots.open();){
            HeapImpl heap = HeapImpl.getHeapImpl();
            heap.getOldGeneration().walkDirtyObjects(this.greyToBlackObjectVisitor, true);
        }
        trace.string("]").newline();
    }

    private static void prepareForPromotion(boolean isIncremental) {
        Log trace = Log.noopLog().string("[GCImpl.prepareForPromotion:").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        oldGen.prepareForPromotion();
        if (isIncremental) {
            heap.getYoungGeneration().prepareForPromotion();
        }
        trace.string("]").newline();
    }

    private void scanGreyObjects(boolean isIncremental) {
        Log trace = Log.noopLog().string("[GCImpl.scanGreyObjects").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        try (Timer sgot = this.timers.scanGreyObjects.open();){
            if (isIncremental) {
                GCImpl.scanGreyObjectsLoop();
            } else {
                oldGen.scanGreyObjects();
            }
        }
        trace.string("]").newline();
    }

    private static void scanGreyObjectsLoop() {
        Log trace = Log.noopLog().string("[GCImpl.scanGreyObjectsLoop").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        for (boolean hasGrey = true; hasGrey; hasGrey |= oldGen.scanGreyObjects()) {
            hasGrey = youngGen.scanGreyObjects();
        }
        trace.string("]").newline();
    }

    private static void promotePinnedObject(PinnedObjectImpl pinned) {
        Log trace = Log.noopLog().string("[GCImpl.promotePinnedObject").string("  pinned: ").object(pinned);
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        Object referent = pinned.getObject();
        if (referent != null && !heap.isInImageHeap(referent)) {
            trace.string("  referent: ").object(referent);
            oldGen.promoteObjectChunk(referent);
        }
        trace.string("]").newline();
    }

    private static void swapSpaces() {
        Log trace = Log.noopLog().string("[GCImpl.swapSpaces:");
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        heap.getYoungGeneration().swapSpaces();
        oldGen.swapSpaces();
        trace.string("]").newline();
    }

    private void releaseSpaces() {
        Log trace = Log.noopLog().string("[GCImpl.releaseSpaces:");
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.getYoungGeneration().releaseSpaces(this.chunkReleaser);
        if (this.completeCollection) {
            heap.getOldGeneration().releaseSpaces(this.chunkReleaser);
        }
        trace.string("]").newline();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isCollectionInProgress() {
        return this.collectionInProgress;
    }

    private void startCollectionOrExit() {
        CollectionInProgressError.exitIf(this.collectionInProgress);
        this.collectionInProgress = true;
    }

    private void finishCollection() {
        assert (this.collectionInProgress);
        this.collectionInProgress = false;
    }

    UnsignedWord possibleCollectionPrologue() {
        return this.getCollectionEpoch();
    }

    void possibleCollectionEpilogue(UnsignedWord requestingEpoch) {
        if (requestingEpoch.aboveOrEqual(this.getCollectionEpoch())) {
            return;
        }
        if (VMOperation.isInProgress()) {
            return;
        }
        if (!JavaThreads.currentJavaThreadInitialized()) {
            return;
        }
        Timer refsTimer = new Timer("Enqueuing pending references and invoking internal cleaners");
        try (Timer timer = refsTimer.open();){
            ReferenceHandler.maybeProcessCurrentlyPending();
        }
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue() && HeapOptions.PrintGCTimes.getValue().booleanValue()) {
            Timers.logOneTimer(Log.log(), "[GC epilogue reference processing: ", refsTimer);
            Log.log().string("]");
        }
    }

    public UnsignedWord getCollectionEpoch() {
        return this.collectionEpoch;
    }

    public GCAccounting getAccounting() {
        return this.accounting;
    }

    public CollectionPolicy getPolicy() {
        return this.policy;
    }

    private void setPolicy(CollectionPolicy newPolicy) {
        this.policy = newPolicy;
    }

    GreyToBlackObjectVisitor getGreyToBlackObjectVisitor() {
        return this.greyToBlackObjectVisitor;
    }

    RememberedSetConstructor getRememberedSetConstructor() {
        return this.rememberedSetConstructor;
    }

    private void printGCSummary() {
        if (!HeapOptions.PrintGCSummary.getValue().booleanValue()) {
            return;
        }
        Log log = Log.log();
        String prefix = "PrintGCSummary: ";
        log.string("PrintGCSummary: ").string("YoungGenerationSize: ").unsigned((WordBase)HeapPolicy.getMaximumYoungGenerationSize()).newline();
        log.string("PrintGCSummary: ").string("MinimumHeapSize: ").unsigned((WordBase)HeapPolicy.getMinimumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("MaximumHeapSize: ").unsigned((WordBase)HeapPolicy.getMaximumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("AlignedChunkSize: ").unsigned((WordBase)HeapPolicy.getAlignedHeapChunkSize()).newline();
        JavaVMOperation.enqueueBlockingSafepoint("PrintGCSummaryShutdownHook", ThreadLocalAllocation::disableAndFlushForAllThreads);
        HeapImpl heap = HeapImpl.getHeapImpl();
        Space edenSpace = heap.getYoungGeneration().getEden();
        UnsignedWord youngChunkBytes = edenSpace.getChunkBytes();
        UnsignedWord youngObjectBytes = edenSpace.computeObjectBytes();
        UnsignedWord allocatedChunkBytes = this.accounting.getAllocatedChunkBytes().add(youngChunkBytes);
        UnsignedWord allocatedObjectBytes = this.accounting.getAllocatedObjectBytes().add(youngObjectBytes);
        log.string("PrintGCSummary: ").string("CollectedTotalChunkBytes: ").signed((WordBase)this.accounting.getCollectedTotalChunkBytes()).newline();
        log.string("PrintGCSummary: ").string("CollectedTotalObjectBytes: ").signed((WordBase)this.accounting.getCollectedTotalObjectBytes()).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalChunkBytes: ").signed((WordBase)allocatedChunkBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalObjectBytes: ").signed((WordBase)allocatedObjectBytes).newline();
        long incrementalNanos = this.accounting.getIncrementalCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("IncrementalGCCount: ").signed(this.accounting.getIncrementalCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("IncrementalGCNanos: ").signed(incrementalNanos).newline();
        long completeNanos = this.accounting.getCompleteCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("CompleteGCCount: ").signed(this.accounting.getCompleteCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("CompleteGCNanos: ").signed(completeNanos).newline();
        long gcNanos = incrementalNanos + completeNanos;
        long mutatorNanos = this.timers.mutator.getMeasuredNanos();
        long totalNanos = gcNanos + mutatorNanos;
        long roundedGCLoad = 0L < totalNanos ? TimeUtils.roundedDivide(100L * gcNanos, totalNanos) : 0L;
        log.string("PrintGCSummary: ").string("GCNanos: ").signed(gcNanos).newline();
        log.string("PrintGCSummary: ").string("TotalNanos: ").signed(totalNanos).newline();
        log.string("PrintGCSummary: ").string("GCLoadPercent: ").signed(roundedGCLoad).newline();
    }

    public static class ChunkReleaser {
        private AlignedHeapChunk.AlignedHeader firstAligned;
        private UnalignedHeapChunk.UnalignedHeader firstUnaligned;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ChunkReleaser() {
        }

        public boolean isEmpty() {
            return this.firstAligned.isNull() && this.firstUnaligned.isNull();
        }

        public void add(AlignedHeapChunk.AlignedHeader chunks) {
            if (chunks.isNonNull()) {
                assert (HeapChunk.getPrevious(chunks).isNull()) : "prev must be null";
                if (this.firstAligned.isNonNull()) {
                    AlignedHeapChunk.AlignedHeader lastNewChunk = ChunkReleaser.getLast(chunks);
                    HeapChunk.setNext(lastNewChunk, this.firstAligned);
                    HeapChunk.setPrevious(this.firstAligned, lastNewChunk);
                }
                this.firstAligned = chunks;
            }
        }

        public void add(UnalignedHeapChunk.UnalignedHeader chunks) {
            if (chunks.isNonNull()) {
                assert (HeapChunk.getPrevious(chunks).isNull()) : "prev must be null";
                if (this.firstUnaligned.isNonNull()) {
                    UnalignedHeapChunk.UnalignedHeader lastNewChunk = ChunkReleaser.getLast(chunks);
                    HeapChunk.setNext(lastNewChunk, this.firstUnaligned);
                    HeapChunk.setPrevious(this.firstUnaligned, lastNewChunk);
                }
                this.firstUnaligned = chunks;
            }
        }

        void release() {
            if (this.firstAligned.isNonNull()) {
                HeapImpl.getChunkProvider().consumeAlignedChunks(this.firstAligned);
                this.firstAligned = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
            }
            if (this.firstUnaligned.isNonNull()) {
                HeapChunkProvider.consumeUnalignedChunks(this.firstUnaligned);
                this.firstUnaligned = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
            }
        }

        private static <T extends HeapChunk.Header<T>> T getLast(T chunks) {
            T prev = chunks;
            Object next = HeapChunk.getNext(prev);
            while (next.isNonNull()) {
                prev = next;
                next = HeapChunk.getNext(prev);
            }
            return prev;
        }
    }

    @RawStructure
    private static interface CollectionVMOperationData
    extends NativeVMOperationData {
        @RawField
        public int getCauseId();

        @RawField
        public void setCauseId(int var1);

        @RawField
        public UnsignedWord getRequestingEpoch();

        @RawField
        public void setRequestingEpoch(UnsignedWord var1);

        @RawField
        public boolean getOutOfMemory();

        @RawField
        public void setOutOfMemory(boolean var1);
    }

    private static class CollectionVMOperation
    extends NativeVMOperation {
        CollectionVMOperation() {
            super("Garbage collection", VMOperation.SystemEffect.SAFEPOINT);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean isGC() {
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while collecting")
        protected void operate(NativeVMOperationData data) {
            ImplicitExceptions.activateImplicitExceptionsAreFatal();
            try {
                CollectionVMOperationData d = (CollectionVMOperationData)data;
                boolean outOfMemory = HeapImpl.getHeapImpl().getGCImpl().collectOperation(GCCause.fromId(d.getCauseId()), d.getRequestingEpoch());
                d.setOutOfMemory(outOfMemory);
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere(t);
            }
            finally {
                ImplicitExceptions.deactivateImplicitExceptionsAreFatal();
            }
        }

        @Override
        protected boolean hasWork(NativeVMOperationData data) {
            CollectionVMOperationData d = (CollectionVMOperationData)data;
            return HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch().equal(d.getRequestingEpoch());
        }
    }

    static final class CollectionInProgressError
    extends Error {
        private static final CollectionInProgressError SINGLETON = new CollectionInProgressError();

        static void exitIf(boolean state) {
            if (state) {
                Log failure = Log.log();
                failure.string("[CollectionInProgressError:");
                failure.newline();
                ThreadStackPrinter.printBacktrace();
                failure.string("]").newline();
                throw SINGLETON;
            }
        }

        private CollectionInProgressError() {
        }
    }

    static class RememberedSetConstructor
    implements ObjectVisitor {
        private AlignedHeapChunk.AlignedHeader chunk;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        RememberedSetConstructor() {
        }

        public void initialize(AlignedHeapChunk.AlignedHeader aChunk) {
            this.chunk = aChunk;
        }

        @Override
        public boolean visitObject(Object o) {
            return this.visitObjectInline(o);
        }

        @Override
        @AlwaysInline(value="GC performance")
        public boolean visitObjectInline(Object o) {
            AlignedHeapChunk.setUpRememberedSetForObject(this.chunk, o);
            return true;
        }

        public void reset() {
            this.chunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        }
    }

    private class BlackenImageHeapRootsVisitor
    implements MemoryWalker.ImageHeapRegionVisitor {
        private BlackenImageHeapRootsVisitor() {
        }

        @Override
        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (access.containsReferences(region) && access.isWritable(region)) {
                access.visitObjects(region, GCImpl.this.greyToBlackObjectVisitor);
            }
            return true;
        }
    }
}

