/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ReflectionConfigurationParser<T>
extends ConfigurationParser {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final ReflectionConfigurationParserDelegate<T> delegate;
    private final boolean allowIncompleteClasspath;
    private static final List<String> OPTIONAL_REFLECT_CONFIG_OBJECT_ATTRS = Arrays.asList("allDeclaredConstructors", "allPublicConstructors", "allDeclaredMethods", "allPublicMethods", "allDeclaredFields", "allPublicFields", "allDeclaredClasses", "allPublicClasses", "methods", "fields");

    public ReflectionConfigurationParser(ReflectionConfigurationParserDelegate<T> delegate) {
        this(delegate, false, true);
    }

    public ReflectionConfigurationParser(ReflectionConfigurationParserDelegate<T> delegate, boolean allowIncompleteClasspath, boolean strictConfiguration) {
        super(strictConfiguration);
        this.delegate = delegate;
        this.allowIncompleteClasspath = allowIncompleteClasspath;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        this.parseClassArray(ReflectionConfigurationParser.asList(json, "first level of document must be an array of class descriptors"));
    }

    private void parseClassArray(List<Object> classes) {
        for (Object clazz : classes) {
            this.parseClass(ReflectionConfigurationParser.asMap(clazz, "second level of document must be class descriptor objects"));
        }
    }

    private void parseClass(Map<String, Object> data) {
        this.checkAttributes(data, "reflection class descriptor object", Collections.singleton("name"), OPTIONAL_REFLECT_CONFIG_OBJECT_ATTRS);
        Object classObject = data.get("name");
        String className = ReflectionConfigurationParser.asString(classObject, "name");
        T clazz = this.delegate.resolveType(className);
        if (clazz == null) {
            this.handleError("Could not resolve " + className + " for reflection configuration.");
            return;
        }
        this.delegate.registerType(clazz);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                switch (name) {
                    case "allDeclaredConstructors": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredConstructors")) break;
                        this.delegate.registerDeclaredConstructors(clazz);
                        break;
                    }
                    case "allPublicConstructors": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPublicConstructors")) break;
                        this.delegate.registerPublicConstructors(clazz);
                        break;
                    }
                    case "allDeclaredMethods": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredMethods")) break;
                        this.delegate.registerDeclaredMethods(clazz);
                        break;
                    }
                    case "allPublicMethods": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPublicMethods")) break;
                        this.delegate.registerPublicMethods(clazz);
                        break;
                    }
                    case "allDeclaredFields": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredFields")) break;
                        this.delegate.registerDeclaredFields(clazz);
                        break;
                    }
                    case "allPublicFields": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPublicFields")) break;
                        this.delegate.registerPublicFields(clazz);
                        break;
                    }
                    case "allDeclaredClasses": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredClasses")) break;
                        this.delegate.registerDeclaredClasses(clazz);
                        break;
                    }
                    case "allPublicClasses": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPublicClasses")) break;
                        this.delegate.registerPublicClasses(clazz);
                        break;
                    }
                    case "methods": {
                        this.parseMethods(ReflectionConfigurationParser.asList(value, "Attribute 'methods' must be an array of method descriptors"), clazz);
                        break;
                    }
                    case "fields": {
                        this.parseFields(ReflectionConfigurationParser.asList(value, "Attribute 'fields' must be an array of field descriptors"), clazz);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                this.handleError("Could not register " + this.delegate.getTypeName(clazz) + ": " + name + " for reflection. Reason: " + ReflectionConfigurationParser.formatError(e) + ".");
            }
        }
    }

    private void parseFields(List<Object> fields, T clazz) {
        for (Object field : fields) {
            this.parseField(ReflectionConfigurationParser.asMap(field, "Elements of 'fields' array must be field descriptor objects"), clazz);
        }
    }

    private void parseField(Map<String, Object> data, T clazz) {
        this.checkAttributes(data, "reflection field descriptor object", Collections.singleton("name"), Arrays.asList("allowWrite", "allowUnsafeAccess"));
        String fieldName = ReflectionConfigurationParser.asString(data.get("name"), "name");
        boolean allowWrite = data.containsKey("allowWrite") && ReflectionConfigurationParser.asBoolean(data.get("allowWrite"), "allowWrite");
        boolean allowUnsafeAccess = data.containsKey("allowUnsafeAccess") && ReflectionConfigurationParser.asBoolean(data.get("allowUnsafeAccess"), "allowUnsafeAccess");
        try {
            this.delegate.registerField(clazz, fieldName, allowWrite, allowUnsafeAccess);
        }
        catch (NoSuchFieldException e) {
            this.handleError("Field " + this.delegate.getTypeName(clazz) + "." + fieldName + " not found.");
        }
        catch (NoClassDefFoundError e) {
            this.handleError("Could not register field " + this.delegate.getTypeName(clazz) + "." + fieldName + " for reflection. Reason: " + ReflectionConfigurationParser.formatError(e) + ".");
        }
    }

    private void parseMethods(List<Object> methods, T clazz) {
        for (Object method : methods) {
            this.parseMethod(ReflectionConfigurationParser.asMap(method, "Elements of 'methods' array must be method descriptor objects"), clazz);
        }
    }

    private void parseMethod(Map<String, Object> data, T clazz) {
        block10: {
            this.checkAttributes(data, "reflection method descriptor object", Collections.singleton("name"), Collections.singleton("parameterTypes"));
            String methodName = ReflectionConfigurationParser.asString(data.get("name"), "name");
            List<T> methodParameterTypes = null;
            Object parameterTypes = data.get("parameterTypes");
            if (parameterTypes != null && (methodParameterTypes = this.parseMethodParameters(clazz, methodName, ReflectionConfigurationParser.asList(parameterTypes, "Attribute 'parameterTypes' must be a list of type names"))) == null) {
                return;
            }
            boolean isConstructor = CONSTRUCTOR_NAME.equals(methodName);
            if (methodParameterTypes != null) {
                try {
                    if (isConstructor) {
                        this.delegate.registerConstructor(clazz, methodParameterTypes);
                        break block10;
                    }
                    this.delegate.registerMethod(clazz, methodName, methodParameterTypes);
                }
                catch (NoSuchMethodException e) {
                    this.handleError("Method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " not found.");
                }
                catch (NoClassDefFoundError e) {
                    this.handleError("Could not register method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " for reflection. Reason: " + ReflectionConfigurationParser.formatError(e) + ".");
                }
            } else {
                try {
                    boolean found = isConstructor ? this.delegate.registerAllConstructors(clazz) : this.delegate.registerAllMethodsWithName(clazz, methodName);
                    if (!found) {
                        throw new JSONParserException("Method " + this.delegate.getTypeName(clazz) + "." + methodName + " not found");
                    }
                }
                catch (NoClassDefFoundError e) {
                    this.handleError("Could not register method " + this.delegate.getTypeName(clazz) + "." + methodName + " for reflection. Reason: " + ReflectionConfigurationParser.formatError(e) + ".");
                }
            }
        }
    }

    private List<T> parseMethodParameters(T clazz, String methodName, List<Object> types) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object type : types) {
            String typeName = ReflectionConfigurationParser.asString(type, "types");
            T typeClazz = this.delegate.resolveType(typeName);
            if (typeClazz == null) {
                this.handleError("Could not register method " + this.formatMethod(clazz, methodName, Collections.emptyList()) + " for reflection. Class " + typeName + " not found.");
                return null;
            }
            result.add(typeClazz);
        }
        return result;
    }

    private static String formatError(Error e) {
        return e.getClass().getTypeName() + ": " + e.getMessage();
    }

    private String formatMethod(T clazz, String methodName, List<T> paramTypes) {
        String parameterTypeNames = paramTypes.stream().map(this.delegate::getSimpleName).collect(Collectors.joining(", "));
        return this.delegate.getTypeName(clazz) + "." + methodName + "(" + parameterTypeNames + ")";
    }

    private void handleError(String message) {
        if (!this.allowIncompleteClasspath) {
            throw new JSONParserException(message + " To allow unresolvable reflection configuration, use option -H:+AllowIncompleteClasspath");
        }
        System.out.println("WARNING: " + message);
    }
}

