/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.ExcludeFromReferenceMap;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownClass;
import com.oracle.svm.core.heap.ComputeQueueValue;
import com.oracle.svm.core.heap.ComputeReferenceValue;
import com.oracle.svm.core.heap.NotCardRememberedSetHeap;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.Target_java_lang_ref_ReferenceQueue;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.UnsupportedCloneMethod;
import java.lang.ref.Reference;
import org.graalvm.compiler.api.directives.GraalDirectives;

@UnknownClass
@TargetClass(value=Reference.class)
@Substitute
public final class Target_java_lang_ref_Reference<T> {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, name="referent", declClass=Target_java_lang_ref_Reference.class)
    static long referentFieldOffset;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, name="discovered", declClass=Target_java_lang_ref_Reference.class)
    static long discoveredFieldOffset;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ComputeReferenceValue.class)
    @ExcludeFromReferenceMap(reason="Field is manually processed by the garbage collector.")
    T referent;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    @ExcludeFromReferenceMap(reason="Some GCs process this field manually.", onlyIf=NotCardRememberedSetHeap.class)
    transient Target_java_lang_ref_Reference<?> discovered;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ComputeQueueValue.class)
    volatile Target_java_lang_ref_ReferenceQueue<? super T> queue;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    volatile Reference<?> next;

    @Substitute
    Target_java_lang_ref_Reference(T referent) {
        this(referent, null);
    }

    @Substitute
    @Uninterruptible(reason="The initialization of the fields must be atomic with respect to collection.")
    Target_java_lang_ref_Reference(T referent, Target_java_lang_ref_ReferenceQueue<? super T> queue) {
        this.referent = referent;
        this.queue = queue == null ? Target_java_lang_ref_ReferenceQueue.NULL : queue;
    }

    @KeepOriginal
    native T get();

    @KeepOriginal
    native void clear();

    @KeepOriginal
    native boolean enqueue();

    @KeepOriginal
    native boolean isEnqueued();

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    static boolean tryHandlePending(boolean waitForNotify) {
        try {
            return ReferenceInternals.waitForReferenceProcessing();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    static boolean waitForReferenceProcessing() throws InterruptedException {
        return ReferenceInternals.waitForReferenceProcessing();
    }

    @KeepOriginal
    @TargetElement(onlyWith={UnsupportedCloneMethod.class})
    protected native Object clone() throws CloneNotSupportedException;

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    static void reachabilityFence(Object ref) {
        GraalDirectives.blackhole((Object)ref);
    }
}

