/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UnsignedUtils;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class ReferenceObjectProcessing {
    private static Reference<?> rememberedRefsList;
    private static UnsignedWord maxSoftRefAccessIntervalMs;
    private static boolean softReferencesAreWeak;
    private static long initialSoftRefClock;

    private ReferenceObjectProcessing() {
    }

    public static void setSoftReferencesAreWeak(boolean enabled) {
        softReferencesAreWeak = enabled;
    }

    @AlwaysInline(value="GC performance")
    public static void discoverIfReference(Object object, ObjectReferenceVisitor refVisitor) {
        assert (object != null);
        DynamicHub hub = KnownIntrinsics.readHub(object);
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)hub.isReferenceInstanceClass())) {
            ReferenceObjectProcessing.discover(object, refVisitor);
        }
    }

    private static void discover(Object obj, ObjectReferenceVisitor refVisitor) {
        Reference dr = KnownIntrinsics.convertUnknownValue(obj, Reference.class);
        Log trace = Log.noopLog().string("[ReferenceObjectProcessing.discover: ").object(dr);
        if (ReferenceInternals.getDiscoveredPointer(dr).isNonNull()) {
            trace.string(" already discovered]").newline();
            return;
        }
        Pointer referentAddr = ReferenceInternals.getReferentPointer(dr);
        trace.string(" referent: ").hex((WordBase)referentAddr);
        if (referentAddr.isNull()) {
            trace.string(" is inactive]").newline();
            return;
        }
        if (Heap.getHeap().isInImageHeap(referentAddr)) {
            trace.string(" is in image heap]").newline();
            return;
        }
        if (ReferenceObjectProcessing.maybeUpdateForwardedReference(dr, referentAddr)) {
            trace.string(" has already been promoted and field has been updated]").newline();
            return;
        }
        if (ReferenceObjectProcessing.willSurviveThisCollection(referentAddr.toObject())) {
            HeapImpl.getHeapImpl().dirtyCardIfNecessary(dr, referentAddr.toObject());
            trace.string(" referent is in a to-space]").newline();
            return;
        }
        if (!softReferencesAreWeak && dr instanceof SoftReference) {
            UnsignedWord elapsed;
            long clock = ReferenceInternals.getSoftReferenceClock();
            long timestamp = ReferenceInternals.getSoftReferenceTimestamp((SoftReference)dr);
            if (timestamp == 0L) {
                timestamp = initialSoftRefClock;
            }
            if ((elapsed = WordFactory.unsigned((long)(clock - timestamp))).belowThan(maxSoftRefAccessIntervalMs)) {
                refVisitor.visitObjectReference(ReferenceInternals.getReferentFieldAddress(dr), true);
                return;
            }
        }
        trace.string(" remembered to revisit later]").newline();
        Reference next = rememberedRefsList != null ? rememberedRefsList : dr;
        ReferenceInternals.setNextDiscovered(dr, next);
        rememberedRefsList = dr;
    }

    static Reference<?> processRememberedReferences() {
        Reference<?> pendingHead = null;
        Reference<?> current = ReferenceObjectProcessing.popRememberedRef();
        while (current != null) {
            if (!ReferenceObjectProcessing.processRememberedRef(current)) {
                if (ReferenceInternals.hasQueue(current)) {
                    ReferenceInternals.setNextDiscovered(current, pendingHead);
                    pendingHead = current;
                }
                HeapImpl.getHeapImpl().dirtyCardIfNecessary(current, pendingHead);
            }
            current = ReferenceObjectProcessing.popRememberedRef();
        }
        assert (rememberedRefsList == null);
        return pendingHead;
    }

    static void afterCollection(UnsignedWord usedBytes, UnsignedWord maxBytes) {
        assert (rememberedRefsList == null);
        UnsignedWord unusedMbytes = maxBytes.subtract(usedBytes).unsignedDivide(0x100000);
        maxSoftRefAccessIntervalMs = unusedMbytes.multiply(HeapOptions.SoftRefLRUPolicyMSPerMB.getValue().intValue());
        ReferenceInternals.updateSoftReferenceClock();
        if (initialSoftRefClock == 0L) {
            initialSoftRefClock = ReferenceInternals.getSoftReferenceClock();
        }
    }

    private static boolean processRememberedRef(Reference<?> dr) {
        Pointer refPointer = ReferenceInternals.getReferentPointer(dr);
        if (refPointer.isNull()) {
            return true;
        }
        assert (!HeapImpl.getHeapImpl().isInImageHeap(refPointer)) : "Image heap referent: should not have been discovered";
        if (ReferenceObjectProcessing.maybeUpdateForwardedReference(dr, refPointer)) {
            return true;
        }
        Object refObject = refPointer.toObject();
        if (ReferenceObjectProcessing.willSurviveThisCollection(refObject)) {
            HeapImpl.getHeapImpl().dirtyCardIfNecessary(dr, refObject);
            return true;
        }
        ReferenceInternals.clear(dr);
        return false;
    }

    private static boolean maybeUpdateForwardedReference(Reference<?> dr, Pointer referentAddr) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(referentAddr);
        if (ObjectHeaderImpl.isForwardedHeader(header)) {
            Word forwardedPointer = Word.objectToUntrackedPointer((Object)ObjectHeaderImpl.getForwardedObject(referentAddr));
            ReferenceInternals.setReferentPointer(dr, (Pointer)forwardedPointer);
            HeapImpl.getHeapImpl().dirtyCardIfNecessary(dr, forwardedPointer.toObject());
            return true;
        }
        return false;
    }

    private static boolean willSurviveThisCollection(Object obj) {
        HeapChunk.Header<?> chunk = HeapChunk.getEnclosingHeapChunk(obj);
        Space space = HeapChunk.getSpace(chunk);
        return !space.isFromSpace();
    }

    private static Reference<?> popRememberedRef() {
        Reference<?> result = rememberedRefsList;
        if (result != null) {
            Reference<?> next = ReferenceInternals.getNextDiscovered(result);
            rememberedRefsList = next != result ? next : null;
            ReferenceInternals.setNextDiscovered(result, null);
        }
        return result;
    }

    public static boolean verify(Reference<?> dr) {
        boolean refOldTo;
        Pointer refPointer = ReferenceInternals.getReferentPointer(dr);
        int refClassification = HeapVerifier.classifyPointer(refPointer);
        if (refClassification < 0) {
            Log witness = Log.log();
            witness.string("[ReferenceObjectProcessing.verify:");
            witness.string("  epoch: ").unsigned((WordBase)HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch());
            witness.string("  refClassification: ").signed(refClassification);
            witness.string("]").newline();
            assert (refClassification >= 0) : "Bad referent.";
            return false;
        }
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        boolean refNull = refPointer.isNull();
        boolean refBootImage = !refNull && heap.isInImageHeapSlow(refPointer);
        boolean refYoung = !refNull && youngGen.slowlyFindPointer(refPointer);
        boolean refOldFrom = !refNull && oldGen.slowlyFindPointerInFromSpace(refPointer);
        boolean bl = refOldTo = !refNull && oldGen.slowlyFindPointerInToSpace(refPointer);
        if (!(refNull || refYoung || refBootImage || refOldFrom)) {
            Log witness = Log.log();
            witness.string("[ReferenceObjectProcessing.verify:");
            witness.string("  epoch: ").unsigned((WordBase)HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch());
            witness.string("  refBootImage: ").bool(refBootImage);
            witness.string("  refYoung: ").bool(refYoung);
            witness.string("  refOldFrom: ").bool(refOldFrom);
            witness.string("  referent should be in heap.");
            witness.string("]").newline();
            return false;
        }
        assert (!refOldTo) : "referent should be in the heap.";
        return true;
    }

    static {
        maxSoftRefAccessIntervalMs = UnsignedUtils.MAX_VALUE;
        softReferencesAreWeak = false;
        initialSoftRefClock = 0L;
    }
}

