/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public class FatalAssertions {
    public static final Map<Executable, SnippetRuntime.SubstrateForeignCallDescriptor> FOREIGN_CALLS = new HashMap<Executable, SnippetRuntime.SubstrateForeignCallDescriptor>();

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertion(Object receiver) {
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionString(Object receiver, String detailMessage) {
        FatalAssertions.fatalAssertionObject(receiver, detailMessage);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionObject(Object receiver, Object detailMessage) {
        if (detailMessage instanceof String) {
            FatalAssertions.runtimeAssertionPrefix().string((String)detailMessage).newline();
        } else {
            FatalAssertions.runtimeAssertionPrefix().object(detailMessage).newline();
        }
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionBoolean(Object receiver, boolean detailMessage) {
        FatalAssertions.runtimeAssertionPrefix().bool(detailMessage).newline();
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionChar(Object receiver, char detailMessage) {
        FatalAssertions.runtimeAssertionPrefix().character(detailMessage).newline();
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionInt(Object receiver, int detailMessage) {
        FatalAssertions.runtimeAssertionPrefix().signed(detailMessage).newline();
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionLong(Object receiver, long detailMessage) {
        FatalAssertions.runtimeAssertionPrefix().signed(detailMessage).newline();
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionFloat(Object receiver, float detailMessage) {
        FatalAssertions.runtimeAssertionPrefix().string("[float number supressed]").newline();
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionDouble(Object receiver, double detailMessage) {
        FatalAssertions.runtimeAssertionPrefix().string("[double number supressed]").newline();
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an assertion in code that must not allocate.")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void fatalAssertionStringThrowable(Object receiver, String detailMessage, Throwable cause) {
        FatalAssertions.runtimeAssertionPrefix().string(detailMessage).string(" caused by ").object(cause).newline();
        throw VMError.shouldNotReachHere(FatalAssertions.assertionErrorName());
    }

    private static String assertionErrorName() {
        return AssertionError.class.getName();
    }

    private static Log runtimeAssertionPrefix() {
        return Log.log().string(FatalAssertions.assertionErrorName()).string(": ");
    }

    static {
        for (Constructor<?> c : AssertionError.class.getDeclaredConstructors()) {
            StringBuilder methodName = new StringBuilder("fatalAssertion");
            for (Class<?> parameterType : c.getParameterTypes()) {
                if (parameterType.isPrimitive()) {
                    methodName.append(JavaKind.fromJavaClass(parameterType).name());
                    continue;
                }
                methodName.append(parameterType.getSimpleName());
            }
            FOREIGN_CALLS.put(c, SnippetRuntime.findForeignCall(FatalAssertions.class, methodName.toString(), true, LocationIdentity.any()));
        }
    }
}

