/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedDecision;
import com.oracle.svm.truffle.isolated.IsolatedTruffleCallNode;
import com.oracle.svm.truffle.isolated.IsolatedTruffleSourceLanguagePosition;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.ComparableWord;

abstract class IsolatedTruffleInlining<T extends TruffleInliningPlan>
extends IsolatedObjectProxy<T>
implements TruffleInliningPlan {
    IsolatedTruffleInlining(ClientHandle<T> handle) {
        super(handle);
    }

    public TruffleCallNode findCallNode(JavaConstant callNodeConstant) {
        ClientHandle<?> callNodeConstantHandle = ((IsolatedObjectConstant)callNodeConstant).getHandle();
        ClientHandle<TruffleCallNode> callNodeHandle = IsolatedTruffleInlining.findCallNode0(IsolatedCompileContext.get().getClient(), this.handle, callNodeConstantHandle);
        return new IsolatedTruffleCallNode(callNodeHandle);
    }

    public TruffleInliningPlan.Decision findDecision(JavaConstant callNodeConstant) {
        ClientHandle<?> callNodeConstantHandle = ((IsolatedObjectConstant)callNodeConstant).getHandle();
        ClientHandle<TruffleInliningPlan.Decision> decision = IsolatedTruffleInlining.findDecision0(IsolatedCompileContext.get().getClient(), this.handle, callNodeConstantHandle);
        return decision.notEqual((ComparableWord)IsolatedHandles.nullHandle()) ? new IsolatedDecision(decision) : null;
    }

    public TruffleSourceLanguagePosition getPosition(JavaConstant nodeConstant) {
        if (!(nodeConstant instanceof IsolatedObjectConstant)) {
            return null;
        }
        ClientHandle<?> nodeConstantHandle = ((IsolatedObjectConstant)nodeConstant).getHandle();
        CompilerHandle<TruffleSourceLanguagePosition> position = IsolatedTruffleInlining.getPosition0(IsolatedCompileContext.get().getClient(), this.handle, nodeConstantHandle);
        return IsolatedCompileContext.get().unhand(position);
    }

    public void addTargetToDequeue(CompilableTruffleAST target) {
        ClientHandle<SubstrateCompilableTruffleAST> targetHandle = ((IsolatedCompilableTruffleAST)target).getHandle();
        IsolatedTruffleInlining.addTargetToDequeue0(IsolatedCompileContext.get().getClient(), this.handle, targetHandle);
    }

    public void dequeueTargets() {
        IsolatedTruffleInlining.dequeueTargets0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public void setCallCount(int count) {
        IsolatedTruffleInlining.setCallCount0(IsolatedCompileContext.get().getClient(), this.handle, count);
    }

    public int countCalls() {
        return IsolatedTruffleInlining.countCalls0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public void setInlinedCallCount(int count) {
        IsolatedTruffleInlining.setInlinedCallCount0(IsolatedCompileContext.get().getClient(), this.handle, count);
    }

    public int countInlinedCalls() {
        return IsolatedTruffleInlining.countInlinedCalls0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<TruffleCallNode> findCallNode0(ClientIsolateThread client, ClientHandle<? extends TruffleInliningPlan> inliningHandle, ClientHandle<?> callNodeConstantHandle) {
        TruffleInliningPlan inlining = IsolatedCompileClient.get().unhand(inliningHandle);
        JavaConstant callNodeConstant = SubstrateObjectConstant.forObject(IsolatedCompileClient.get().unhand(callNodeConstantHandle));
        TruffleCallNode callNode = inlining.findCallNode(callNodeConstant);
        return IsolatedCompileClient.get().hand(callNode);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<TruffleInliningPlan.Decision> findDecision0(ClientIsolateThread client, ClientHandle<? extends TruffleInliningPlan> inliningHandle, ClientHandle<?> callNodeConstantHandle) {
        TruffleInliningPlan inlining = IsolatedCompileClient.get().unhand(inliningHandle);
        JavaConstant callNodeConstant = SubstrateObjectConstant.forObject(IsolatedCompileClient.get().unhand(callNodeConstantHandle));
        TruffleInliningPlan.Decision decision = inlining.findDecision(callNodeConstant);
        return IsolatedCompileClient.get().hand(decision);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<TruffleSourceLanguagePosition> getPosition0(ClientIsolateThread client, ClientHandle<? extends TruffleInliningPlan> inliningHandle, ClientHandle<?> callNodeConstantHandle) {
        JavaConstant callNodeConstant;
        TruffleInliningPlan inlining = IsolatedCompileClient.get().unhand(inliningHandle);
        TruffleSourceLanguagePosition position = inlining.getPosition(callNodeConstant = SubstrateObjectConstant.forObject(IsolatedCompileClient.get().unhand(callNodeConstantHandle)));
        if (position == null) {
            return (CompilerHandle)IsolatedHandles.nullHandle();
        }
        return IsolatedTruffleInlining.createPositionInCompiler(IsolatedCompileClient.get().getCompiler(), IsolatedCompileClient.get().hand(position), position.getLineNumber(), position.getOffsetStart(), position.getOffsetEnd(), position.getNodeId());
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void addTargetToDequeue0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> providerHandle, ClientHandle<SubstrateCompilableTruffleAST> targetHandle) {
        IsolatedCompileClient isolatedCompileClient = IsolatedCompileClient.get();
        TruffleMetaAccessProvider truffleMetaAccessProvider = isolatedCompileClient.unhand(providerHandle);
        truffleMetaAccessProvider.addTargetToDequeue((CompilableTruffleAST)isolatedCompileClient.unhand(targetHandle));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void dequeueTargets0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> providerHandle) {
        TruffleMetaAccessProvider truffleMetaAccessProvider = IsolatedCompileClient.get().unhand(providerHandle);
        truffleMetaAccessProvider.dequeueTargets();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void setCallCount0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> handle, int count) {
        TruffleMetaAccessProvider truffleMetaAccessProvider = IsolatedCompileClient.get().unhand(handle);
        truffleMetaAccessProvider.setCallCount(count);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static int countCalls0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> handle) {
        TruffleMetaAccessProvider truffleMetaAccessProvider = IsolatedCompileClient.get().unhand(handle);
        return truffleMetaAccessProvider.countCalls();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void setInlinedCallCount0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> handle, int count) {
        TruffleMetaAccessProvider truffleMetaAccessProvider = IsolatedCompileClient.get().unhand(handle);
        truffleMetaAccessProvider.setInlinedCallCount(count);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static int countInlinedCalls0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> handle) {
        TruffleMetaAccessProvider truffleMetaAccessProvider = IsolatedCompileClient.get().unhand(handle);
        return truffleMetaAccessProvider.countInlinedCalls();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<TruffleSourceLanguagePosition> createPositionInCompiler(CompilerIsolateThread compiler, ClientHandle<TruffleSourceLanguagePosition> positionHandle, int lineNumber, int offsetStart, int offsetEnd, int nodeId) {
        return IsolatedCompileContext.get().hand(new IsolatedTruffleSourceLanguagePosition(positionHandle, lineNumber, offsetStart, offsetEnd, nodeId));
    }
}

