/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.methodhandles.MethodHandlesSupported;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_LambdaForm;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MemberName;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.graalvm.compiler.debug.GraalError;

@TargetClass(className="java.lang.invoke.MethodHandle", onlyWith={MethodHandlesSupported.class})
final class Target_java_lang_invoke_MethodHandle {
    Target_java_lang_invoke_MethodHandle() {
    }

    @Alias
    native Target_java_lang_invoke_MemberName internalMemberName();

    @Alias
    native Target_java_lang_invoke_LambdaForm internalForm();

    @Substitute(polymorphicSignature=true)
    private Object invokeBasic(Object ... args) {
        Target_java_lang_invoke_MemberName memberName;
        Target_java_lang_invoke_MemberName target_java_lang_invoke_MemberName = memberName = this.internalMemberName() != null ? this.internalMemberName() : this.internalForm().vmentry;
        if (memberName == null) {
            throw VMError.unsupportedFeature("Method handles requiring lambda form interpretation (e.g through a bindTo() call) are not supported. See https://github.com/oracle/graal/issues/2939.");
        }
        try {
            Method method = SubstrateUtil.cast(memberName.reflectAccess, Method.class);
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, args);
            }
            return method.invoke(args[0], Arrays.copyOfRange(args, 1, args.length));
        }
        catch (Exception e) {
            throw new GraalError((Throwable)e);
        }
    }

    @Substitute(polymorphicSignature=true)
    static Object linkToVirtual(Object ... args) throws Throwable {
        throw VMError.unsupportedFeature("MethodHandle.linkToVirtual()");
    }

    @Substitute(polymorphicSignature=true)
    static Object linkToStatic(Object ... args) throws Throwable {
        throw VMError.unsupportedFeature("MethodHandle.linkToStatic()");
    }
}

