/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.core.SubstrateAnnotationInvocationHandler;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class AnnotationObjectReplacer
implements Function<Object, Object> {
    private ConcurrentHashMap<Object, Object> objectCache = new ConcurrentHashMap();
    private static final SubstrateAnnotationInvocationHandler SINGLETON_HANDLER = new SubstrateAnnotationInvocationHandler(null);
    private static final Class<?> HOSTED_INVOCATION_HANDLER_CLASS;

    AnnotationObjectReplacer() {
    }

    @Override
    public Object apply(Object original) {
        Class<?> clazz = original.getClass();
        if (Annotation.class.isAssignableFrom(clazz) && Proxy.class.isAssignableFrom(clazz)) {
            return this.objectCache.computeIfAbsent(original, AnnotationObjectReplacer::replacementComputer);
        }
        if (original instanceof SubstrateAnnotationInvocationHandler) {
            return SINGLETON_HANDLER;
        }
        if (HOSTED_INVOCATION_HANDLER_CLASS.isInstance(original)) {
            throw VMError.shouldNotReachHere("Instance of the hosted AnnotationInvocationHandler is reachable at run time");
        }
        return original;
    }

    private static Object replacementComputer(Object original) {
        Class<?>[] interfaces = original.getClass().getInterfaces();
        Class<?>[] extendedInterfaces = Arrays.copyOf(interfaces, interfaces.length + 1);
        extendedInterfaces[extendedInterfaces.length - 1] = AnnotationSupport.constantAnnotationMarkerInterface;
        return Proxy.newProxyInstance(original.getClass().getClassLoader(), extendedInterfaces, (InvocationHandler)new SubstrateAnnotationInvocationHandler(Proxy.getInvocationHandler(original)));
    }

    static {
        try {
            HOSTED_INVOCATION_HANDLER_CLASS = Class.forName("sun.reflect.annotation.AnnotationInvocationHandler");
        }
        catch (ClassNotFoundException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

