/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;

public final class InjectedAccessorsPlugin
implements NodePlugin {
    public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
        return InjectedAccessorsPlugin.handleField(b, field, false, object, true, null);
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        return InjectedAccessorsPlugin.handleField(b, field, true, null, true, null);
    }

    public boolean handleStoreField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field, ValueNode value) {
        return InjectedAccessorsPlugin.handleField(b, field, false, object, false, value);
    }

    public boolean handleStoreStaticField(GraphBuilderContext b, ResolvedJavaField field, ValueNode value) {
        return InjectedAccessorsPlugin.handleField(b, field, true, null, false, value);
    }

    private static boolean handleField(GraphBuilderContext b, ResolvedJavaField field, boolean isStatic, ValueNode receiver, boolean isGet, ValueNode value) {
        JavaType actualValue;
        InjectAccessors injectAccesors = (InjectAccessors)field.getAnnotation(InjectAccessors.class);
        if (injectAccesors == null) {
            return false;
        }
        Class<?> accessorsClass = injectAccesors.value();
        ResolvedJavaType accessorsType = b.getMetaAccess().lookupJavaType(accessorsClass);
        String shortName = isGet ? "get" : "set";
        String fieldName = field.getName();
        String longName = shortName + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        ResolvedJavaMethod foundMethod = null;
        for (ResolvedJavaMethod method : accessorsType.getDeclaredMethods()) {
            if (!method.getName().equals(shortName) && !method.getName().equals(longName)) continue;
            if (foundMethod != null) {
                InjectedAccessorsPlugin.error(field, accessorsType, null, "found two methods " + foundMethod.format("%n(%p)") + " and " + method.format("%n(%p)"));
            }
            foundMethod = method;
        }
        if (foundMethod == null) {
            InjectedAccessorsPlugin.error(field, accessorsType, null, "found no method named " + shortName + " or " + longName);
        }
        if (!foundMethod.isStatic()) {
            InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "method is not static");
        }
        int paramIdx = 0;
        if (!isStatic) {
            if (foundMethod.getSignature().getParameterCount(false) < paramIdx + 1) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "not enough parameters");
            }
            JavaType actualReceiver = foundMethod.getSignature().getParameterType(paramIdx, null);
            ResolvedJavaType expectedReceiver = field.getDeclaringClass();
            boolean match = false;
            for (ResolvedJavaType cur = expectedReceiver; cur != null; cur = cur.getSuperclass()) {
                if (!actualReceiver.equals(cur)) continue;
                match = true;
                break;
            }
            if (!match) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "wrong receiver type: expected " + expectedReceiver.toJavaName(true) + " or a superclass, found " + actualReceiver.toJavaName(true));
            }
            ++paramIdx;
        }
        JavaType expectedValue = field.getType();
        if (isGet) {
            actualValue = foundMethod.getSignature().getReturnType(null);
            if (!actualValue.equals(expectedValue)) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "wrong return type: expected " + expectedValue.toJavaName(true) + ", found " + actualValue.toJavaName(true));
            }
        } else {
            if (foundMethod.getSignature().getParameterCount(false) < paramIdx + 1) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "not enough parameters");
            }
            if (!(actualValue = foundMethod.getSignature().getParameterType(paramIdx, null)).equals(expectedValue)) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "wrong value type: expected " + expectedValue.toJavaName(true) + ", found " + actualValue.toJavaName(true));
            }
            ++paramIdx;
        }
        if (foundMethod.getSignature().getParameterCount(false) != paramIdx) {
            InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "Wrong number of parameters: expected " + paramIdx + ", found " + foundMethod.getSignature().getParameterCount(false));
        }
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        if (!isStatic) {
            args.add(receiver);
        }
        if (!isGet) {
            args.add(value);
        }
        b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, foundMethod, args.toArray(new ValueNode[args.size()]), false);
        return true;
    }

    private static void error(ResolvedJavaField field, ResolvedJavaType accessorsType, ResolvedJavaMethod method, String msg) {
        throw VMError.shouldNotReachHere("Error in @" + InjectAccessors.class.getSimpleName() + " handling of field " + field.format("%H.%n") + ", accessors class " + accessorsType.toJavaName(true) + (method == null ? "" : ", method " + method.format("%n(%p)")) + ": " + msg);
    }
}

