/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.code.SubstrateCompilationIdentifier;
import com.oracle.svm.core.graal.nodes.DeadEndNode;
import com.oracle.svm.core.graal.replacements.SubstrateGraphKit;
import com.oracle.svm.core.util.ExceptionHelpers;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.hosted.phases.AnalysisGraphBuilderPhase;
import com.oracle.svm.hosted.phases.HostedGraphBuilderPhase;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.util.Providers;

public class HostedGraphKit
extends SubstrateGraphKit {
    public HostedGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method) {
        super(debug, method, (Providers)providers, providers.getWordTypes(), providers.getGraphBuilderPlugins(), new SubstrateCompilationIdentifier());
    }

    protected MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, int bci) {
        ResolvedJavaMethod method = this.graph.method();
        if (method instanceof HostedMethod) {
            return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, ((HostedMethod)method).getProfilingInfo(), bci);
        }
        return super.createMethodCallTarget(invokeKind, targetMethod, args, returnStamp, bci);
    }

    protected GraphBuilderPhase.Instance createGraphBuilderInstance(Providers theProviders, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        ResolvedJavaMethod method = this.graph.method();
        if (method instanceof AnalysisMethod) {
            return new AnalysisGraphBuilderPhase(theProviders, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, this.wordTypes);
        }
        if (method instanceof HostedMethod) {
            return new HostedGraphBuilderPhase(theProviders, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, this.wordTypes);
        }
        throw VMError.shouldNotReachHere();
    }

    public void emitEnsureInitializedCall(ResolvedJavaType type) {
        if (SubstrateClassInitializationPlugin.needsRuntimeInitialization(this.graph.method().getDeclaringClass(), type)) {
            ConstantNode hub = this.createConstant((Constant)this.getConstantReflection().asJavaClass(type), JavaKind.Object);
            int bci = this.bci();
            EnsureClassInitializedNode ensureInitializedNode = (EnsureClassInitializedNode)this.append((ValueNode)new EnsureClassInitializedNode((ValueNode)hub));
            ensureInitializedNode.setStateAfter(this.getFrameState().create(bci, (StateSplit)ensureInitializedNode));
            AbstractBeginNode noExceptionEdge = (AbstractBeginNode)this.add((ValueNode)ensureInitializedNode.createNextBegin());
            ensureInitializedNode.setNext(noExceptionEdge);
            ExceptionObjectNode exceptionEdge = this.createExceptionObjectNode(this.getFrameState(), bci);
            ensureInitializedNode.setExceptionEdge((AbstractBeginNode)exceptionEdge);
            this.lastFixedNode = exceptionEdge;
            this.throwInvocationTargetException((ValueNode)exceptionEdge);
            assert (this.lastFixedNode == null);
            this.lastFixedNode = noExceptionEdge;
        }
    }

    public void throwInvocationTargetException(ValueNode exception) {
        ResolvedJavaMethod throwInvocationTargetException = this.findMethod(ExceptionHelpers.class, "throwInvocationTargetException", true);
        this.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Static, throwInvocationTargetException, exception);
        this.append((ValueNode)new DeadEndNode());
    }

    public LoadFieldNode createLoadFieldNode(ConstantNode receiver, Class<BoxedRelocatedPointer> clazz, String fieldName) {
        try {
            ResolvedJavaType type = this.providers.getMetaAccess().lookupJavaType(clazz);
            if (type instanceof AnalysisType) {
                ((AnalysisType)type).registerAsReachable();
            }
            ResolvedJavaField field = this.providers.getMetaAccess().lookupJavaField(clazz.getDeclaredField(fieldName));
            return LoadFieldNode.createOverrideStamp((StampPair)StampPair.createSingle((Stamp)this.wordStamp((ResolvedJavaType)field.getType())), (ValueNode)receiver, (ResolvedJavaField)field);
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }
}

