/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Executable;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
public class LoggingFeature
implements Feature {
    private final boolean trace = Options.TraceLoggingFeature.getValue();
    private boolean reflectionConfigured = false;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.EnableLoggingFeature.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        LogManager.getLogManager();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (!this.reflectionConfigured && access.getMetaAccess().optionalLookupJavaType(Logger.class).isPresent()) {
            this.registerForReflection(ConsoleHandler.class);
            this.registerForReflection(SimpleFormatter.class);
            this.reflectionConfigured = true;
            access.requireAnalysisIteration();
        }
    }

    private void registerForReflection(Class<?> clazz) {
        try {
            this.trace("Registering " + clazz + " for reflection.");
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.register((Executable[])new Executable[]{clazz.getConstructor(new Class[0])});
        }
        catch (NoSuchMethodException e) {
            VMError.shouldNotReachHere(e);
        }
    }

    private void trace(String msg) {
        if (this.trace) {
            System.out.println("LoggingFeature: " + msg);
        }
    }

    public static class Options {
        @Option(help={"Enable the feature that provides support for logging."})
        public static final HostedOptionKey<Boolean> EnableLoggingFeature = new HostedOptionKey<Boolean>(true);
        @Option(help={"When enabled, logging feature details are printed."}, type=OptionType.Debug)
        public static final HostedOptionKey<Boolean> TraceLoggingFeature = new HostedOptionKey<Boolean>(false);
    }
}

