/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.graal.isolated.ImageHeapObjects;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;

final class IsolatedSpeculationReasonEncoding
extends ByteArrayOutputStream
implements SpeculationLog.SpeculationReasonEncoding {
    private DataOutputStream dos = new DataOutputStream(this);
    private byte[] result;
    private static final int NULL_METHOD = -1;
    private static final int NULL_TYPE = -2;
    private static final int NULL_STRING = -3;
    private static final MessageDigest SHA1 = IsolatedSpeculationReasonEncoding.getSHA1();
    private static final int SHA1_LENGTH = SHA1.getDigestLength();

    IsolatedSpeculationReasonEncoding() {
        super(SHA1_LENGTH);
    }

    private void checkOpen() {
        if (this.result != null) {
            throw new IllegalArgumentException("Cannot update closed speculation encoding");
        }
    }

    public void addByte(int value) {
        this.checkOpen();
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public void addShort(int value) {
        this.checkOpen();
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public void addMethod(ResolvedJavaMethod method) {
        this.addImageHeapObject(method, -1);
    }

    public void addType(ResolvedJavaType type) {
        this.addImageHeapObject(type, -2);
    }

    private void addImageHeapObject(Object object, int nullValue) {
        if (!this.addNull(object, nullValue)) {
            this.checkOpen();
            try {
                this.dos.writeLong(ImageHeapObjects.ref(object).rawValue());
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }
    }

    public void addString(String value) {
        if (!this.addNull(value, -3)) {
            this.checkOpen();
            try {
                this.dos.writeChars(value);
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }
    }

    public void addInt(int value) {
        this.checkOpen();
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public void addLong(long value) {
        this.checkOpen();
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    private boolean addNull(Object o, int nullValue) {
        if (o == null) {
            this.addInt(nullValue);
            return true;
        }
        return false;
    }

    private static MessageDigest getSHA1() {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            sha1.clone();
            return sha1;
        }
        catch (CloneNotSupportedException | NoSuchAlgorithmException e) {
            throw new JVMCIError("Expect a cloneable implementation of a SHA-1 message digest to be available", new Object[]{e});
        }
    }

    byte[] getByteArray() {
        if (this.result == null) {
            if (this.count > SHA1_LENGTH) {
                try {
                    MessageDigest md = (MessageDigest)SHA1.clone();
                    md.update(this.buf, 0, this.count);
                    this.result = md.digest();
                }
                catch (CloneNotSupportedException e) {
                    throw new InternalError(e);
                }
            } else {
                if (this.buf.length == this.count) {
                    return this.buf;
                }
                this.result = Arrays.copyOf(this.buf, this.count);
            }
            this.dos = null;
        }
        return this.result;
    }
}

