/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.BaseProcessPropertiesSupport;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ProcessPropertiesSupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class WindowsProcessPropertiesSupport
extends BaseProcessPropertiesSupport {
    public String getExecutableName() {
        CCharPointer path = (CCharPointer)StackValue.get((int)260, CCharPointer.class);
        WinBase.HMODULE hModule = WinBase.GetModuleHandleA(WordFactory.nullPointer());
        int result = WinBase.GetModuleFileNameA(hModule, path, 260);
        return result == 0 ? null : CTypeConversion.toJavaString((CCharPointer)path);
    }

    public void exec(Path executable, String[] args) {
        if (!Files.isExecutable(executable)) {
            throw new RuntimeException("Path " + executable + " does not point to executable file");
        }
        ArrayList<String> cmd = new ArrayList<String>(args.length);
        cmd.add(executable.toString());
        cmd.addAll(Arrays.asList(args).subList(1, args.length));
        java.lang.Process process = null;
        try {
            process = new ProcessBuilder(cmd).redirectInput(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere();
        }
        while (process.isAlive()) {
            try {
                System.exit(process.waitFor());
            }
            catch (InterruptedException interruptedException) {}
        }
        System.exit(process.exitValue());
    }

    public long getProcessID() {
        return Process.GetCurrentProcessId();
    }

    public long getProcessID(java.lang.Process process) {
        return WindowsUtils.getpid(process);
    }

    public String getObjectFile(String symbol) {
        try (CTypeConversion.CCharPointerHolder symbolHolder = CTypeConversion.toCString((CharSequence)symbol);){
            WinBase.HMODULE builtinHandle = WinBase.GetModuleHandleA(WordFactory.nullPointer());
            PointerBase symbolAddress = WinBase.GetProcAddress(builtinHandle, (PointerBase)symbolHolder.get());
            if (symbolAddress.isNonNull()) {
                String string = WindowsProcessPropertiesSupport.getObjectFile(symbolAddress);
                return string;
            }
        }
        return null;
    }

    public String getObjectFile(CEntryPointLiteral<?> symbol) {
        CFunctionPointer symbolAddress = symbol.getFunctionPointer();
        return WindowsProcessPropertiesSupport.getObjectFile((PointerBase)symbolAddress);
    }

    private static String getObjectFile(PointerBase symbolAddress) {
        WinBase.HMODULEPointer module = (WinBase.HMODULEPointer)StackValue.get(WinBase.HMODULEPointer.class);
        if (!WinBase.GetModuleHandleExA(WinBase.GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS() | WinBase.GET_MODULE_HANDLE_EX_FLAG_UNCHANGED_REFCOUNT(), symbolAddress, module)) {
            return null;
        }
        CCharPointer path = (CCharPointer)StackValue.get((int)260, CCharPointer.class);
        int result = WinBase.GetModuleFileNameA(module.read(), path, 260);
        return result == 0 ? null : CTypeConversion.toJavaString((CCharPointer)path);
    }

    public String setLocale(String category, String locale) {
        throw VMError.unimplemented();
    }

    public boolean destroy(long processID) {
        return this.destroyForcibly(processID);
    }

    public boolean destroyForcibly(long processID) {
        WinBase.HANDLE handle = Process.OpenProcess(Process.PROCESS_TERMINATE(), 0, (int)processID);
        if (handle.isNull()) {
            return false;
        }
        boolean result = Process.TerminateProcess(handle, 1) != 0;
        WinBase.CloseHandle(handle);
        return result;
    }

    public boolean isAlive(long processID) {
        throw VMError.unimplemented();
    }

    public int waitForProcessExit(long processID) {
        throw VMError.unimplemented();
    }

    @AutomaticFeature
    public static class ImagePropertiesFeature
    implements Feature {
        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(ProcessPropertiesSupport.class, (Object)new WindowsProcessPropertiesSupport());
        }
    }
}

