/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.meta.SubstrateMemoryAccessProvider;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.CompressibleConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;

public final class SubstrateNarrowOopStamp
extends NarrowOopStamp {
    public SubstrateNarrowOopStamp(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull, CompressEncoding encoding) {
        super(type, exactType, nonNull, alwaysNull, encoding);
        assert (this.getEncoding().equals((Object)ReferenceAccess.singleton().getCompressEncoding())) : "Using a non-default encoding is not supported: reference map support is needed.";
    }

    protected AbstractObjectStamp copyWith(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull) {
        return new SubstrateNarrowOopStamp(type, exactType, nonNull, alwaysNull, this.getEncoding());
    }

    public static AbstractObjectStamp compressed(AbstractObjectStamp stamp, CompressEncoding encoding) {
        return new SubstrateNarrowOopStamp(stamp.type(), stamp.isExactType(), stamp.nonNull(), stamp.alwaysNull(), encoding);
    }

    public Constant readConstant(MemoryAccessProvider memoryAccessProvider, Constant base, long displacement) {
        JavaConstant constant = ((SubstrateMemoryAccessProvider)memoryAccessProvider).readNarrowObjectConstant(base, displacement, this.getEncoding());
        assert (constant == null || ((CompressibleConstant)constant).isCompressed());
        return constant;
    }

    public JavaConstant nullConstant() {
        return CompressedNullConstant.COMPRESSED_NULL;
    }

    public boolean isCompatible(Constant c) {
        return c instanceof CompressibleConstant && ((CompressibleConstant)c).isCompressed();
    }

    public static Stamp mkStamp(CompressionNode.CompressionOp op, Stamp input, CompressEncoding encoding) {
        switch (op) {
            case Compress: {
                if (!(input instanceof ObjectStamp)) break;
                return SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)((ObjectStamp)input), encoding);
            }
            case Uncompress: {
                if (!(input instanceof NarrowOopStamp)) break;
                NarrowOopStamp inputStamp = (NarrowOopStamp)input;
                assert (encoding.equals((Object)inputStamp.getEncoding()));
                return inputStamp.uncompressed();
            }
        }
        throw GraalError.shouldNotReachHere((String)("Unexpected input stamp " + input));
    }
}

