/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapVerificationError;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.SpaceVerifier;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import java.lang.ref.Reference;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class HeapVerifier {
    private final SpaceVerifier spaceVerifier = new SpaceVerifier();
    private final CardTable.ReferenceToYoungObjectVisitor referenceToYoungObjectVisitor = new CardTable.ReferenceToYoungObjectVisitor(new CardTable.ReferenceToYoungObjectReferenceVisitor());
    private final ImageHeapRegionVerifier imageHeapRegionVerifier = new ImageHeapRegionVerifier();
    private final Log witnessLog = Log.log();
    private String currentCause = "Too soon to tell";
    private static final NoReferencesOutsideHeapVisitor noReferencesOutsideHeapVisitor = new NoReferencesOutsideHeapVisitor();
    private static final NoReferencesToForwardedObjectsVisitor noReferencesToForwardedObjectsVisitor = new NoReferencesToForwardedObjectsVisitor();

    public String getCurrentCause() {
        return this.currentCause;
    }

    private void setCurrentCause(String cause) {
        this.currentCause = cause;
    }

    boolean verifyObjectAt(Pointer ptr) {
        VMOperation.guaranteeInProgress("Can only verify from a VMOperation.");
        Log trace = HeapVerifier.getTraceLog();
        trace.string("[HeapVerifier.verifyObjectAt:").string("  ptr: ").hex((WordBase)ptr);
        if (ptr.isNull()) {
            this.getWitnessLog().string("[verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  null ptr").string("]").newline();
            return false;
        }
        if (!HeapVerifier.slowlyFindPointer(ptr)) {
            this.getWitnessLog().string("[HeapVerifier.verifyObjectAt:").string("  ptr: ").hex((WordBase)ptr).string("  is not in heap.").string("]").newline();
            return false;
        }
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointerCarefully(ptr);
        trace.string("  header: ").hex((WordBase)header);
        if (ObjectHeaderImpl.isForwardedHeader(header)) {
            Object obj = ObjectHeaderImpl.getForwardedObject(ptr);
            Word op = Word.objectToUntrackedPointer((Object)obj);
            trace.string("  forwards to ").hex((WordBase)op).newline();
            if (!this.verifyObjectAt((Pointer)op)) {
                this.getWitnessLog().string("[HeapVerifier.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  forwarded object fails to verify").string("]").newline();
                return false;
            }
        } else {
            Object obj = ptr.toObject();
            trace.string("  obj: ").hex((WordBase)Word.objectToUntrackedPointer((Object)obj)).string("  obj.getClass: ").string(obj.getClass().getName());
            DynamicHub hub = ObjectHeaderImpl.readDynamicHubFromObjectCarefully(obj);
            if (!hub.getClass().getName().equals("java.lang.Class")) {
                this.getWitnessLog().string("[HeapVerifier.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  hub is not a class").string("]").newline();
                return false;
            }
            HeapImpl heap = HeapImpl.getHeapImpl();
            if (heap.isInImageHeap(obj) != heap.isInImageHeapSlow(obj)) {
                try (Log witness = this.getWitnessLog();){
                    witness.string("[HeapVerifier.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  obj: ").object(obj);
                    witness.string("  mismatch between isInImageHeap() and isInImageHeapSlow()").string("]").newline();
                }
                return false;
            }
            trace.newline();
            if (!this.noReferencesOutsideHeap(obj)) {
                this.getWitnessLog().string("[HeapVerifier.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  contains references outside the heap").string("]").newline();
                return false;
            }
            if (!this.noReferencesToForwardedObjectsVerifier(obj)) {
                this.getWitnessLog().string("[HeapVerifier.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  contains references to forwarded objects").string("]").newline();
                return false;
            }
            if (!HeapVerifier.verifyReferenceObject(obj)) {
                this.getWitnessLog().string("[HeapVerifier.verifyObjectAt(objRef: ").hex((WordBase)ptr).string(")").string("  Reference object fails to verify.").string("]").newline();
                return false;
            }
        }
        trace.string("  returns true]").newline();
        return true;
    }

    public boolean verify(String cause) {
        VerifyVMOperation op = new VerifyVMOperation(cause, this, Occasion.BEFORE_COLLECTION);
        op.enqueue();
        return op.getResult();
    }

    boolean verifyOperation(String cause, Occasion occasion) {
        VMOperation.guaranteeInProgress("Can only verify from a VMOperation.");
        Log trace = HeapVerifier.getTraceLog();
        trace.string("[HeapVerifier.verify ").string(" occasion: ").string(occasion.name()).string(" cause: ").string(cause).string(":");
        trace.newline();
        this.setCurrentCause(cause);
        ThreadLocalAllocation.disableAndFlushForAllThreads();
        boolean result = true;
        if (!this.verifyImageHeapObjects()) {
            this.getWitnessLog().string("[HeapVerifier.verify:").string("  native image fails to verify").string("]").newline();
            result = false;
        }
        if (!HeapVerifier.verifyYoungGeneration(occasion)) {
            this.getWitnessLog().string("[HeapVerifier.verify:").string("  young generation fails to verify").string("]").newline();
            result = false;
        }
        if (!HeapVerifier.verifyOldGeneration(occasion)) {
            this.getWitnessLog().string("[HeapVerifier.verify:").string("  old generation fails to verify").string("]").newline();
            result = false;
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        if (!result && HeapOptions.HeapVerificationFailureIsFatal.getValue().booleanValue()) {
            HeapVerificationError.throwError();
        }
        return result;
    }

    static void verifyDirtyCard(boolean inToSpace) {
        OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
        oldGen.verifyDirtyCards(inToSpace);
    }

    static Log getTraceLog() {
        return HeapOptions.TraceHeapVerification.getValue() != false ? Log.log() : Log.noopLog();
    }

    Log getWitnessLog() {
        return this.witnessLog;
    }

    private boolean verifyImageHeapObjects() {
        this.imageHeapRegionVerifier.reset();
        ImageHeapWalker.walkRegions(HeapImpl.getImageHeapInfo(), this.imageHeapRegionVerifier);
        return this.imageHeapRegionVerifier.verifyResult;
    }

    private static boolean verifyYoungGeneration(Occasion occasion) {
        YoungGeneration youngGeneration = HeapImpl.getHeapImpl().getYoungGeneration();
        return ((Generation)youngGeneration).verify(occasion);
    }

    private static boolean verifyOldGeneration(Occasion occasion) {
        OldGeneration oldGeneration = HeapImpl.getHeapImpl().getOldGeneration();
        return oldGeneration.verify(occasion);
    }

    private boolean noReferencesOutsideHeap(Object obj) {
        Log trace = HeapVerifier.getTraceLog();
        trace.string("[HeapVerifier.noReferencesOutsideHeap:");
        trace.string("  obj: ").object(obj).string("  obj.getClass: ").string(obj.getClass().getName());
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObjectCarefully(obj);
        trace.string("  header: ").hex((WordBase)header);
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        trace.string("  objPointer: ").hex((WordBase)objPointer);
        boolean result = InteriorObjRefWalker.walkObject(obj, noReferencesOutsideHeapVisitor);
        if (!result) {
            try (Log witness = this.getWitnessLog();){
                witness.string("[HeapVerifier.noReferencesOutsideHeap:").string("  cause: ").string(this.getCurrentCause());
                witness.string("  obj: ").string(obj.getClass().getName()).string("@").hex((WordBase)objPointer);
                witness.string("  header: ").hex((WordBase)header).string("]").newline();
            }
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean noReferencesToForwardedObjectsVerifier(Object obj) {
        Log trace = HeapVerifier.getTraceLog();
        trace.string("[HeapVerifier.noReferencesToForwardedObjectsVerifier:");
        trace.string("  obj: ").object(obj);
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObjectCarefully(obj);
        trace.string("  header: ").hex((WordBase)header);
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        trace.string("  objPointer: ").hex((WordBase)objPointer);
        boolean result = InteriorObjRefWalker.walkObject(obj, noReferencesToForwardedObjectsVisitor);
        if (!result) {
            try (Log witness = this.getWitnessLog();){
                witness.string("[HeapVerifier.noReferencesToForwardedObjectsVerifier:").string("  cause: ").string(this.getCurrentCause()).string("  obj: ").object(obj).string("]").newline();
            }
        }
        trace.string("]").newline();
        return result;
    }

    private static boolean verifyReferenceObject(Object object) {
        Object obj = KnownIntrinsics.convertUnknownValue(object, Object.class);
        if (obj instanceof Reference) {
            return ReferenceObjectProcessing.verify((Reference)obj);
        }
        return true;
    }

    static boolean slowlyFindPointer(Pointer p) {
        boolean found;
        HeapImpl heap = HeapImpl.getHeapImpl();
        boolean bl = found = heap.isInImageHeapSlow(p) || HeapVerifier.slowlyFindPointerInYoungGeneration(p) || HeapVerifier.slowlyFindPointerInOldGeneration(p);
        if (!found) {
            heap.getHeapVerifier().getWitnessLog().string("[HeapVerifier.slowlyFindPointer:").string("  did not find pointer in heap: ").hex((WordBase)p).string("]").newline();
        }
        return found;
    }

    private static boolean slowlyFindPointerInYoungGeneration(Pointer p) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        return youngGen.slowlyFindPointer(p);
    }

    private static boolean slowlyFindPointerInOldGeneration(Pointer p) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        return oldGen.slowlyFindPointer(p);
    }

    private static boolean slowlyFindPointerInUnusedSpace(Pointer p) {
        return HeapImpl.getChunkProvider().slowlyFindPointer(p);
    }

    static boolean slowlyFindPointerInSpace(Space space, Pointer p) {
        AlignedHeapChunk.AlignedHeader aChunk = space.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            Pointer start = AlignedHeapChunk.getObjectsStart(aChunk);
            if (start.belowOrEqual((UnsignedWord)p) && p.belowThan((UnsignedWord)HeapChunk.getTopPointer(aChunk))) {
                return true;
            }
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = space.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            Pointer start = UnalignedHeapChunk.getObjectStart(uChunk);
            if (start.belowOrEqual((UnsignedWord)p) && p.belowThan((UnsignedWord)HeapChunk.getTopPointer(uChunk))) {
                return true;
            }
            uChunk = HeapChunk.getNext(uChunk);
        }
        return false;
    }

    public static int classifyObject(Object o) {
        return HeapVerifier.classifyPointer((Pointer)Word.objectToUntrackedPointer((Object)o));
    }

    static int classifyPointer(Pointer p) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        if (p.isNull()) {
            return 0;
        }
        if (HeapImpl.getHeapImpl().isInImageHeapSlow(p)) {
            return 1;
        }
        if (youngGen.slowlyFindPointer(p)) {
            return 2;
        }
        int oldGenClassification = oldGen.classifyPointer(p);
        if (oldGenClassification > 0) {
            return 2 + oldGenClassification;
        }
        if (HeapVerifier.slowlyFindPointerInUnusedSpace(p)) {
            return -1;
        }
        return -2;
    }

    CardTable.ReferenceToYoungObjectVisitor getReferenceToYoungObjectVisitor() {
        return this.referenceToYoungObjectVisitor;
    }

    SpaceVerifier getSpaceVerifier() {
        return this.spaceVerifier;
    }

    private static class NoReferencesToForwardedObjectsVisitor
    implements ObjectReferenceVisitor {
        private NoReferencesToForwardedObjectsVisitor() {
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            HeapImpl heap = HeapImpl.getHeapImpl();
            HeapVerifier verifier = heap.getHeapVerifier();
            Word objPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (objPointer.isNull()) {
                return true;
            }
            if (ObjectHeaderImpl.isPointerToForwardedObjectCarefully((Pointer)objPointer)) {
                try (Log witness = verifier.getWitnessLog();){
                    witness.string("[HeapVerifier.noReferencesToForwardedObjectsVerifier:").string("  cause: ").string(verifier.getCurrentCause());
                    witness.string("  contains fieldPointer: ").hex((WordBase)objPointer).string("  to forwarded object at: ").hex((WordBase)objRef).string("]").newline();
                }
                return false;
            }
            return true;
        }
    }

    private static class NoReferencesOutsideHeapVisitor
    implements ObjectReferenceVisitor {
        private NoReferencesOutsideHeapVisitor() {
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            HeapVerifier verifier = HeapImpl.getHeapImpl().getHeapVerifier();
            Word objPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (objPointer.isNull()) {
                return true;
            }
            if (!compressed && (objPointer.equal((UnsignedWord)HeapPolicy.getProducedHeapChunkZapWord()) || objPointer.equal((UnsignedWord)HeapPolicy.getConsumedHeapChunkZapWord()))) {
                try (Log witness = verifier.getWitnessLog();){
                    witness.string("[HeapVerifier.NoReferencesOutsideHeapVisitor:").string("  cause: ").string(verifier.getCurrentCause());
                    witness.string("  contains zapped field Pointer: ").hex((WordBase)objPointer).string("  at: ").hex((WordBase)objRef).string("]").newline();
                }
                return false;
            }
            if (!HeapVerifier.slowlyFindPointer((Pointer)objPointer)) {
                try (Log witness = verifier.getWitnessLog();){
                    witness.string("[HeapVerifier.NoReferencesOutsideHeapVisitor:").string("  cause: ").string(verifier.getCurrentCause());
                    witness.string("  at: ").hex((WordBase)objRef).string("  contains fieldPointer: ").hex((WordBase)objPointer).string("  that is not a reference to the heap").newline();
                    witness.string("    Foolishly trying to look at the object pointed to by the fieldPointer:");
                    UnsignedWord fieldHeader = ObjectHeaderImpl.readHeaderFromPointerCarefully((Pointer)objPointer);
                    witness.string("  fieldHeader: ").hex((WordBase)fieldHeader);
                    Object fieldObject = objPointer.toObject();
                    witness.string("  fieldObject: ").object(fieldObject).string("]").newline();
                }
                return false;
            }
            Word readWord = (Word)objPointer.readWord(0);
            if (readWord.equal(HeapPolicy.getProducedHeapChunkZapWord()) || readWord.equal(HeapPolicy.getConsumedHeapChunkZapWord())) {
                try (Log witness = verifier.getWitnessLog();){
                    witness.string("[HeapVerifier.NoReferencesOutsideHeapVisitor:").string("  cause: ").string(verifier.getCurrentCause());
                    witness.string("  contains fieldPointer: ").hex((WordBase)objPointer).string("  to zapped memory: ").hex((WordBase)readWord).string("  at: ").hex((WordBase)objRef).string("]").newline();
                }
                return false;
            }
            return true;
        }
    }

    class ImageHeapObjectVerifier
    implements ObjectVisitor {
        boolean verifyResult;
        Pointer regionStart;
        Pointer regionEnd;

        ImageHeapObjectVerifier() {
        }

        void reset(Pointer start, Pointer end) {
            this.verifyResult = true;
            this.regionStart = start;
            this.regionEnd = end;
        }

        @Override
        public boolean visitObject(Object currentObject) {
            Throwable throwable;
            Log witness;
            Word currentPointer = Word.objectToUntrackedPointer((Object)currentObject);
            if (!HeapImpl.getHeapImpl().isInImageHeap(currentObject)) {
                this.verifyResult = false;
                witness = HeapVerifier.this.getWitnessLog();
                throwable = null;
                try {
                    witness.string("[ImageHeapObjectVerifier:").string("  [ regionStart: ").hex((WordBase)this.regionStart).string("  .. regionEnd: ").hex((WordBase)this.regionEnd).string(" ]");
                    witness.string("  current: ").hex((WordBase)currentPointer).string("  object is not considered to be in image heap").string("]").newline();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (witness != null) {
                        if (throwable != null) {
                            try {
                                witness.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            witness.close();
                        }
                    }
                }
            }
            if (!HeapVerifier.this.verifyObjectAt((Pointer)currentPointer)) {
                this.verifyResult = false;
                witness = HeapVerifier.this.getWitnessLog();
                throwable = null;
                try {
                    witness.string("[ImageHeapObjectVerifier:").string("  [ regionStart: ").hex((WordBase)this.regionStart).string("  .. regionEnd: ").hex((WordBase)this.regionEnd).string(" ]");
                    witness.string("  current: ").hex((WordBase)currentPointer).string("  object does not verify").string("]").newline();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (witness != null) {
                        if (throwable != null) {
                            try {
                                witness.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            witness.close();
                        }
                    }
                }
            }
            return true;
        }
    }

    class ImageHeapRegionVerifier
    implements MemoryWalker.ImageHeapRegionVisitor {
        private final ImageHeapObjectVerifier objectVerifier;
        boolean verifyResult;

        ImageHeapRegionVerifier() {
            this.objectVerifier = new ImageHeapObjectVerifier();
        }

        void reset() {
            this.verifyResult = true;
        }

        @Override
        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            Log trace = HeapVerifier.getTraceLog();
            trace.string("[ImageHeapRegionVerifier:").newline();
            Pointer regionStart = (Pointer)access.getStart(region);
            Pointer regionEnd = regionStart.add(access.getSize(region));
            trace.string("  [ regionStart: ").hex((WordBase)regionStart).string("  .. regionEnd: ").hex((WordBase)regionEnd).string(" ]").newline();
            this.objectVerifier.reset(regionStart, regionEnd);
            boolean visitResult = access.visitObjects(region, this.objectVerifier);
            this.verifyResult = this.verifyResult && this.objectVerifier.verifyResult;
            trace.string("  returns: ").bool(this.verifyResult).string("]").newline();
            return visitResult;
        }
    }

    static final class VerifyVMOperation
    extends JavaVMOperation {
        private final String cause;
        private final HeapVerifier verifier;
        private final Occasion occasion;
        private boolean result;

        VerifyVMOperation(String cause, HeapVerifier verifier, Occasion occasion) {
            super("HeapVerification", VMOperation.SystemEffect.SAFEPOINT);
            this.cause = cause;
            this.verifier = verifier;
            this.occasion = occasion;
            this.result = false;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while verifying the heap.")
        public void operate() {
            HeapVerifier previousVerifier = HeapImpl.getHeapImpl().getHeapVerifier();
            HeapImpl.getHeapImpl().setHeapVerifier(this.verifier);
            this.result = this.verifier.verifyOperation(this.cause, this.occasion);
            HeapImpl.getHeapImpl().setHeapVerifier(previousVerifier);
        }

        public boolean getResult() {
            return this.result;
        }
    }

    public static enum Occasion {
        BEFORE_COLLECTION,
        DURING_COLLECTION,
        AFTER_COLLECTION;

    }
}

