/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.util.json.JSONParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ResourceConfigurationParser
extends ConfigurationParser {
    private final ResourcesRegistry registry;

    public <T> ResourceConfigurationParser(ResourcesRegistry registry, boolean strictConfig) {
        super(strictConfig);
        this.registry = registry;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        this.parseTopLevelObject(ResourceConfigurationParser.asMap(json, "first level of document must be an object"));
    }

    private void parseTopLevelObject(Map<String, Object> obj) {
        Object resourcesObject = null;
        Object bundlesObject = null;
        for (Map.Entry<String, Object> pair : obj.entrySet()) {
            if ("resources".equals(pair.getKey())) {
                resourcesObject = pair.getValue();
                continue;
            }
            if (!"bundles".equals(pair.getKey())) continue;
            bundlesObject = pair.getValue();
        }
        if (resourcesObject != null) {
            if (resourcesObject instanceof Map) {
                Map resourcesObjectMap = (Map)resourcesObject;
                this.checkAttributes(resourcesObjectMap, "resource descriptor object", Collections.singleton("includes"), Collections.singleton("excludes"));
                Object includesObject = resourcesObjectMap.get("includes");
                Object excludesObject = resourcesObjectMap.get("excludes");
                List<Object> includes = ResourceConfigurationParser.asList(includesObject, "Attribute 'includes' must be a list of resources");
                for (Object object : includes) {
                    this.parseEntry(object, "pattern", this.registry::addResources, "resource descriptor object", "'includes' list");
                }
                if (excludesObject != null) {
                    List<Object> excludes = ResourceConfigurationParser.asList(excludesObject, "Attribute 'excludes' must be a list of resources");
                    for (Object object : excludes) {
                        this.parseEntry(object, "pattern", this.registry::ignoreResources, "resource descriptor object", "'excludes' list");
                    }
                }
            } else {
                List<Object> resources = ResourceConfigurationParser.asList(resourcesObject, "Attribute 'resources' must be a list of resources");
                for (Object object : resources) {
                    this.parseEntry(object, "pattern", this.registry::addResources, "resource descriptor object", "'resources' list");
                }
            }
        }
        if (bundlesObject != null) {
            List<Object> bundles = ResourceConfigurationParser.asList(bundlesObject, "Attribute 'bundles' must be a list of bundles");
            for (Object object : bundles) {
                this.parseEntry(object, "name", this.registry::addResourceBundles, "bundle descriptor object", "'bundles' list");
            }
        }
    }

    private void parseEntry(Object data, String valueKey, Consumer<String> resourceRegistry, String expectedType, String parentType) {
        Map<String, Object> resource = ResourceConfigurationParser.asMap(data, "Elements of " + parentType + " must be a " + expectedType);
        this.checkAttributes(resource, "resource and resource bundle descriptor object", Collections.singleton(valueKey));
        Object valueObject = resource.get(valueKey);
        String value = ResourceConfigurationParser.asString(valueObject, valueKey);
        resourceRegistry.accept(value);
    }
}

