/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.EncodedSpeculationReason;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.graal.isolated.IsolatedSpeculationReason;
import com.oracle.svm.graal.isolated.IsolatedSpeculationReasonEncoding;
import java.nio.ByteBuffer;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;

public final class IsolatedSpeculationLog
extends IsolatedObjectProxy<SpeculationLog>
implements SpeculationLog {
    public IsolatedSpeculationLog(ClientHandle<SpeculationLog> logHandle) {
        super(logHandle);
    }

    public void collectFailedSpeculations() {
        IsolatedSpeculationLog.collectFailedSpeculations0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public boolean maySpeculate(SpeculationLog.SpeculationReason reason) {
        SpeculationLog.SpeculationReasonEncoding encoding = reason.encode(IsolatedSpeculationReasonEncoding::new);
        byte[] bytes = ((IsolatedSpeculationReasonEncoding)encoding).getByteArray();
        try (PinnedObject pinnedBytes = PinnedObject.create((Object)bytes);){
            boolean bl = IsolatedSpeculationLog.maySpeculate0(IsolatedCompileContext.get().getClient(), this.handle, pinnedBytes.addressOfArrayElement(0), bytes.length);
            return bl;
        }
    }

    public SpeculationLog.Speculation speculate(SpeculationLog.SpeculationReason reason) {
        ClientHandle<SpeculationLog.SpeculationReason> reasonHandle;
        SpeculationLog.SpeculationReasonEncoding encoding = reason.encode(IsolatedSpeculationReasonEncoding::new);
        byte[] bytes = ((IsolatedSpeculationReasonEncoding)encoding).getByteArray();
        try (PinnedObject pinnedBytes = PinnedObject.create((Object)bytes);){
            reasonHandle = IsolatedSpeculationLog.speculate0(IsolatedCompileContext.get().getClient(), this.handle, pinnedBytes.addressOfArrayElement(0), bytes.length);
        }
        return new SubstrateSpeculationLog.SubstrateSpeculation(new IsolatedSpeculationReason(reasonHandle));
    }

    public boolean hasSpeculations() {
        return IsolatedSpeculationLog.hasSpeculations0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public SpeculationLog.Speculation lookupSpeculation(JavaConstant constant) {
        throw VMError.shouldNotReachHere("not required");
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void collectFailedSpeculations0(ClientIsolateThread client, ClientHandle<SpeculationLog> logHandle) {
        IsolatedCompileClient.get().unhand(logHandle).collectFailedSpeculations();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static boolean hasSpeculations0(ClientIsolateThread client, ClientHandle<SpeculationLog> logHandle) {
        return IsolatedCompileClient.get().unhand(logHandle).hasSpeculations();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static boolean maySpeculate0(ClientIsolateThread client, ClientHandle<SpeculationLog> logHandle, PointerBase arrayData, int length) {
        byte[] bytes = new byte[length];
        ByteBuffer.wrap(bytes).put(CTypeConversion.asByteBuffer((PointerBase)arrayData, (int)length));
        SpeculationLog log = IsolatedCompileClient.get().unhand(logHandle);
        return log.maySpeculate((SpeculationLog.SpeculationReason)new EncodedSpeculationReason(bytes));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<SpeculationLog.SpeculationReason> speculate0(ClientIsolateThread client, ClientHandle<SpeculationLog> logHandle, PointerBase arrayData, int length) {
        byte[] bytes = new byte[length];
        ByteBuffer.wrap(bytes).put(CTypeConversion.asByteBuffer((PointerBase)arrayData, (int)length));
        SpeculationLog log = IsolatedCompileClient.get().unhand(logHandle);
        EncodedSpeculationReason encodedReason = new EncodedSpeculationReason(bytes);
        SpeculationLog.Speculation speculation = log.speculate((SpeculationLog.SpeculationReason)encodedReason);
        SpeculationLog.SpeculationReason reason = speculation.getReason();
        assert (speculation.equals((Object)new SubstrateSpeculationLog.SubstrateSpeculation(reason)));
        return IsolatedCompileClient.get().hand(reason);
    }
}

