/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import java.util.Arrays;
import java.util.List;

class MethodHandleUtils {
    static final String methodHandleClass = "java.lang.invoke.MethodHandle";
    static final List<String> polymorphicSignatureMethods = Arrays.asList("invokeBasic", "linkToVirtual", "linkToStatic");

    MethodHandleUtils() {
    }

    static boolean isPolymorphicSignatureMethod(Class<?> declaringClass, String name) {
        return declaringClass.getName().equals(methodHandleClass) && polymorphicSignatureMethods.contains(name);
    }
}

