/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ModuleAccess;
import com.oracle.svm.hosted.analysis.Inflation;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
public class ServiceLoaderFeature
implements Feature {
    private static final Set<String> SERVICES_TO_SKIP = new HashSet<String>(Arrays.asList("java.security.Provider", "sun.util.locale.provider.LocaleDataMetaInfo"));
    private static final Set<String> SERVICE_PROVIDERS_TO_SKIP = new HashSet<String>(Arrays.asList("com.sun.jndi.rmi.registry.RegistryContextFactory"));
    private static final String LOCATION_PREFIX = "META-INF/services/";
    private final Map<AnalysisType, Boolean> processedTypes = new ConcurrentHashMap<AnalysisType, Boolean>();
    private Map<String, List<String>> serviceProviders;
    private final boolean trace = Options.TraceServiceLoaderFeature.getValue();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.UseServiceLoaderFeature.getValue();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        Collections.addAll(SERVICES_TO_SKIP, (Object[])Options.ServiceLoaderFeatureExcludeServices.getValue());
        Collections.addAll(SERVICE_PROVIDERS_TO_SKIP, (Object[])Options.ServiceLoaderFeatureExcludeServiceProviders.getValue());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.serviceProviders = ModuleAccess.lookupServiceProviders(access);
        if (this.trace) {
            int services = this.serviceProviders.keySet().size();
            int providers = this.serviceProviders.values().stream().mapToInt(List::size).sum();
            System.out.println("ServiceLoaderFeature: Discovered " + services + " with " + providers + " service providers registered using modules");
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        boolean workDone = false;
        for (AnalysisType type : access.getUniverse().getTypes()) {
            if (!this.handleType(type, access)) continue;
            workDone = true;
        }
        if (workDone) {
            DebugContext debugContext = access.getDebugContext();
            try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
                debugContext.log("Resources have been added by ServiceLoaderFeature. Automatic registration can be disabled with " + SubstrateOptionsParser.commandArgument(Options.UseServiceLoaderFeature, "-"));
            }
        }
    }

    private boolean handleType(AnalysisType type, FeatureImpl.DuringAnalysisAccessImpl access) {
        Enumeration<URL> resourceURLs;
        if (!type.isReachable() || type.isArray()) {
            return false;
        }
        if (this.processedTypes.putIfAbsent(type, Boolean.TRUE) != null) {
            return false;
        }
        String serviceClassName = type.toClassName();
        String serviceResourceLocation = LOCATION_PREFIX + serviceClassName;
        if (SERVICES_TO_SKIP.contains(serviceClassName)) {
            if (this.trace) {
                System.out.println("ServiceLoaderFeature: Skipping service " + serviceClassName);
            }
            return false;
        }
        TreeSet<String> implementationClassNames = new TreeSet<String>();
        try {
            resourceURLs = access.getImageClassLoader().getClassLoader().getResources(serviceResourceLocation);
        }
        catch (IOException ex) {
            throw UserError.abort(ex, "Error loading service implementation resources for service `%s`", serviceClassName);
        }
        while (resourceURLs.hasMoreElements()) {
            URL resourceURL = resourceURLs.nextElement();
            try {
                implementationClassNames.addAll(ServiceLoaderFeature.parseServiceResource(resourceURL));
            }
            catch (IOException ex) {
                throw UserError.abort(ex, "Error loading service implementations for service `%s` from URL `%s`", serviceClassName, resourceURL);
            }
        }
        List<String> providers = this.serviceProviders.get(serviceClassName);
        if (providers != null) {
            if (this.trace) {
                System.out.println("ServiceLoaderFeature: found service declared using java modules: " + serviceClassName + " with providers: " + providers);
            }
            implementationClassNames.addAll(providers);
        }
        if (implementationClassNames.size() == 0) {
            return false;
        }
        if (this.trace) {
            System.out.println("ServiceLoaderFeature: processing service class " + serviceClassName);
        }
        StringBuilder newResourceValue = new StringBuilder(1024);
        for (String implementationClassName : implementationClassNames) {
            Class<?> implementationClass;
            if (implementationClassName.startsWith("org.graalvm.compiler") && implementationClassName.contains("hotspot")) {
                if (!this.trace) continue;
                System.out.println("  IGNORING HotSpot-specific implementation class: " + implementationClassName);
                continue;
            }
            if (SERVICE_PROVIDERS_TO_SKIP.contains(implementationClassName)) {
                if (!this.trace) continue;
                System.out.println("  ignoring implementation class: " + implementationClassName);
                continue;
            }
            if (this.trace) {
                System.out.println("  adding implementation class: " + implementationClassName);
            }
            if ((implementationClass = access.findClassByName(implementationClassName)) == null) {
                throw UserError.abort("Could not find registered service implementation class `%s` for service `%s`", implementationClassName, serviceClassName);
            }
            try {
                access.getMetaAccess().lookupJavaType(implementationClass);
            }
            catch (UnsupportedFeatureException ex) {
                if (!this.trace) continue;
                System.out.println("  cannot resolve: " + ex.getMessage());
                continue;
            }
            if (((Inflation)access.getBigBang()).getAnnotationSubstitutionProcessor().isDeleted(implementationClass)) continue;
            try {
                implementationClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
            RuntimeReflection.register((Class[])new Class[]{implementationClass});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{implementationClass});
            newResourceValue.append(implementationClass.getName());
            newResourceValue.append('\n');
        }
        DebugContext debugContext = access.getDebugContext();
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            debugContext.log("ServiceLoaderFeature: registerResource: " + serviceResourceLocation);
        }
        Resources.registerResource(serviceResourceLocation, new ByteArrayInputStream(newResourceValue.toString().getBytes(StandardCharsets.UTF_8)));
        access.requireAnalysisIteration();
        return true;
    }

    private static Collection<String> parseServiceResource(URL resourceURL) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), "utf-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                int commentIndex = line.indexOf(35);
                if (commentIndex >= 0) {
                    line = line.substring(0, commentIndex);
                }
                if ((line = line.trim()).length() == 0) continue;
                result.add(line);
            }
        }
        return result;
    }

    public static class Options {
        @Option(help={"Automatically register services for run-time lookup using ServiceLoader"}, type=OptionType.Expert)
        public static final HostedOptionKey<Boolean> UseServiceLoaderFeature = new HostedOptionKey<Boolean>(true);
        @Option(help={"When enabled, each service loader resource and class will be printed out to standard output"}, type=OptionType.Debug)
        public static final HostedOptionKey<Boolean> TraceServiceLoaderFeature = new HostedOptionKey<Boolean>(false);
        @Option(help={"Comma-separated list of services that should be excluded"}, type=OptionType.Expert)
        public static final HostedOptionKey<String[]> ServiceLoaderFeatureExcludeServices = new HostedOptionKey<String[]>(new String[0]);
        @Option(help={"Comma-separated list of service providers that should be excluded"}, type=OptionType.Expert)
        public static final HostedOptionKey<String[]> ServiceLoaderFeatureExcludeServiceProviders = new HostedOptionKey<String[]>(new String[0]);
    }
}

