/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk8.zipfile;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk8.zipfile.ZipFile;
import sun.misc.JavaUtilZipFileAccess;
import sun.misc.PerfCounter;
import sun.misc.SharedSecrets;

final class ZipFileUtil {
    ZipFileUtil() {
    }

    static void setJavaUtilZipFileAccess() {
        SharedSecrets.setJavaUtilZipFileAccess((JavaUtilZipFileAccess)new JavaUtilZipFileAccess(){

            public boolean startsWithLocHeader(java.util.zip.ZipFile zip) {
                return SubstrateUtil.cast((Object)zip, ZipFile.class).zsrc.startsWithLoc;
            }
        });
    }

    static void updateZipFileCounters(long startZipFileOpen) {
        PerfCounter.getZipFileOpenTime().addElapsedTimeFrom(startZipFileOpen);
        PerfCounter.getZipFileCount().increment();
    }
}

