/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.dashboard.ToJson;
import com.oracle.svm.hosted.image.NativeImageHeap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;

class HeapBreakdownJsonObject
extends ToJson.JsonObject {
    private final Feature.AfterHeapLayoutAccess access;
    private boolean built = false;
    private static final String INFO_NAME = "name";
    private static final String INFO_SIZE = "size";
    private static final String INFO_COUNT = "count";
    private static final List<String> NAMES = Arrays.asList("name", "size", "count");
    private final HashMap<String, Statistics> sizes = new HashMap();

    HeapBreakdownJsonObject(Feature.AfterHeapLayoutAccess access) {
        this.access = access;
    }

    /*
     * Exception decompiling
     */
    Map<String, Long[]> getData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    Stream<String> getNames() {
        return Arrays.asList("heap-size").stream();
    }

    @Override
    ToJson.JsonValue getValue(String name) {
        return ToJson.JsonArray.get(this.sizes.entrySet().stream().map(ClassJsonObject::new));
    }

    @Override
    protected void build() {
        if (this.built) {
            return;
        }
        FeatureImpl.AfterHeapLayoutAccessImpl config = (FeatureImpl.AfterHeapLayoutAccessImpl)this.access;
        NativeImageHeap heap = config.getHeap();
        for (NativeImageHeap.ObjectInfo info : heap.getObjects()) {
            String className = info.getClazz().getName();
            Statistics stats = this.sizes.get(className);
            if (stats == null) {
                stats = new Statistics();
                this.sizes.put(className, stats);
            }
            stats.size += info.getSize();
            ++stats.count;
        }
        this.built = true;
    }

    private class Statistics {
        long size = 0L;
        long count = 0L;

        private Statistics() {
        }
    }

    private static class ClassJsonObject
    extends ToJson.JsonObject {
        private final Map.Entry<String, Statistics> entry;

        ClassJsonObject(Map.Entry<String, Statistics> entry) {
            this.entry = entry;
        }

        @Override
        Stream<String> getNames() {
            return NAMES.stream();
        }

        @Override
        ToJson.JsonValue getValue(String name) {
            switch (name) {
                case "name": {
                    return ToJson.JsonString.get(this.entry.getKey());
                }
                case "size": {
                    return ToJson.JsonNumber.get(this.entry.getValue().size);
                }
                case "count": {
                    return ToJson.JsonNumber.get(this.entry.getValue().count);
                }
            }
            return null;
        }
    }
}

