/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.dashboard.ToJson;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;

class CodeBreakdownJsonObject
extends ToJson.JsonObject {
    private final Feature.AfterCompilationAccess access;
    private static final String INFO_NAME = "name";
    private static final List<String> NAMES = Arrays.asList("name", "size");

    CodeBreakdownJsonObject(Feature.AfterCompilationAccess access) {
        this.access = access;
    }

    public Map<String, Integer> getData() {
        return ((FeatureImpl.AfterCompilationAccessImpl)this.access).getCompilationTasks().stream().collect(Collectors.toMap(t -> t.method.format("%H.%n(%p) %r"), t -> t.result.getTargetCodeSize()));
    }

    @Override
    Stream<String> getNames() {
        return Arrays.asList("code-size").stream();
    }

    @Override
    ToJson.JsonValue getValue(String name) {
        return ToJson.JsonArray.get(((FeatureImpl.AfterCompilationAccessImpl)this.access).getCompilationTasks().stream().map(MethodJsonObject::new));
    }

    private static class MethodJsonObject
    extends ToJson.JsonObject {
        private final CompileQueue.CompileTask task;

        MethodJsonObject(CompileQueue.CompileTask task) {
            this.task = task;
        }

        @Override
        Stream<String> getNames() {
            return NAMES.stream();
        }

        @Override
        ToJson.JsonValue getValue(String name) {
            return name == CodeBreakdownJsonObject.INFO_NAME ? ToJson.JsonString.get(this.task.method.format("%H.%n(%p) %r")) : ToJson.JsonNumber.get(this.task.result.getTargetCodeSize());
        }
    }
}

