/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.Resources;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

@TargetClass(className="jdk.internal.loader.Loader", onlyWith={JDK11OrLater.class})
final class Target_jdk_internal_loader_Loader {
    Target_jdk_internal_loader_Loader() {
    }

    @Substitute
    private URL findResource(String mn, String name) {
        return this.findResource(name);
    }

    @Substitute
    private URL findResource(String name) {
        List<byte[]> arr = Resources.get(name);
        return arr == null ? null : Resources.createURL(name, arr.get(0));
    }

    @Substitute
    private Enumeration<URL> findResources(String name) {
        List<byte[]> arr = Resources.get(name);
        if (arr == null) {
            return Collections.emptyEnumeration();
        }
        ArrayList<URL> res = new ArrayList<URL>(arr.size());
        for (byte[] data : arr) {
            res.add(Resources.createURL(name, data));
        }
        return Collections.enumeration(res);
    }

    @Substitute
    private URL getResource(String name) {
        return this.findResource(name);
    }

    @Substitute
    private Enumeration<URL> getResources(String name) {
        return this.findResources(name);
    }
}

