/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.heap.InstanceReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class InteriorObjRefWalker {
    @NeverInline(value="Non-performance critical version")
    public static boolean walkObject(Object obj, ObjectReferenceVisitor visitor) {
        return InteriorObjRefWalker.walkObjectInline(obj, visitor);
    }

    @AlwaysInline(value="Performance critical version")
    public static boolean walkObjectInline(Object obj, ObjectReferenceVisitor visitor) {
        DynamicHub objHub = ObjectHeader.readDynamicHubFromObject(obj);
        int layoutEncoding = objHub.getLayoutEncoding();
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        if (LayoutEncoding.isObjectArray(layoutEncoding)) {
            int length = KnownIntrinsics.readArrayLength(obj);
            for (int index = 0; index < length; ++index) {
                boolean isCompressed;
                UnsignedWord elementOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, index);
                Pointer elementPointer = objPointer.add(elementOffset);
                boolean visitResult = visitor.visitObjectReferenceInline(elementPointer, isCompressed = ReferenceAccess.singleton().haveCompressedReferences(), obj);
                if (visitResult) continue;
                return false;
            }
        }
        NonmovableArray<Byte> referenceMapEncoding = DynamicHubSupport.getReferenceMapEncoding();
        long referenceMapIndex = objHub.getReferenceMapIndex();
        return InstanceReferenceMapDecoder.walkOffsetsFromPointer((Pointer)objPointer, referenceMapEncoding, referenceMapIndex, visitor, obj);
    }
}

