/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.thread.Safepoint;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

final class SafepointSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    private static void safepointSnippet() {
        boolean needSlowPath = SafepointCheckNode.test();
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)needSlowPath)) {
            SafepointSnippets.callSlowPathSafepointCheck(Safepoint.ENTER_SLOW_PATH_SAFEPOINT_CHECK);
        }
    }

    SafepointSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(SafepointNode.class, new SafepointLowering());
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPathSafepointCheck(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    class SafepointLowering
    implements NodeLoweringProvider<SafepointNode> {
        private final SnippetTemplate.SnippetInfo safepoint;

        SafepointLowering() {
            this.safepoint = SafepointSnippets.this.snippet(SafepointSnippets.class, "safepointSnippet", new LocationIdentity[]{Safepoint.getThreadLocalSafepointRequestedLocationIdentity()});
        }

        @Override
        public void lower(SafepointNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
                assert (SubstrateOptions.MultiThreaded.getValue().booleanValue()) : "safepoints are only inserted into the graph in MultiThreaded mode";
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.safepoint, node.graph().getGuardsStage(), tool.getLoweringStage());
                SafepointSnippets.this.template((ValueNode)node, args).instantiate(SafepointSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

