/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AbstractImageHeapLayouter;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.LinearImageHeapAllocator;
import com.oracle.svm.core.genscavenge.LinearImageHeapPartition;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;

public class LinearImageHeapLayouter
extends AbstractImageHeapLayouter<LinearImageHeapPartition> {
    private final ImageHeapInfo heapInfo;
    private final boolean compressedNullPadding;

    public LinearImageHeapLayouter(ImageHeapInfo heapInfo, boolean compressedNullPadding) {
        this.heapInfo = heapInfo;
        this.compressedNullPadding = compressedNullPadding;
    }

    protected LinearImageHeapPartition[] createPartitionsArray(int count) {
        return new LinearImageHeapPartition[count];
    }

    @Override
    protected LinearImageHeapPartition createPartition(String name, boolean containsReferences, boolean writable, boolean hugeObjects) {
        return new LinearImageHeapPartition(name, writable);
    }

    @Override
    protected ImageHeapLayoutInfo doLayout(ImageHeap imageHeap) {
        long startOffset = 0L;
        if (this.compressedNullPadding) {
            startOffset += (long)ConfigurationValues.getObjectLayout().getAlignment();
        }
        LinearImageHeapAllocator allocator = new LinearImageHeapAllocator(startOffset);
        for (LinearImageHeapPartition partition : (LinearImageHeapPartition[])this.getPartitions()) {
            partition.allocateObjects(allocator);
        }
        this.initializeHeapInfo(imageHeap.countDynamicHubs());
        return this.createDefaultLayoutInfo();
    }

    private void initializeHeapInfo(int dynamicHubCount) {
        this.heapInfo.initialize(((LinearImageHeapPartition)this.getReadOnlyPrimitive()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyPrimitive()).lastObject, ((LinearImageHeapPartition)this.getReadOnlyReference()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyReference()).lastObject, ((LinearImageHeapPartition)this.getReadOnlyRelocatable()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyRelocatable()).lastObject, ((LinearImageHeapPartition)this.getWritablePrimitive()).firstObject, ((LinearImageHeapPartition)this.getWritablePrimitive()).lastObject, ((LinearImageHeapPartition)this.getWritableReference()).firstObject, ((LinearImageHeapPartition)this.getWritableReference()).lastObject, ((LinearImageHeapPartition)this.getWritableHuge()).firstObject, ((LinearImageHeapPartition)this.getWritableHuge()).lastObject, ((LinearImageHeapPartition)this.getReadOnlyHuge()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyHuge()).lastObject, -1L, -1L, dynamicHubCount);
    }
}

