/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Set;
import org.graalvm.compiler.nodes.ValueNode;

public abstract class TypeFlowIterator {
    private final BigBang bb;
    private final Deque<WorkListEntry> worklist;
    private final Set<TypeFlow<?>> processed;

    protected TypeFlowIterator(BigBang bb) {
        this.bb = bb;
        this.worklist = new ArrayDeque<WorkListEntry>();
        this.processed = Collections.newSetFromMap(new IdentityHashMap());
    }

    public final void addRoot(TypeFlow<?> rootFlow) {
        this.add(rootFlow, null);
    }

    protected abstract boolean process(TypeFlow<?> var1);

    public final void finish() {
        while (!this.worklist.isEmpty()) {
            WorkListEntry entry = this.worklist.removeFirst();
            if (!this.process(entry.flow)) continue;
            for (TypeFlow use : entry.flow.getUses()) {
                this.add(use, entry);
            }
        }
    }

    private void add(TypeFlow<?> flow, WorkListEntry reason) {
        if (this.processed.contains(flow)) {
            return;
        }
        this.processed.add(flow);
        WorkListEntry entry = new WorkListEntry(flow, reason);
        this.worklist.add(entry);
        if (!flow.isClone() && flow.getSource() instanceof ValueNode) {
            AnalysisMethod method = (AnalysisMethod)((ValueNode)flow.getSource()).graph().method();
            for (MethodFlowsGraph methodFlow : method.getTypeFlow().getMethodContextFlows().values()) {
                TypeFlow curClone = methodFlow.lookupCloneOf(this.bb, flow);
                this.add(curClone, entry);
            }
        }
    }

    public static class WorkListEntry {
        protected final TypeFlow<?> flow;
        protected final WorkListEntry reason;

        protected WorkListEntry(TypeFlow<?> flow, WorkListEntry reason) {
            this.flow = flow;
            this.reason = reason;
        }
    }
}

