/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.PauseNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public final class Safepoint {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_SLOW_PATH_SAFEPOINT_CHECK = SnippetRuntime.findForeignCall(Safepoint.class, "enterSlowPathSafepointCheck", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_SLOW_PATH_NATIVE_TO_JAVA = SnippetRuntime.findForeignCall(Safepoint.class, "enterSlowPathNativeToJava", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ENTER_SLOW_PATH_NATIVE_TO_JAVA, ENTER_SLOW_PATH_SAFEPOINT_CHECK};
    static final FastThreadLocalInt safepointRequested = FastThreadLocalFactory.createInt();

    private Safepoint() {
    }

    private static long getSafepointPromptnessWarningNanos() {
        return Options.SafepointPromptnessWarningNanos.getValue();
    }

    private static long getSafepointPromptnessFailureNanos() {
        return Options.SafepointPromptnessFailureNanos.getValue();
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void slowPathSafepointCheck(boolean callerHasJavaFrameAnchor) {
        IsolateThread myself = CurrentIsolate.getCurrentThread();
        if (Master.singleton().getRequestingThread() == myself) {
            assert (!ThreadingSupportImpl.isRecurringCallbackRegistered(myself) || ThreadingSupportImpl.isRecurringCallbackPaused());
        } else {
            do {
                if (!Master.singleton().getRequestingThread().isNonNull()) continue;
                Statistics.incFrozen();
                Safepoint.freezeAtSafepoint(callerHasJavaFrameAnchor);
                Statistics.incThawed();
                VMError.guarantee(VMThreads.StatusSupport.isStatusJava(), "Must be back in Java state");
            } while (!VMThreads.StatusSupport.isStatusJava() && !VMThreads.StatusSupport.compareAndSetNativeToJava());
        }
        VMError.guarantee(VMThreads.StatusSupport.isStatusJava(), "Must be back in Java state");
        ThreadingSupportImpl.onSafepointCheckSlowpath();
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void freezeAtSafepoint(boolean callerHasJavaFrameAnchor) {
        if (VMThreads.StatusSupport.isStatusJava()) {
            CFunctionPrologueNode.cFunctionPrologue();
            Safepoint.notInlinedLockNoTransition();
            CFunctionEpilogueNode.cFunctionEpilogue();
        } else {
            VMError.guarantee(callerHasJavaFrameAnchor);
            Safepoint.notInlinedLockNoTransition();
            boolean result = VMThreads.StatusSupport.compareAndSetNativeToJava();
            if (!result) {
                throw VMError.shouldNotReachHere("Transition to Java failed");
            }
        }
        VMThreads.THREAD_MUTEX.unlock();
    }

    @NeverInline(value="CFunctionPrologue and CFunctionEpilogue are placed around call to this function")
    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void notInlinedLockNoTransition() {
        VMThreads.THREAD_MUTEX.lockNoTransition();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void setSafepointRequested(IsolateThread vmThread, int value) {
        assert (CurrentIsolate.getCurrentThread().isNull() || VMOperationControl.mayExecuteVmOperations());
        assert (value > 0);
        safepointRequested.setVolatile(vmThread, value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void setSafepointRequested(int value) {
        assert (value >= 0);
        safepointRequested.setVolatile(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static int getSafepointRequested(IsolateThread vmThread) {
        return safepointRequested.getVolatile(vmThread);
    }

    public static LocationIdentity getThreadLocalSafepointRequestedLocationIdentity() {
        return safepointRequested.getLocationIdentity();
    }

    public static long getThreadLocalSafepointRequestedOffset() {
        return VMThreadLocalInfos.getOffset(safepointRequested);
    }

    @SubstrateForeignCallTarget
    @Uninterruptible(reason="Must not contain safepoint checks")
    private static void enterSlowPathSafepointCheck() throws Throwable {
        if (VMThreads.StatusSupport.isStatusIgnoreSafepoints(CurrentIsolate.getCurrentThread())) {
            Safepoint.setSafepointRequested(Integer.MAX_VALUE);
            return;
        }
        VMError.guarantee(VMThreads.StatusSupport.isStatusJava(), "Attempting to do a safepoint check when not in Java mode");
        try {
            Safepoint.slowPathSafepointCheck(false);
        }
        catch (SafepointException se) {
            throw se.inner;
        }
        catch (Throwable ex) {
            VMError.shouldNotReachHere(ex);
        }
    }

    public static void transitionNativeToJava() {
        boolean needSlowPath;
        boolean bl = needSlowPath = ThreadingSupportImpl.needsNativeToJavaSlowpath() || !VMThreads.StatusSupport.compareAndSetNativeToJava();
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)needSlowPath)) {
            Safepoint.callSlowPathNativeToJava(ENTER_SLOW_PATH_NATIVE_TO_JAVA);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPathNativeToJava(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @SubstrateForeignCallTarget
    @Uninterruptible(reason="Must not contain safepoint checks")
    private static void enterSlowPathNativeToJava() {
        VMError.guarantee(!VMThreads.StatusSupport.isStatusJava(), "Attempting to do a Native-to-Java transition when already in Java mode");
        VMError.guarantee(!VMThreads.StatusSupport.isStatusIgnoreSafepoints(CurrentIsolate.getCurrentThread()), "When safepoints are disabled, the thread can only be in Native mode, so the fast path transition must succeed and this slow path must not be called");
        Statistics.incSlowPathFrozen();
        try {
            Safepoint.slowPathSafepointCheck(true);
        }
        finally {
            Statistics.incSlowPathThawed();
        }
    }

    public static final class Statistics {
        private static long startNanos;
        private static long frozenNanos;
        private static long thawedNanos;
        private static int requested;
        private static int installed;
        private static int released;
        private static final UninterruptibleUtils.AtomicInteger frozen;
        private static final UninterruptibleUtils.AtomicInteger thawed;
        private static final UninterruptibleUtils.AtomicInteger slowPathFrozen;
        private static final AtomicInteger slowPathThawed;

        private Statistics() {
        }

        public static void reset() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                startNanos = 0L;
                frozenNanos = 0L;
                thawedNanos = 0L;
                requested = 0;
                installed = 0;
                released = 0;
                frozen.set(0);
                thawed.set(0);
                slowPathFrozen.set(0);
                slowPathThawed.set(0);
            }
        }

        public static long getStartNanos() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return startNanos;
        }

        public static void setStartNanos() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                startNanos = System.nanoTime();
            }
        }

        public static long getFrozenNanos() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return frozenNanos;
        }

        public static void setFrozenNanos() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                frozenNanos = TimeUtils.nanoSecondsSince(Statistics.getStartNanos());
            }
        }

        public static long getThawedNanos() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return thawedNanos;
        }

        public static void setThawedNanos() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                thawedNanos = TimeUtils.nanoSecondsSince(Statistics.getStartNanos());
            }
        }

        public static int getRequested() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return requested;
        }

        public static void incRequested() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                ++requested;
            }
        }

        public static int getInstalled() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return installed;
        }

        public static void incInstalled() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                ++installed;
            }
        }

        public static int getReleased() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return released;
        }

        public static void incReleased() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                ++released;
            }
        }

        public static int getFrozen() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return frozen.get();
        }

        @Uninterruptible(reason="Called when safepoints are requested.")
        public static void incFrozen() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                frozen.incrementAndGet();
            }
        }

        public static int getThawed() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return thawed.get();
        }

        @Uninterruptible(reason="Called during safepointing.")
        public static void incThawed() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                thawed.incrementAndGet();
            }
        }

        public static int getSlowPathFrozen() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return slowPathFrozen.get();
        }

        @Uninterruptible(reason="Called when safepoints are requested.")
        public static void incSlowPathFrozen() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                slowPathFrozen.incrementAndGet();
            }
        }

        public static int getSlowPathThawed() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return slowPathThawed.get();
        }

        @Uninterruptible(reason="Called when safepoints are requested.")
        public static void incSlowPathThawed() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                slowPathThawed.incrementAndGet();
            }
        }

        public static Log toLog(Log log, boolean newLine, String prefix) {
            if (log.isEnabled() && Options.GatherSafepointStatistics.getValue().booleanValue()) {
                if (newLine) {
                    log.newline();
                }
                log.string("[Safepoint.Statistics: ").string(prefix).newline();
                log.string("      startNanos: ").signed(Statistics.getStartNanos()).newline();
                log.string("     frozenNanos: ").signed(Statistics.getFrozenNanos()).newline();
                log.string("     thawedNanos: ").signed(Statistics.getThawedNanos()).newline();
                log.string("       requested: ").signed(Statistics.getRequested()).newline();
                log.string("       installed: ").signed(Statistics.getInstalled()).newline();
                log.string("        released: ").signed(Statistics.getReleased()).newline();
                log.string("          frozen: ").signed(Statistics.getFrozen()).newline();
                log.string("          thawed: ").signed(Statistics.getThawed()).newline();
                log.string("  slowPathFrozen: ").signed(Statistics.getSlowPathFrozen()).newline();
                log.string("  slowPathThawed: ").signed(Statistics.getSlowPathThawed()).string("]").newline();
            }
            return log;
        }

        static {
            frozen = new UninterruptibleUtils.AtomicInteger(0);
            thawed = new UninterruptibleUtils.AtomicInteger(0);
            slowPathFrozen = new UninterruptibleUtils.AtomicInteger(0);
            slowPathThawed = new AtomicInteger(0);
        }

        public static class Options {
            @Option(help={"Gather statistics about each safepoint."})
            public static final HostedOptionKey<Boolean> GatherSafepointStatistics = new HostedOptionKey<Boolean>(false);
        }
    }

    public static final class Master {
        private static final int NOT_AT_SAFEPOINT = 0;
        private static final int SYNCHRONIZING = 1;
        private static final int AT_SAFEPOINT = 2;
        private volatile int safepointState = 0;
        private volatile IsolateThread requestingThread;

        static void initialize() {
            ImageSingletons.add(Master.class, (Object)new Master());
        }

        @Fold
        public static Master singleton() {
            return (Master)ImageSingletons.lookup(Master.class);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private Master() {
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="The safepoint logic must not allocate.")
        protected boolean freeze(String reason) {
            boolean lock;
            assert (SubstrateOptions.MultiThreaded.getValue().booleanValue()) : "Should only freeze for a safepoint when multi-threaded.";
            assert (VMOperationControl.mayExecuteVmOperations());
            boolean bl = lock = !VMThreads.THREAD_MUTEX.isOwner();
            if (lock) {
                VMThreads.THREAD_MUTEX.lock();
            }
            this.requestingThread = CurrentIsolate.getCurrentThread();
            Statistics.reset();
            Statistics.setStartNanos();
            ((Heap)ImageSingletons.lookup(Heap.class)).prepareForSafepoint();
            this.safepointState = 1;
            Master.requestSafepoints(reason);
            Master.waitForSafepoints(reason);
            Statistics.setFrozenNanos();
            this.safepointState = 2;
            return lock;
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="The safepoint logic must not allocate.")
        protected void thaw(String reason, boolean unlock) {
            assert (SubstrateOptions.MultiThreaded.getValue().booleanValue()) : "Should only thaw from a safepoint when multi-threaded.";
            assert (VMOperationControl.mayExecuteVmOperations());
            this.safepointState = 0;
            Master.releaseSafepoints(reason);
            ((Heap)ImageSingletons.lookup(Heap.class)).endSafepoint();
            Statistics.setThawedNanos();
            this.requestingThread = (IsolateThread)WordFactory.nullPointer();
            if (unlock) {
                VMThreads.THREAD_MUTEX.unlock();
            }
            VMThreads.singleton().cleanupExitedOsThreads();
        }

        private static boolean isMyself(IsolateThread thread) {
            return thread == CurrentIsolate.getCurrentThread();
        }

        private static void requestSafepoints(String reason) {
            VMThreads.THREAD_MUTEX.assertIsOwner("Must hold mutex while requesting a safepoint.");
            Log trace = Log.noopLog().string("[Safepoint.Master.requestSafepoints:  reason: ").string(reason);
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (!Master.isMyself(vmThread) && !VMThreads.StatusSupport.isStatusIgnoreSafepoints(vmThread)) {
                    Master.requestSafepoint(vmThread);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
            trace.string("  returns");
            if (trace.isEnabled() && Statistics.Options.GatherSafepointStatistics.getValue().booleanValue()) {
                trace.string(" with requests: ").signed(Statistics.getRequested());
            }
            trace.string("]").newline();
        }

        private static void requestSafepoint(IsolateThread vmThread) {
            int value;
            do {
                value = safepointRequested.getVolatile(vmThread);
                assert (value >= 0) : "the value can only be negative if a safepoint was requested";
            } while (!safepointRequested.compareAndSet(vmThread, value, -value));
            Statistics.incRequested();
        }

        private static void restoreSafepointRequestedValue(IsolateThread vmThread) {
            int value = Safepoint.getSafepointRequested(vmThread);
            if (value < 0) {
                int newValue = -(value + 2);
                assert (newValue >= -2 && newValue < Integer.MAX_VALUE) : "overflow";
                newValue = newValue <= 0 ? 1 : newValue;
                Safepoint.setSafepointRequested(vmThread, newValue);
            }
        }

        private static void waitForSafepoints(String reason) {
            long startNanos;
            Log trace = Log.noopLog().string("[Safepoint.Master.waitForSafepoints:  reason: ").string(reason).newline();
            VMThreads.THREAD_MUTEX.assertIsOwner("Must hold mutex while waiting for safepoints.");
            long loopNanos = startNanos = System.nanoTime();
            int loopCount = 1;
            while (true) {
                int atSafepoint = 0;
                int inNative = 0;
                int ignoreSafepoints = 0;
                int notAtSafepoint = 0;
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (!Master.isMyself(vmThread)) {
                        if (VMThreads.StatusSupport.isStatusIgnoreSafepoints(vmThread)) {
                            ++ignoreSafepoints;
                        } else {
                            int status = VMThreads.StatusSupport.getStatusVolatile(vmThread);
                            switch (status) {
                                case 1: {
                                    if (Safepoint.getSafepointRequested(vmThread) > 0 && !VMThreads.StatusSupport.isStatusIgnoreSafepoints(vmThread)) {
                                        Master.requestSafepoint(vmThread);
                                    }
                                    ++notAtSafepoint;
                                    break;
                                }
                                case 2: {
                                    ++atSafepoint;
                                    break;
                                }
                                case 3: {
                                    if (VMThreads.StatusSupport.compareAndSetNativeToSafepoint(vmThread)) {
                                        ++inNative;
                                        Statistics.incInstalled();
                                        break;
                                    }
                                    ++notAtSafepoint;
                                    break;
                                }
                                default: {
                                    throw VMError.shouldNotReachHere("Unexpected thread status");
                                }
                            }
                        }
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
                if (notAtSafepoint == 0) {
                    trace.string("  returns");
                    if (trace.isEnabled() && Statistics.Options.GatherSafepointStatistics.getValue().booleanValue()) {
                        trace.string(" with installed: ").signed(Statistics.getInstalled());
                    }
                    trace.string("]").newline();
                    return;
                }
                trace.string("  loopCount: ").signed(loopCount).string("  atSafepoint: ").signed(atSafepoint).string("  inNative: ").signed(inNative).string("  ignoreSafepoints: ").signed(ignoreSafepoints).string("  notAtSafepoint: ").signed(notAtSafepoint).newline();
                loopNanos = Master.doNotLoopTooLong(loopNanos, startNanos, reason);
                Master.maybeFatallyTooLong(startNanos, reason);
                PauseNode.pause();
                ++loopCount;
            }
        }

        private static void releaseSafepoints(String reason) {
            Log trace = Log.noopLog().string("[Safepoint.Master.releaseSafepoints:").string("  reason: ").string(reason).newline();
            VMThreads.THREAD_MUTEX.assertIsOwner("Must hold mutex when releasing safepoints.");
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (!Master.isMyself(vmThread) && !VMThreads.StatusSupport.isStatusIgnoreSafepoints(vmThread)) {
                    if (trace.isEnabled()) {
                        trace.string("  vmThread status: ").string(VMThreads.StatusSupport.getStatusString(vmThread));
                    }
                    Master.restoreSafepointRequestedValue(vmThread);
                    VMThreads.StatusSupport.setStatusNative(vmThread);
                    Statistics.incReleased();
                    if (trace.isEnabled()) {
                        trace.string("  ->  ").string(VMThreads.StatusSupport.getStatusString(vmThread)).newline();
                    }
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
            trace.string("]").newline();
        }

        private static long doNotLoopTooLong(long loopNanos, long startNanos, String reason) {
            long result = loopNanos;
            long waitedNanos = TimeUtils.nanoSecondsSince(loopNanos);
            long warningNanos = Safepoint.getSafepointPromptnessWarningNanos();
            if (0L < warningNanos && TimeUtils.nanoTimeLessThan(warningNanos, waitedNanos)) {
                Log warning = Log.log().string("[Safepoint.Master.doNotLoopTooLong:");
                warning.string("  warningNanos: ").signed(warningNanos).string(" < ").string(" waitedNanos: ").signed(waitedNanos);
                warning.string("  startNanos: ").signed(startNanos);
                warning.string("  reason: ").string(reason).string("]").newline();
                result = System.nanoTime();
            }
            return result;
        }

        private static void maybeFatallyTooLong(long startNanos, String reason) {
            long nanosSinceStart;
            long failureNanos = Safepoint.getSafepointPromptnessFailureNanos();
            if (0L < failureNanos && TimeUtils.nanoTimeLessThan(failureNanos, nanosSinceStart = TimeUtils.nanoSecondsSince(startNanos))) {
                Log warning = Log.log().string("[Safepoint.Master.maybeFatallyTooLong:");
                warning.string("  failureNanos: ").signed(failureNanos).string(" < nanosSinceStart: ").signed(nanosSinceStart);
                warning.string("  startNanos: ").signed(startNanos);
                warning.string("  reason: ").string(reason).string("]").newline();
                VMError.guarantee(false, "Safepoint promptness failure.");
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected IsolateThread getRequestingThread() {
            return this.requestingThread;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean isFrozen() {
            return this.safepointState == 2;
        }

        public static class TestingBackdoor {
            public static int countingVMOperation() {
                Log trace = Log.log().string("[Safepoint.Master.TestingBackdoor.countingVMOperation:").newline();
                int atSafepoint = 0;
                int inNative = 0;
                int ignoreSafepoints = 0;
                int notAtSafepoint = 0;
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (VMThreads.StatusSupport.isStatusSafepoint(vmThread)) {
                        ++atSafepoint;
                    } else if (VMThreads.StatusSupport.isStatusNative(vmThread)) {
                        ++inNative;
                    } else if (VMThreads.StatusSupport.isStatusIgnoreSafepoints(vmThread)) {
                        ++ignoreSafepoints;
                    } else {
                        ++notAtSafepoint;
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
                trace.string("  atSafepoint: ").signed(atSafepoint).string("  inNative: ").signed(inNative).string("  ignoreSafepoints: ").signed(ignoreSafepoints).string("  notAtSafepoint: ").signed(notAtSafepoint);
                trace.string("]").newline();
                int result = atSafepoint + inNative;
                return result;
            }

            @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
            public static int getCurrentThreadSafepointRequestedCount() {
                return Safepoint.getSafepointRequested(CurrentIsolate.getCurrentThread());
            }
        }
    }

    public static interface SafepointRequestValues {
        public static final int RESET = Integer.MAX_VALUE;
        public static final int ENTER = 1;
    }

    static class SafepointException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        final Throwable inner;

        SafepointException(Throwable inner) {
            this.inner = inner;
        }
    }

    public static class Options {
        @Option(help={"Print a warning if I can not come to a safepoint in this many nanoseconds. 0 implies forever."})
        public static final RuntimeOptionKey<Long> SafepointPromptnessWarningNanos = new RuntimeOptionKey<Long>(TimeUtils.millisToNanos(0L));
        @Option(help={"Exit the VM if I can not come to a safepoint in this many nanoseconds. 0 implies forever."})
        public static final RuntimeOptionKey<Long> SafepointPromptnessFailureNanos = new RuntimeOptionKey<Long>(TimeUtils.millisToNanos(0L));
    }
}

