/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.aarch64.AArch64CGlobalDataLoadAddressOp;
import com.oracle.svm.core.graal.aarch64.AArch64DecrementingSafepointCheckOp;
import com.oracle.svm.core.graal.aarch64.AArch64FarReturnOp;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64RegisterConfig;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.graal.code.SubstrateNodeLIRBuilder;
import com.oracle.svm.core.graal.lir.VerificationMarkerOp;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMapBuilder;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.util.VMError;
import java.util.Collection;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.BranchTargetOutOfBoundsException;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.aarch64.AArch64AddressLoweringByUse;
import org.graalvm.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64LIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64LIRKindTool;
import org.graalvm.compiler.core.aarch64.AArch64MoveFactory;
import org.graalvm.compiler.core.aarch64.AArch64NodeLIRBuilder;
import org.graalvm.compiler.core.aarch64.AArch64NodeMatchRules;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.core.gen.LIRGenerationProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64BreakpointOp;
import org.graalvm.compiler.lir.aarch64.AArch64Call;
import org.graalvm.compiler.lir.aarch64.AArch64ControlFlow;
import org.graalvm.compiler.lir.aarch64.AArch64FrameMap;
import org.graalvm.compiler.lir.aarch64.AArch64FrameMapBuilder;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.aarch64.AArch64PrefetchOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.framemap.FrameMapBuilderTool;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.common.AddressLoweringByUsePhase;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;

public class SubstrateAArch64Backend
extends SubstrateBackend
implements LIRGenerationProvider {
    public static final String MARK_PROLOGUE_DECD_RSP = "PROLOGUE_DECD_RSP";
    public static final String MARK_PROLOGUE_SAVED_REGS = "PROLOGUE_SAVED_REGS";
    public static final String MARK_PROLOGUE_END = "PROLOGUE_END";
    public static final String MARK_EPILOGUE_START = "EPILOGUE_START";
    public static final String MARK_EPILOGUE_INCD_RSP = "EPILOGUE_INCD_RSP";
    public static final String MARK_EPILOGUE_END = "EPILOGUE_END";

    protected static CompressEncoding getCompressEncoding() {
        return (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
    }

    public SubstrateAArch64Backend(Providers providers) {
        super(providers);
    }

    static void maybeTransitionToNative(CompilationResultBuilder crb, AArch64MacroAssembler masm, RuntimeConfiguration runtimeConfiguration, Value javaFrameAnchor, LIRFrameState state) {
        Register tempRegister;
        if (ValueUtil.isIllegal((Value)javaFrameAnchor)) {
            return;
        }
        Register anchor = ValueUtil.asRegister((Value)javaFrameAnchor);
        int startPos = masm.position();
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            tempRegister = scratch.getRegister();
            masm.adr(tempRegister, 4);
            crb.recordIndirectCall(startPos, masm.position(), null, state);
            masm.str(64, tempRegister, AArch64Address.createPairUnscaledImmediateAddress((Register)anchor, (int)runtimeConfiguration.getJavaFrameAnchorLastIPOffset()));
            masm.mov(64, tempRegister, AArch64.sp);
            masm.str(64, tempRegister, AArch64Address.createPairUnscaledImmediateAddress((Register)anchor, (int)runtimeConfiguration.getJavaFrameAnchorLastSPOffset()));
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            scratch = masm.getScratchRegister();
            var8_8 = null;
            try {
                tempRegister = scratch.getRegister();
                masm.mov(tempRegister, 3);
                masm.str(64, tempRegister, AArch64Address.createPairUnscaledImmediateAddress((Register)runtimeConfiguration.getThreadRegister(), (int)runtimeConfiguration.getVMThreadStatusOffset()));
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (scratch != null) {
                    if (var8_8 != null) {
                        try {
                            scratch.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        scratch.close();
                    }
                }
            }
        }
    }

    public FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new AArch64FrameMapBuilder(this.newFrameMap(registerConfigNonNull), this.getCodeCache(), registerConfigNonNull);
    }

    public FrameMap newFrameMap(RegisterConfig registerConfig) {
        return new AArch64FrameMap(this.getProviders().getCodeCache(), registerConfig, (FrameMap.ReferenceMapBuilderFactory)new SubstrateReferenceMapBuilderFactory());
    }

    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenResult, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory) {
        AArch64MacroAssembler masm = new AArch64MacroAssembler(this.getTarget());
        PatchConsumerFactory patchConsumerFactory = SubstrateUtil.HOSTED ? PatchConsumerFactory.HostedPatchConsumerFactory.factory() : PatchConsumerFactory.NativePatchConsumerFactory.factory();
        masm.setCodePatchingAnnotationConsumer(patchConsumerFactory.newConsumer(compilationResult));
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenResult).getMethod();
        Deoptimizer.StubType stubType = method.getDeoptStubType();
        SubstrateDataBuilder dataBuilder = new SubstrateDataBuilder();
        SubstrateAArch64FrameContext frameContext = stubType == Deoptimizer.StubType.EntryStub ? new DeoptEntryStubContext() : (stubType == Deoptimizer.StubType.ExitStub ? new DeoptExitStubContext() : new SubstrateAArch64FrameContext());
        LIR lir = lirGenResult.getLIR();
        OptionValues options = lir.getOptions();
        DebugContext debug = lir.getDebug();
        Register uncompressedNullRegister = SubstrateAArch64Backend.useLinearPointerCompression() ? SubstrateAArch64Backend.getHeapBaseRegister(lirGenResult) : Register.None;
        CompilationResultBuilder tasm = factory.createBuilder(this.getCodeCache(), this.getForeignCalls(), lirGenResult.getFrameMap(), (Assembler)masm, (DataBuilder)dataBuilder, (FrameContext)frameContext, options, debug, compilationResult, uncompressedNullRegister);
        tasm.setTotalFrameSize(lirGenResult.getFrameMap().totalFrameSize());
        return tasm;
    }

    protected AArch64ArithmeticLIRGenerator createArithmeticLIRGen(AllocatableValue nullRegisterValue) {
        return new AArch64ArithmeticLIRGenerator(nullRegisterValue);
    }

    protected static SubstrateAArch64RegisterConfig getRegisterConfig(LIRGenerationResult lirGenRes) {
        return (SubstrateAArch64RegisterConfig)lirGenRes.getRegisterConfig();
    }

    private static Register getHeapBaseRegister(LIRGenerationResult lirGenRes) {
        return SubstrateAArch64Backend.getRegisterConfig(lirGenRes).getHeapBaseRegister();
    }

    protected AArch64MoveFactory createMoveFactory(LIRGenerationResult lirGenRes) {
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenRes).getMethod();
        return new SubstrateAArch64MoveFactory(method, (LIRKindTool)this.createLirKindTool(), SubstrateAArch64Backend.getRegisterConfig(lirGenRes));
    }

    protected AArch64LIRKindTool createLirKindTool() {
        return new SubstrateAArch64LIRKindTool();
    }

    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        RegisterValue nullRegisterValue = SubstrateAArch64Backend.useLinearPointerCompression() ? SubstrateAArch64Backend.getHeapBaseRegister(lirGenRes).asValue((ValueKind)LIRKind.unknownReference((PlatformKind)AArch64Kind.QWORD)) : null;
        AArch64ArithmeticLIRGenerator arithmeticLIRGen = this.createArithmeticLIRGen((AllocatableValue)nullRegisterValue);
        AArch64MoveFactory moveFactory = this.createMoveFactory(lirGenRes);
        return new SubstrateAArch64LIRGenerator((LIRKindTool)this.createLirKindTool(), arithmeticLIRGen, (LIRGeneratorTool.MoveFactory)moveFactory, this.getProviders(), lirGenRes);
    }

    protected AArch64Kind getCompressedOopKind() {
        return AArch64Kind.QWORD;
    }

    protected AArch64NodeMatchRules createMatchRules(LIRGeneratorTool lirGen) {
        return new AArch64NodeMatchRules(lirGen);
    }

    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        AArch64NodeMatchRules nodeMatchRules = this.createMatchRules(lirGen);
        return new SubstrateAArch64NodeLIRBuilder(graph, lirGen, nodeMatchRules);
    }

    private static boolean useLinearPointerCompression() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    @Override
    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new RegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo);
    }

    @Override
    public CompilationResult createJNITrampolineMethod(ResolvedJavaMethod method, CompilationIdentifier identifier, RegisterValue threadArg, int threadIsolateOffset, RegisterValue methodIdArg, int methodObjEntryPointOffset) {
        CompilationResult result = new CompilationResult(identifier);
        AArch64MacroAssembler asm = new AArch64MacroAssembler(this.getTarget());
        try (AArch64MacroAssembler.ScratchRegister scratch = asm.getScratchRegister();){
            Register scratchRegister = scratch.getRegister();
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                asm.ldr(64, scratchRegister, AArch64Address.createUnscaledImmediateAddress((Register)threadArg.getRegister(), (int)threadIsolateOffset));
                asm.add(64, scratchRegister, scratchRegister, methodIdArg.getRegister());
                asm.ldr(64, scratchRegister, AArch64Address.createUnscaledImmediateAddress((Register)scratchRegister, (int)methodObjEntryPointOffset));
            } else {
                asm.ldr(64, scratchRegister, AArch64Address.createUnscaledImmediateAddress((Register)methodIdArg.getRegister(), (int)methodObjEntryPointOffset));
            }
            asm.jmp(scratchRegister);
        }
        result.recordMark(asm.position(), (Object)MARK_PROLOGUE_DECD_RSP);
        result.recordMark(asm.position(), (Object)MARK_PROLOGUE_END);
        byte[] instructions = asm.close(true);
        result.setTargetCode(instructions, instructions.length);
        result.setTotalFrameSize(this.getTarget().wordSize);
        return result;
    }

    protected CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, boolean isDefault, OptionValues options) {
        return new SubstrateCompiledCode(compilationResult);
    }

    public void emitCode(CompilationResultBuilder crb, LIR lir, ResolvedJavaMethod installedCodeOwner) {
        try {
            crb.buildLabelOffsets(lir);
            crb.emit(lir);
        }
        catch (BranchTargetOutOfBoundsException e) {
            crb.setConservativeLabelRanges();
            crb.resetForEmittingCode();
            lir.resetLabels();
            crb.emit(lir);
        }
    }

    @Override
    public SuitesProvider getSuites() {
        throw VMError.unimplemented();
    }

    public static int getDeoptScratchSpace() {
        return 16;
    }

    public LIRGenerationResult newLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, RegisterAllocationConfig registerAllocationConfig, StructuredGraph graph, Object stub) {
        SharedMethod method = (SharedMethod)graph.method();
        CallingConvention callingConvention = CodeUtil.getCallingConvention((CodeCacheProvider)this.getCodeCache(), (CallingConvention.Type)(method.isEntryPoint() ? SubstrateCallingConventionType.NativeCallee : SubstrateCallingConventionType.JavaCallee), (ResolvedJavaMethod)method, (ValueKindFactory)this);
        return new SubstrateLIRGenerationResult(compilationId, lir, this.newFrameMapBuilder(registerAllocationConfig.getRegisterConfig()), registerAllocationConfig, callingConvention, method);
    }

    @Override
    public Phase newAddressLoweringPhase(CodeCacheProvider codeCache) {
        return new AddressLoweringByUsePhase((AddressLoweringByUsePhase.AddressLoweringByUse)new AArch64AddressLoweringByUse(this.createLirKindTool()));
    }

    protected static class SubstrateAArch64LIRKindTool
    extends AArch64LIRKindTool {
        protected SubstrateAArch64LIRKindTool() {
        }

        public LIRKind getNarrowOopKind() {
            return LIRKind.compressedReference((PlatformKind)AArch64Kind.QWORD);
        }

        public LIRKind getNarrowPointerKind() {
            throw VMError.shouldNotReachHere();
        }
    }

    public static final class LoadCompressedObjectConstantOp
    extends AArch64Move.PointerCompressionOp
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<LoadCompressedObjectConstantOp> TYPE = LIRInstructionClass.create(LoadCompressedObjectConstantOp.class);
        private final SubstrateObjectConstant constant;

        static JavaConstant asCompressed(SubstrateObjectConstant constant) {
            return constant.isCompressed() ? constant : constant.compress();
        }

        public LoadCompressedObjectConstantOp(AllocatableValue result, SubstrateObjectConstant constant, AllocatableValue baseRegister, CompressEncoding encoding, LIRKindTool lirKindTool) {
            super(TYPE, result, (Value)new ConstantValue((ValueKind)lirKindTool.getNarrowOopKind(), (Constant)LoadCompressedObjectConstantOp.asCompressed(constant)), baseRegister, encoding, true, lirKindTool);
            this.constant = constant;
        }

        public Constant getConstant() {
            return this.constant;
        }

        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register resultReg = this.getResultRegister();
            int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            Constant inputConstant = LIRValueUtil.asConstantValue((Value)this.getInput()).getConstant();
            if (masm.target.inlineObjects) {
                crb.recordInlineDataInCode(inputConstant);
                masm.mov(resultReg, -2401018187971961171L, true);
            } else {
                AArch64Address address = (AArch64Address)crb.recordDataReferenceInCode(inputConstant, referenceSize);
                masm.loadAddress(resultReg, address, 1);
            }
            if (!this.constant.isCompressed()) {
                Register baseReg = this.getBaseRegister(crb);
                assert (!baseReg.equals((Object)Register.None) || this.getShift() != 0) : "no compression in place";
                masm.add(64, resultReg, baseReg, resultReg, AArch64Assembler.ShiftType.LSL, this.getShift());
            }
        }
    }

    protected static class SubstrateAArch64MoveFactory
    extends AArch64MoveFactory {
        private final SharedMethod method;
        private final LIRKindTool lirKindTool;
        private final SubstrateAArch64RegisterConfig registerConfig;

        protected SubstrateAArch64MoveFactory(SharedMethod method, LIRKindTool lirKindTool, SubstrateAArch64RegisterConfig registerConfig) {
            this.method = method;
            this.lirKindTool = lirKindTool;
            this.registerConfig = registerConfig;
        }

        public boolean allowConstantToStackMove(Constant constant) {
            if (constant instanceof SubstrateObjectConstant && this.method.isDeoptTarget()) {
                return false;
            }
            return super.allowConstantToStackMove(constant);
        }

        public AArch64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals(src)) {
                return super.createLoad(dst, (Constant)JavaConstant.INT_0);
            }
            if (src instanceof SubstrateObjectConstant) {
                return this.loadObjectConstant(dst, (SubstrateObjectConstant)src);
            }
            return super.createLoad(dst, src);
        }

        public LIRInstruction createStackLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals(src)) {
                return super.createStackLoad(dst, (Constant)JavaConstant.INT_0);
            }
            if (src instanceof SubstrateObjectConstant) {
                return this.loadObjectConstant(dst, (SubstrateObjectConstant)src);
            }
            return super.createStackLoad(dst, src);
        }

        protected AArch64LIRInstruction loadObjectConstant(AllocatableValue dst, SubstrateObjectConstant constant) {
            if (ReferenceAccess.singleton().haveCompressedReferences()) {
                RegisterValue heapBase = this.registerConfig.getHeapBaseRegister().asValue();
                return new LoadCompressedObjectConstantOp(dst, constant, (AllocatableValue)heapBase, SubstrateAArch64Backend.getCompressEncoding(), this.lirKindTool);
            }
            return new AArch64Move.LoadInlineConstant((JavaConstant)constant, dst);
        }
    }

    static class SubstrateReferenceMapBuilderFactory
    implements FrameMap.ReferenceMapBuilderFactory {
        SubstrateReferenceMapBuilderFactory() {
        }

        public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
            return new SubstrateReferenceMapBuilder(totalFrameSize);
        }
    }

    protected static class DeoptExitStubContext
    extends SubstrateAArch64FrameContext {
        protected DeoptExitStubContext() {
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AArch64MacroAssembler asm = (AArch64MacroAssembler)tasm.asm;
            asm.mov(64, AArch64.sp, AArch64.r0);
            super.enter(tasm);
        }

        @Override
        public void leave(CompilationResultBuilder tasm) {
            AArch64MacroAssembler asm = (AArch64MacroAssembler)tasm.asm;
            super.leave(tasm);
            int scratchOffset = DeoptimizedFrame.getScratchSpaceOffset();
            asm.ldr(64, AArch64.r0, AArch64Address.createUnscaledImmediateAddress((Register)AArch64.r0, (int)scratchOffset));
        }
    }

    protected static class DeoptEntryStubContext
    extends SubstrateAArch64FrameContext {
        protected DeoptEntryStubContext() {
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AArch64MacroAssembler asm = (AArch64MacroAssembler)tasm.asm;
            asm.ldr(64, AArch64.r1, AArch64Address.createUnscaledImmediateAddress((Register)AArch64.sp, (int)0));
            int scratchOffset = DeoptimizedFrame.getScratchSpaceOffset();
            asm.str(64, AArch64.r0, AArch64Address.createUnscaledImmediateAddress((Register)AArch64.r1, (int)scratchOffset));
            asm.mov(64, AArch64.r0, AArch64.r1);
            super.enter(tasm);
        }
    }

    protected static class SubstrateAArch64FrameContext
    implements FrameContext {
        protected SubstrateAArch64FrameContext() {
        }

        public void enter(CompilationResultBuilder crb) {
            FrameMap frameMap = crb.frameMap;
            int frameSize = frameMap.frameSize();
            int totalFrameSize = frameMap.totalFrameSize();
            assert (frameSize + 2 * crb.target.arch.getWordSize() == totalFrameSize) : "total framesize should be framesize + 2 words";
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            crb.blockComment("[method prologue]");
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                int wordSize = crb.target.arch.getWordSize();
                Register rscratch1 = sc.getRegister();
                assert (totalFrameSize > 0);
                if (frameSize < 512) {
                    masm.sub(64, AArch64.sp, AArch64.sp, totalFrameSize);
                    masm.stp(64, AArch64.r29, AArch64.lr, AArch64Address.createScaledImmediateAddress((Register)AArch64.sp, (int)(frameSize / wordSize)));
                } else {
                    masm.stp(64, AArch64.r29, AArch64.lr, AArch64Address.createPreIndexedImmediateAddress((Register)AArch64.sp, (int)-2));
                    if (frameSize < 4096) {
                        masm.sub(64, AArch64.sp, AArch64.sp, totalFrameSize - 2 * wordSize);
                    } else {
                        masm.mov(rscratch1, totalFrameSize - 2 * wordSize);
                        masm.sub(64, AArch64.sp, AArch64.sp, rscratch1);
                    }
                }
            }
            if (((Boolean)GraalOptions.ZapStackOnMethodEntry.getValue(crb.getOptions())).booleanValue()) {
                sc = masm.getScratchRegister();
                var7_7 = null;
                try {
                    Register scratch = sc.getRegister();
                    int longSize = 8;
                    masm.mov(64, scratch, AArch64.sp);
                    AArch64Address address = AArch64Address.createPostIndexedImmediateAddress((Register)scratch, (int)longSize);
                    try (AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
                        Register value = sc2.getRegister();
                        masm.mov(value, 841573668843749358L);
                        for (int i = 0; i < frameSize; i += longSize) {
                            masm.str(64, value, address);
                        }
                    }
                }
                catch (Throwable throwable) {
                    var7_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (sc != null) {
                        if (var7_7 != null) {
                            try {
                                sc.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            sc.close();
                        }
                    }
                }
            }
            crb.recordMark((Object)SubstrateAArch64Backend.MARK_PROLOGUE_DECD_RSP);
            crb.recordMark((Object)SubstrateAArch64Backend.MARK_PROLOGUE_END);
        }

        public void leave(CompilationResultBuilder crb) {
            int frameSize = crb.frameMap.frameSize();
            crb.recordMark((Object)SubstrateAArch64Backend.MARK_EPILOGUE_START);
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            FrameMap frameMap = crb.frameMap;
            int totalFrameSize = frameMap.totalFrameSize();
            crb.blockComment("[method epilogue]");
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                int wordSize = crb.target.arch.getWordSize();
                Register rscratch1 = sc.getRegister();
                assert (totalFrameSize > 0);
                if (frameSize < 512) {
                    masm.ldp(64, AArch64.r29, AArch64.lr, AArch64Address.createScaledImmediateAddress((Register)AArch64.sp, (int)(frameSize / wordSize)));
                    masm.add(64, AArch64.sp, AArch64.sp, totalFrameSize);
                } else {
                    if (frameSize < 4096) {
                        masm.add(64, AArch64.sp, AArch64.sp, totalFrameSize - 2 * wordSize);
                    } else {
                        masm.mov(rscratch1, totalFrameSize - 2 * wordSize);
                        masm.add(64, AArch64.sp, AArch64.sp, rscratch1);
                    }
                    masm.ldp(64, AArch64.r29, AArch64.lr, AArch64Address.createPostIndexedImmediateAddress((Register)AArch64.sp, (int)2));
                }
            }
            if (frameSize != 0) {
                crb.recordMark((Object)SubstrateAArch64Backend.MARK_EPILOGUE_INCD_RSP);
            }
            crb.recordMark((Object)SubstrateAArch64Backend.MARK_EPILOGUE_END);
        }

        public boolean hasFrame() {
            return true;
        }
    }

    public final class SubstrateAArch64NodeLIRBuilder
    extends AArch64NodeLIRBuilder
    implements SubstrateNodeLIRBuilder {
        public SubstrateAArch64NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AArch64NodeMatchRules nodeMatchRules) {
            super(graph, gen, nodeMatchRules);
        }

        public void visitSafepointNode(SafepointNode node) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void visitBreakpointNode(BreakpointNode node) {
            JavaType[] sig = new JavaType[node.arguments().size()];
            for (int i = 0; i < sig.length; ++i) {
                sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
            }
            CallingConvention convention = this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)SubstrateCallingConventionType.JavaCall, null, sig, (ValueKindFactory)this.gen);
            this.append((LIRInstruction)new AArch64BreakpointOp(this.visitInvokeArguments(convention, (Collection)node.arguments())));
        }

        protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
            return new SubstrateDebugInfoBuilder(nodeValueMap, graph.getDebug());
        }

        protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            this.append((LIRInstruction)new SubstrateAArch64DirectCallOp(SubstrateAArch64Backend.this.getRuntimeConfiguration(), targetMethod, result, parameters, temps, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget)));
        }

        protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            Register targetRegister = AArch64.lr;
            RegisterValue targetAddress = targetRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)targetAddress, this.operand((Node)callTarget.computedAddress()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            this.append((LIRInstruction)new SubstrateAArch64IndirectCallOp(SubstrateAArch64Backend.this.getRuntimeConfiguration(), targetMethod, result, parameters, temps, (Value)targetAddress, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget)));
        }

        private AllocatableValue setupJavaFrameAnchor(CallTargetNode callTarget) {
            if (!SubstrateBackend.hasJavaFrameAnchor(callTarget)) {
                return Value.ILLEGAL;
            }
            Register frameAnchorRegister = AArch64.r13;
            RegisterValue frameAnchor = frameAnchorRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)frameAnchor, this.operand((Node)SubstrateBackend.getJavaFrameAnchor(callTarget)));
            return frameAnchor;
        }

        public void emitBranch(LogicNode node, LabelRef trueSuccessor, LabelRef falseSuccessor, double trueSuccessorProbability) {
            if (node instanceof SafepointCheckNode) {
                this.append((LIRInstruction)new AArch64DecrementingSafepointCheckOp());
                this.append((LIRInstruction)new AArch64ControlFlow.BranchOp(AArch64Assembler.ConditionFlag.LE, trueSuccessor, falseSuccessor, trueSuccessorProbability));
            } else {
                super.emitBranch(node, trueSuccessor, falseSuccessor, trueSuccessorProbability);
            }
        }

        @Override
        public void emitCGlobalDataLoadAddress(CGlobalDataLoadAddressNode node) {
            Variable result = this.gen.newVariable((ValueKind)this.gen.getLIRKindTool().getWordKind());
            this.append((LIRInstruction)new AArch64CGlobalDataLoadAddressOp(node.getDataInfo(), (AllocatableValue)result));
            this.setResult((ValueNode)node, (Value)result);
        }

        @Override
        public Variable emitReadReturnAddress() {
            return this.getLIRGeneratorTool().emitMove((Value)StackSlot.get((ValueKind)this.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (int)(-FrameAccess.returnAddressSize() - FrameAccess.wordSize()), (boolean)true));
        }
    }

    public static final class SubstrateDebugInfoBuilder
    extends DebugInfoBuilder {
        public SubstrateDebugInfoBuilder(NodeValueMap nodeValueMap, DebugContext debug) {
            super(nodeValueMap, debug);
        }

        protected JavaKind storageKind(JavaType type) {
            return ((SharedType)type).getStorageKind();
        }
    }

    protected final class SubstrateAArch64LIRGenerator
    extends AArch64LIRGenerator
    implements SubstrateLIRGenerator {
        public SubstrateAArch64LIRGenerator(LIRKindTool lirKindTool, AArch64ArithmeticLIRGenerator arithmeticLIRGen, LIRGeneratorTool.MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
            super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes);
        }

        public SubstrateLIRGenerationResult getResult() {
            return (SubstrateLIRGenerationResult)super.getResult();
        }

        public SubstrateRegisterConfig getRegisterConfig() {
            return (SubstrateRegisterConfig)super.getRegisterConfig();
        }

        protected void emitForeignCallOp(ForeignCallLinkage linkage, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            ResolvedJavaMethod targetMethod = callTarget.getMethod();
            this.append((LIRInstruction)new SubstrateAArch64DirectCallOp(SubstrateAArch64Backend.this.getRuntimeConfiguration(), targetMethod, result, arguments, temps, info, (Value)Value.ILLEGAL));
        }

        public void emitUnwind(Value operand) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
            throw VMError.shouldNotReachHere("Substrate VM does not use deoptimization");
        }

        @Override
        public void emitVerificationMarker(Object marker) {
            this.append(new VerificationMarkerOp(marker));
        }

        @Override
        public void emitFarReturn(AllocatableValue result, Value stackPointer, Value ip) {
            this.append((LIRInstruction)new AArch64FarReturnOp(this.asAllocatable((Value)result), this.asAllocatable(stackPointer), this.asAllocatable(ip)));
        }

        @Override
        public void emitDeadEnd() {
            this.append(new DeadEndOp());
        }

        public void emitPrefetchAllocate(Value address) {
            this.append((LIRInstruction)new AArch64PrefetchOp(this.asAddressValue(address), AArch64Assembler.PrefetchMode.PSTL1KEEP));
        }

        public Value emitCompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getNarrowOopKind());
            boolean nonNull = SubstrateAArch64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AArch64Move.CompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)this.getRegisterConfig().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            assert (((LIRKind)pointer.getValueKind(LIRKind.class)).getPlatformKind() == this.getLIRKindTool().getNarrowOopKind().getPlatformKind());
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getObjectKind());
            boolean nonNull = SubstrateAArch64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AArch64Move.UncompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)this.getRegisterConfig().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public void emitCCall(long address, CallingConvention nativeCallingConvention, Value[] args) {
            throw VMError.unimplemented();
        }

        public StandardOp.ZapRegistersOp createZapRegisters(Register[] zappedRegisters, JavaConstant[] zapValues) {
            throw VMError.unimplemented();
        }

        public LIRInstruction createZapArgumentSpace(StackSlot[] zappedStack, JavaConstant[] zapValues) {
            throw VMError.unimplemented();
        }

        public void emitConvertNullToZero(AllocatableValue result, Value value) {
            if (SubstrateAArch64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AArch64Move.ConvertNullToZeroOp(result, (AllocatableValue)value));
            } else {
                this.emitMove(result, value);
            }
        }

        public void emitConvertZeroToNull(AllocatableValue result, Value value) {
            if (SubstrateAArch64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AArch64Move.ConvertZeroToNullOp(result, (AllocatableValue)value));
            } else {
                this.emitMove(result, value);
            }
        }

        public void emitReturn(JavaKind kind, Value input) {
            AllocatableValue operand = Value.ILLEGAL;
            if (input != null) {
                operand = this.resultOperandFor(kind, input.getValueKind());
                this.emitMove(operand, input);
            }
            this.append((LIRInstruction)new AArch64ControlFlow.ReturnOp((Value)operand));
        }
    }

    protected static final class SubstrateLIRGenerationResult
    extends LIRGenerationResult {
        private final SharedMethod method;

        public SubstrateLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, RegisterAllocationConfig registerAllocationConfig, CallingConvention callingConvention, SharedMethod method) {
            super(compilationId, lir, frameMapBuilder, registerAllocationConfig, callingConvention);
            this.method = method;
            if (method.canDeoptimize() || method.isDeoptTarget()) {
                ((FrameMapBuilderTool)frameMapBuilder).getFrameMap().reserveOutgoing(16);
            }
        }

        public SharedMethod getMethod() {
            return this.method;
        }
    }

    @Opcode(value="DEAD_END")
    public static class DeadEndOp
    extends LIRInstruction
    implements StandardOp.BlockEndOp {
        public static final LIRInstructionClass<DeadEndOp> TYPE = LIRInstructionClass.create(DeadEndOp.class);

        public DeadEndOp() {
            super(TYPE);
        }

        public void emitCode(CompilationResultBuilder crb) {
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static class SubstrateAArch64IndirectCallOp
    extends AArch64Call.IndirectCallOp {
        public static final LIRInstructionClass<SubstrateAArch64IndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAArch64IndirectCallOp.class);
        private final RuntimeConfiguration runtimeConfiguration;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;

        public SubstrateAArch64IndirectCallOp(RuntimeConfiguration runtimeConfiguration, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state, Value javaFrameAnchor) {
            super(TYPE, callTarget, result, parameters, temps, targetAddress, state);
            this.runtimeConfiguration = runtimeConfiguration;
            this.javaFrameAnchor = javaFrameAnchor;
        }

        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            SubstrateAArch64Backend.maybeTransitionToNative(crb, masm, this.runtimeConfiguration, this.javaFrameAnchor, this.state);
            super.emitCode(crb, masm);
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static class SubstrateAArch64DirectCallOp
    extends AArch64Call.DirectCallOp {
        public static final LIRInstructionClass<SubstrateAArch64DirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAArch64DirectCallOp.class);
        private final RuntimeConfiguration runtimeConfiguration;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;

        public SubstrateAArch64DirectCallOp(RuntimeConfiguration runtimeConfiguration, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state, Value javaFrameAnchor) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.runtimeConfiguration = runtimeConfiguration;
            this.javaFrameAnchor = javaFrameAnchor;
        }

        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            SubstrateAArch64Backend.maybeTransitionToNative(crb, masm, this.runtimeConfiguration, this.javaFrameAnchor, this.state);
            AArch64Call.directCall((CompilationResultBuilder)crb, (AArch64MacroAssembler)masm, (InvokeTarget)this.callTarget, null, (LIRFrameState)this.state);
        }
    }
}

