/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Uio;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.AllowNarrowingCast;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

@CContext(value=PosixDirectives.class)
public class Socket {
    @CConstant
    public static native int SOCK_STREAM();

    @CConstant
    public static native int SOCK_DGRAM();

    @CConstant
    public static native int PF_UNIX();

    @CConstant
    public static native int PF_INET();

    @CConstant
    public static native int AF_UNSPEC();

    @CConstant
    @Platforms(value={DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    public static native int AF_LINK();

    @CConstant
    public static native int AF_UNIX();

    @CConstant
    public static native int AF_INET();

    @CConstant
    public static native int AF_INET6();

    @CConstant
    public static native int MSG_DONTWAIT();

    @CConstant
    public static native int SCM_RIGHTS();

    @CConstant
    public static native long SIOCGIFCONF();

    @CConstant
    public static native long SIOCGIFFLAGS();

    @CConstant
    public static native long SIOCGIFBRDADDR();

    @CConstant
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    public static native int SIOCGIFHWADDR();

    @CConstant
    public static native long SIOCGIFNETMASK();

    @CConstant
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    public static native int SIOCGIFINDEX();

    @CConstant
    public static native int SOL_SOCKET();

    @CConstant
    public static native int SO_REUSEADDR();

    @CConstant
    public static native int SO_ERROR();

    @CConstant
    public static native int SO_BROADCAST();

    @CConstant
    public static native int SO_SNDBUF();

    @CConstant
    public static native int SO_RCVBUF();

    @CConstant
    public static native int SO_KEEPALIVE();

    @CConstant
    public static native int SO_OOBINLINE();

    @CConstant
    public static native int SO_LINGER();

    @CConstant
    public static native int SO_REUSEPORT();

    @CFunction
    public static native int socket(int var0, int var1, int var2);

    @CFunction
    public static native int socketpair(int var0, int var1, int var2, CIntPointer var3);

    @CFunction
    public static native int bind(int var0, sockaddr var1, int var2);

    @CFunction
    public static native int getsockname(int var0, sockaddr var1, CIntPointer var2);

    @CFunction
    public static native int connect(int var0, sockaddr var1, int var2);

    @CFunction
    public static native SignedWord send(int var0, PointerBase var1, UnsignedWord var2, int var3);

    @CFunction
    public static native SignedWord recv(int var0, PointerBase var1, UnsignedWord var2, int var3);

    @CFunction
    public static native SignedWord sendto(int var0, PointerBase var1, UnsignedWord var2, int var3, sockaddr var4, int var5);

    @CFunction
    public static native SignedWord recvfrom(int var0, PointerBase var1, UnsignedWord var2, int var3, sockaddr var4, CIntPointer var5);

    @CFunction
    public static native int getsockopt(int var0, int var1, int var2, PointerBase var3, CIntPointer var4);

    @CFunction
    public static native int setsockopt(int var0, int var1, int var2, PointerBase var3, int var4);

    @CFunction
    public static native int listen(int var0, int var1);

    @CFunction
    public static native int accept(int var0, sockaddr var1, CIntPointer var2);

    @CFunction
    public static native int shutdown(int var0, int var1);

    @CStruct(addStructKeyword=true)
    public static interface linger
    extends PointerBase {
        @CField
        public int l_onoff();

        @CField
        public void set_l_onoff(int var1);

        @CField
        public int l_linger();

        @CField
        public void set_l_linger(int var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface cmsghdr
    extends PointerBase {
        @CField
        @AllowWideningCast
        public long cmsg_len();

        @CField
        @AllowNarrowingCast
        public void cmsg_len(long var1);

        @CField
        public int cmsg_level();

        @CField
        public void cmsg_level(int var1);

        @CField
        public int cmsg_type();

        @CField
        public void cmsg_type(int var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface msghdr
    extends PointerBase {
        @CField
        public PointerBase msg_name();

        @CField
        public void msg_name(PointerBase var1);

        @CField
        @AllowWideningCast
        public long msg_namelen();

        @CField
        @AllowNarrowingCast
        public void msg_namelen(long var1);

        @CField
        public Uio.iovec msg_iov();

        @CField
        public void msg_iov(Uio.iovec var1);

        @CField
        @AllowWideningCast
        public long msg_iovlen();

        @CField
        @AllowNarrowingCast
        public void msg_iovlen(long var1);

        @CField
        public PointerBase msg_control();

        @CField
        public void msg_control(PointerBase var1);

        @CField
        @AllowWideningCast
        public long msg_controllen();

        @CField
        @AllowNarrowingCast
        public void msg_controllen(long var1);

        @CField
        public int msg_flags();

        @CField
        public void msg_flags(int var1);
    }

    @CPointerTo(value=sockaddr.class)
    public static interface sockaddrPointer
    extends PointerBase {
        public sockaddr read();

        public void write(sockaddr var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface sockaddr
    extends PointerBase {
        @Platforms(value={DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
        @CField
        @AllowWideningCast
        public int sa_len();

        @CField
        @AllowWideningCast
        public int sa_family();

        @CFieldAddress
        public CCharPointer sa_data();
    }
}

