/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.PosixInterruptSignalUtils;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_jni;
import com.oracle.svm.core.posix.Target_os;
import com.oracle.svm.core.posix.VmPrimsJNI;
import com.oracle.svm.core.posix.darwin.DarwinCoreFoundationUtils;
import com.oracle.svm.core.posix.headers.Dirent;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Grp;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Limits;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Poll;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Pwd;
import com.oracle.svm.core.posix.headers.Resource;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Stat;
import com.oracle.svm.core.posix.headers.Statvfs;
import com.oracle.svm.core.posix.headers.Stdio;
import com.oracle.svm.core.posix.headers.Stdlib;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.Uio;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.CoreFoundation;
import com.oracle.svm.core.posix.headers.darwin.DarwinSendfile;
import com.oracle.svm.core.posix.headers.linux.LinuxSendfile;
import com.oracle.svm.core.posix.headers.linux.Mntent;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.spi.FileSystemProvider;
import java.util.function.Predicate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
public final class PosixJavaNIOSubstitutions {
    protected static int handle(int rv, String msg) throws IOException {
        if (rv >= 0) {
            return rv;
        }
        if (Errno.errno() == Errno.EINTR()) {
            return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
        }
        throw PosixUtils.newIOExceptionWithLastError(msg);
    }

    protected static long handle(long rv, String msg) throws IOException {
        if (rv >= 0L) {
            return rv;
        }
        if (Errno.errno() == Errno.EINTR()) {
            return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
        }
        throw PosixUtils.newIOExceptionWithLastError(msg);
    }

    public static int convertReturnVal(WordBase n, boolean reading) throws IOException {
        return PosixJavaNIOSubstitutions.convertReturnVal((int)n.rawValue(), reading);
    }

    protected static int convertReturnVal(int n, boolean reading) throws IOException {
        if (n > 0) {
            return n;
        }
        if (n == 0) {
            if (reading) {
                return Target_sun_nio_ch_IOStatus.IOS_EOF;
            }
            return 0;
        }
        if (Errno.errno() == Errno.EAGAIN()) {
            return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
        }
        if (Errno.errno() == Errno.EINTR()) {
            return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
        }
        String msg = reading ? "Read failed" : "Write failed";
        throw PosixUtils.newIOExceptionWithLastError(msg);
    }

    protected static long convertLongReturnVal(WordBase n, boolean reading) throws IOException {
        return PosixJavaNIOSubstitutions.convertLongReturnVal(n.rawValue(), reading);
    }

    protected static long convertLongReturnVal(long n, boolean reading) throws IOException {
        if (n > 0L) {
            return n;
        }
        if (n == 0L) {
            if (reading) {
                return Target_sun_nio_ch_IOStatus.IOS_EOF;
            }
            return 0L;
        }
        if (Errno.errno() == Errno.EAGAIN()) {
            return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
        }
        if (Errno.errno() == Errno.EINTR()) {
            return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
        }
        String msg = reading ? "Read failed" : "Write failed";
        throw PosixUtils.newIOExceptionWithLastError(msg);
    }

    protected static int fdval(FileDescriptor fdo) {
        return PosixUtils.getFD(fdo);
    }

    protected static <T extends PointerBase> T dlsym(PointerBase handle, String name) {
        try (CTypeConversion.CCharPointerHolder namePin = CTypeConversion.toCString((CharSequence)name);){
            CCharPointer namePtr = namePin.get();
            Object t = Dlfcn.dlsym(handle, namePtr);
            return t;
        }
    }

    private static Exception throwUnixException(int errnum) throws Exception {
        throw SubstrateUtil.cast(new Target_sun_nio_fs_UnixException(errnum), Exception.class);
    }

    private static OutOfMemoryError throwOutOfMemoryError(String msg) {
        throw new OutOfMemoryError(msg);
    }

    private static InternalError throwInternalError(String msg) {
        throw new InternalError(msg);
    }

    protected static byte[] toByteArray(CCharPointer cstr) {
        UnsignedWord len = SubstrateUtil.strlen(cstr);
        byte[] result = new byte[(int)len.rawValue()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = cstr.read(i);
        }
        return result;
    }

    @TargetClass(className="sun.nio.ch.DatagramChannelImpl")
    @Platforms(value={DeprecatedPlatform.DARWIN_SUBSTITUTION.class, DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_DatagramChannelImpl {
        @Alias
        private InetAddress cachedSenderInetAddress;
        @Alias
        private int cachedSenderPort;
        @Alias
        private SocketAddress sender;

        Target_sun_nio_ch_DatagramChannelImpl() {
        }

        @Substitute
        private static void initIDs() {
        }

        @Substitute
        private static void disconnect0(FileDescriptor fdo, boolean isIPv6) throws IOException {
            int fd = PosixUtils.getFD(fdo);
            int rv = 0;
            if (IsDefined.__solaris__()) {
                rv = Socket.connect(fd, (Socket.sockaddr)WordFactory.nullPointer(), 0);
            }
            if (IsDefined.__linux__() || IsDefined._ALLBSD_SOURCE() || IsDefined._AIX()) {
                int len;
                Socket.sockaddr sa = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
                LibC.memset(sa, WordFactory.signed((int)0), WordFactory.unsigned((int)JavaNetNetUtilMD.SOCKADDR_LEN()));
                if (IsDefined.socket_AF_INET6()) {
                    if (isIPv6) {
                        NetinetIn.sockaddr_in6 him6 = (NetinetIn.sockaddr_in6)((Object)sa);
                        if (IsDefined._ALLBSD_SOURCE()) {
                            him6.set_sin6_family(Socket.AF_INET6());
                        } else {
                            him6.set_sin6_family(Socket.AF_UNSPEC());
                        }
                        len = SizeOf.get(NetinetIn.sockaddr_in6.class);
                    } else {
                        NetinetIn.sockaddr_in him4 = (NetinetIn.sockaddr_in)((Object)sa);
                        if (IsDefined._ALLBSD_SOURCE()) {
                            him4.set_sin_family(Socket.AF_INET());
                        } else {
                            him4.set_sin_family(Socket.AF_UNSPEC());
                        }
                        len = SizeOf.get(NetinetIn.sockaddr_in.class);
                    }
                } else {
                    NetinetIn.sockaddr_in him4 = (NetinetIn.sockaddr_in)StackValue.get(NetinetIn.sockaddr_in.class);
                    LibC.memset(him4, WordFactory.signed((int)0), SizeOf.unsigned(NetinetIn.sockaddr_in.class));
                    if (IsDefined._ALLBSD_SOURCE()) {
                        him4.set_sin_family(Socket.AF_INET());
                    } else {
                        him4.set_sin_family(Socket.AF_UNSPEC());
                    }
                    len = SizeOf.get(NetinetIn.sockaddr_in.class);
                }
                rv = Socket.connect(fd, sa, len);
                if (IsDefined._ALLBSD_SOURCE() && rv < 0 && Errno.errno() == Errno.EADDRNOTAVAIL()) {
                    Errno.set_errno(0);
                    rv = 0;
                }
                if (IsDefined._AIX() && rv < 0 && Errno.errno() == Errno.EAFNOSUPPORT()) {
                    Errno.set_errno(0);
                    rv = 0;
                }
            }
            if (rv < 0) {
                Util_sun_nio_ch_Net.handleSocketError(rv);
            }
        }

        @Substitute
        private int receive0(FileDescriptor fdo, long address, int lenIn, boolean connected) throws IOException {
            int n;
            boolean retry;
            int len = lenIn;
            int fd = PosixUtils.getFD(fdo);
            PointerBase buf = WordFactory.pointer((long)address);
            Socket.sockaddr sa = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer sa_len = (CIntPointer)StackValue.get(CIntPointer.class);
            sa_len.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            if (len > JavaNetNetUtil.MAX_PACKET_LEN()) {
                len = JavaNetNetUtil.MAX_PACKET_LEN();
            }
            do {
                retry = false;
                n = (int)Socket.recvfrom(fd, buf, WordFactory.unsigned((int)len), 0, sa, sa_len).rawValue();
                if (n >= 0) continue;
                if (Errno.errno() == Errno.EWOULDBLOCK() || Errno.errno() == Errno.EAGAIN()) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
                }
                if (Errno.errno() == Errno.EINTR()) {
                    return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
                }
                if (Errno.errno() == Errno.ECONNREFUSED()) {
                    if (!connected) {
                        retry = true;
                        continue;
                    }
                    throw new PortUnreachableException();
                }
                return Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
            } while (retry);
            InetAddress senderAddr = this.cachedSenderInetAddress;
            if (senderAddr != null) {
                if (!JavaNetNetUtil.NET_SockaddrEqualsInetAddress(sa, senderAddr)) {
                    senderAddr = null;
                } else {
                    int port = this.cachedSenderPort;
                    if (port != JavaNetNetUtilMD.NET_GetPortFromSockaddr(sa)) {
                        senderAddr = null;
                    }
                }
            }
            if (senderAddr == null) {
                InetSocketAddress isa = null;
                CIntPointer port = (CIntPointer)StackValue.get(CIntPointer.class);
                port.write(0);
                InetAddress ia = JavaNetNetUtil.NET_SockaddrToInetAddress(sa, port);
                if (ia != null) {
                    isa = new InetSocketAddress(ia, port.read());
                }
                if (isa == null) {
                    return Target_sun_nio_ch_IOStatus.IOS_THROWN;
                }
                this.cachedSenderInetAddress = ia;
                this.cachedSenderPort = JavaNetNetUtilMD.NET_GetPortFromSockaddr(sa);
                this.sender = isa;
            }
            return n;
        }

        @Substitute
        private int send0(boolean preferIPv6, FileDescriptor fdo, long address, int lenIn, InetAddress destAddress, int destPort) throws IOException {
            int len = lenIn;
            int fd = PosixUtils.getFD(fdo);
            PointerBase buf = WordFactory.pointer((long)address);
            Socket.sockaddr sa = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer sa_len = (CIntPointer)StackValue.get(CIntPointer.class);
            sa_len.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            if (len > JavaNetNetUtil.MAX_PACKET_LEN()) {
                len = JavaNetNetUtil.MAX_PACKET_LEN();
            }
            if (JavaNetNetUtilMD.NET_InetAddressToSockaddr(destAddress, destPort, sa, sa_len, preferIPv6) != 0) {
                return Target_sun_nio_ch_IOStatus.IOS_THROWN;
            }
            int n = (int)Socket.sendto(fd, buf, WordFactory.unsigned((int)len), 0, sa, sa_len.read()).rawValue();
            if (n < 0) {
                if (Errno.errno() == Errno.EWOULDBLOCK() || Errno.errno() == Errno.EAGAIN()) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
                }
                if (Errno.errno() == Errno.EINTR()) {
                    return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
                }
                if (Errno.errno() == Errno.ECONNREFUSED()) {
                    throw new PortUnreachableException();
                }
                return Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
            }
            return n;
        }
    }

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    static class Util_sun_nio_fs_MagicFileTypeDetector {
        static final int MAGIC_MIME_TYPE = 16;
        static magic_open_func magic_open;
        static magic_load_func magic_load;
        static magic_file_func magic_file;
        static magic_close_func magic_close;

        Util_sun_nio_fs_MagicFileTypeDetector() {
        }

        static interface magic_close_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public void invoke(magic_t var1);
        }

        static interface magic_file_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public CCharPointer invoke(magic_t var1, CCharPointer var2);
        }

        static interface magic_load_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public int invoke(magic_t var1, CCharPointer var2);
        }

        static interface magic_open_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public magic_t invoke(int var1);
        }

        static interface magic_t
        extends PointerBase {
        }
    }

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    @TargetClass(className="sun.nio.fs.MagicFileTypeDetector", onlyWith={JDK8OrEarlier.class})
    static final class Target_sun_nio_fs_MagicFileTypeDetector {
        @Alias
        @InjectAccessors(value=LibmagicAvailableInjector.class)
        boolean libmagicAvailable;
        @Inject
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        Boolean injectedLibmagicAvailable;

        Target_sun_nio_fs_MagicFileTypeDetector() {
        }

        @Substitute
        static boolean initialize0() {
            Throwable throwable;
            WordPointer magicHandle;
            Log trace;
            block79: {
                trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_MagicFileTypeDetector.initialize0:").newline();
                magicHandle = (WordPointer)WordFactory.nullPointer();
                throwable = null;
                try (CTypeConversion.CCharPointerHolder libmagicsoHolder = CTypeConversion.toCString((CharSequence)"libmagic.so");){
                    magicHandle = (WordPointer)Dlfcn.dlopen(libmagicsoHolder.get(), Dlfcn.RTLD_LAZY());
                    if (!magicHandle.isNull()) break block79;
                    try (CTypeConversion.CCharPointerHolder libmagicso1Holder = CTypeConversion.toCString((CharSequence)"libmagic.so.1");){
                        magicHandle = (WordPointer)Dlfcn.dlopen(libmagicso1Holder.get(), Dlfcn.RTLD_LAZY());
                        if (magicHandle.isNull()) {
                            trace.string("  libmagic.so not found: returns false]").newline();
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder magicopenHolder = CTypeConversion.toCString((CharSequence)"magic_open");){
                Util_sun_nio_fs_MagicFileTypeDetector.magic_open = (Util_sun_nio_fs_MagicFileTypeDetector.magic_open_func)Dlfcn.dlsym((PointerBase)magicHandle, magicopenHolder.get());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder magicloadHolder = CTypeConversion.toCString((CharSequence)"magic_load");){
                Util_sun_nio_fs_MagicFileTypeDetector.magic_load = (Util_sun_nio_fs_MagicFileTypeDetector.magic_load_func)Dlfcn.dlsym((PointerBase)magicHandle, magicloadHolder.get());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder magicfileHolder = CTypeConversion.toCString((CharSequence)"magic_file");){
                Util_sun_nio_fs_MagicFileTypeDetector.magic_file = (Util_sun_nio_fs_MagicFileTypeDetector.magic_file_func)Dlfcn.dlsym((PointerBase)magicHandle, magicfileHolder.get());
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder magiccloseHolder = CTypeConversion.toCString((CharSequence)"magic_close");){
                Util_sun_nio_fs_MagicFileTypeDetector.magic_close = (Util_sun_nio_fs_MagicFileTypeDetector.magic_close_func)Dlfcn.dlsym((PointerBase)magicHandle, magiccloseHolder.get());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            if (Util_sun_nio_fs_MagicFileTypeDetector.magic_open.isNull() || Util_sun_nio_fs_MagicFileTypeDetector.magic_load.isNull() || Util_sun_nio_fs_MagicFileTypeDetector.magic_file.isNull() || Util_sun_nio_fs_MagicFileTypeDetector.magic_close.isNull()) {
                Dlfcn.dlclose((PointerBase)magicHandle);
                trace.string("  symbols not available: returns false]").newline();
                return false;
            }
            trace.string("  returns true]").newline();
            return true;
        }

        @Substitute
        static byte[] probe0(long pathAddress) {
            Log trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_MagicFileTypeDetector.probe0:").newline();
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            trace.string("  path: ").string(path).newline();
            Util_sun_nio_fs_MagicFileTypeDetector.magic_t cookie = (Util_sun_nio_fs_MagicFileTypeDetector.magic_t)WordFactory.nullPointer();
            byte[] result = null;
            cookie = Util_sun_nio_fs_MagicFileTypeDetector.magic_open.invoke(16);
            if (cookie.isNonNull()) {
                CCharPointer type;
                if (Util_sun_nio_fs_MagicFileTypeDetector.magic_load.invoke(cookie, (CCharPointer)WordFactory.nullPointer()) != -1 && (type = Util_sun_nio_fs_MagicFileTypeDetector.magic_file.invoke(cookie, path)).isNonNull()) {
                    int len = (int)SubstrateUtil.strlen(type).rawValue();
                    result = new byte[len];
                    VmPrimsJNI.SetByteArrayRegion(result, 0, len, type);
                }
                Util_sun_nio_fs_MagicFileTypeDetector.magic_close.invoke(cookie);
            }
            trace.string("  returns  result: ").object(result).string("]").newline();
            return result;
        }

        static final class LibmagicAvailableInjector {
            LibmagicAvailableInjector() {
            }

            static boolean getLibmagicAvailable(Target_sun_nio_fs_MagicFileTypeDetector that) {
                Log trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_MagicFileTypeDetector.LibmagicAvailableInjector.getLibmagicAvailable:").newline();
                if (that.injectedLibmagicAvailable == null) {
                    trace.string(" injectedLibmagicAvailable: null").newline();
                    that.injectedLibmagicAvailable = Target_sun_nio_fs_MagicFileTypeDetector.initialize0() ? Boolean.TRUE : Boolean.FALSE;
                }
                boolean result = that.injectedLibmagicAvailable;
                trace.string(" returns: ").bool(result).string("]").newline();
                return result;
            }
        }
    }

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    static final class Util_sun_nio_fs_GnomeFileTypeDetector {
        static final String G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE = "standard::content-type";
        static final int G_FILE_QUERY_INFO_NONE = 0;
        static g_type_init_func g_type_init;
        static g_object_unref_func g_object_unref;
        static g_file_new_for_path_func g_file_new_for_path;
        static g_file_query_info_func g_file_query_info;
        static g_file_info_get_content_type_func g_file_info_get_content_type;
        static gnome_vfs_init_function gnome_vfs_init;
        static gnome_vfs_mime_type_from_name_function gnome_vfs_mime_type_from_name;

        Util_sun_nio_fs_GnomeFileTypeDetector() {
        }

        static interface gnome_vfs_mime_type_from_name_function
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public CCharPointer invoke(CCharPointer var1);
        }

        static interface gnome_vfs_init_function
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public int invoke();
        }

        static interface g_file_info_get_content_type_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public CCharPointer invoke(GFileInfo var1);
        }

        static interface g_file_query_info_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public GFileInfo invoke(GFile var1, CCharPointer var2, int var3, GCancellable var4, GErrorPointer var5);
        }

        static interface g_file_new_for_path_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public GFile invoke(CCharPointer var1);
        }

        static interface g_object_unref_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public void invoke(gpointer var1);
        }

        static interface g_type_init_func
        extends CFunctionPointer {
            @InvokeCFunctionPointer
            public void invoke();
        }

        static interface GErrorPointer
        extends PointerBase {
        }

        static interface GCancellable
        extends PointerBase {
        }

        static interface GFileInfo
        extends PointerBase {
        }

        static interface GFile
        extends PointerBase {
        }

        static interface gpointer
        extends PointerBase {
        }
    }

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    @TargetClass(className="sun.nio.fs.GnomeFileTypeDetector", onlyWith={JDK8OrEarlier.class})
    static final class Target_sun_nio_fs_GnomeFileTypeDetector {
        @Alias
        @InjectAccessors(value=GioAvailableInjector.class)
        boolean gioAvailable;
        @Inject
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        Boolean injectedGioAvailable;
        @Alias
        @InjectAccessors(value=GnomeVfsAvailableInjector.class)
        boolean gnomeVfsAvailable;
        @Inject
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        Boolean injectedGnomeVfsAvailable;

        Target_sun_nio_fs_GnomeFileTypeDetector() {
        }

        @Substitute
        static boolean initializeGio() {
            Throwable throwable;
            WordPointer gio_handle;
            Log trace;
            block91: {
                trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_GnomeFileTypeDetector.initializeGio:").newline();
                gio_handle = (WordPointer)WordFactory.nullPointer();
                throwable = null;
                try (CTypeConversion.CCharPointerHolder libgio_2_0_so_Holder = CTypeConversion.toCString((CharSequence)"libgio-2.0.so");){
                    gio_handle = (WordPointer)Dlfcn.dlopen(libgio_2_0_so_Holder.get(), Dlfcn.RTLD_LAZY());
                    if (!gio_handle.isNull()) break block91;
                    try (CTypeConversion.CCharPointerHolder libgio_2_0_so_0_Holder = CTypeConversion.toCString((CharSequence)"libgio-2.0.so.0");){
                        gio_handle = (WordPointer)Dlfcn.dlopen(libgio_2_0_so_0_Holder.get(), Dlfcn.RTLD_LAZY());
                        if (gio_handle.isNull()) {
                            trace.string("  libgio not found: returns false]").newline();
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder g_type_init_Holder = CTypeConversion.toCString((CharSequence)"g_type_init");){
                Util_sun_nio_fs_GnomeFileTypeDetector.g_type_init = (Util_sun_nio_fs_GnomeFileTypeDetector.g_type_init_func)Dlfcn.dlsym((PointerBase)gio_handle, g_type_init_Holder.get());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            Util_sun_nio_fs_GnomeFileTypeDetector.g_type_init.invoke();
            throwable = null;
            try (CTypeConversion.CCharPointerHolder g_object_unref_Holder = CTypeConversion.toCString((CharSequence)"g_object_unref");){
                Util_sun_nio_fs_GnomeFileTypeDetector.g_object_unref = (Util_sun_nio_fs_GnomeFileTypeDetector.g_object_unref_func)Dlfcn.dlsym((PointerBase)gio_handle, g_object_unref_Holder.get());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder g_file_new_for_path_Holder = CTypeConversion.toCString((CharSequence)"g_file_new_for_path");){
                Util_sun_nio_fs_GnomeFileTypeDetector.g_file_new_for_path = (Util_sun_nio_fs_GnomeFileTypeDetector.g_file_new_for_path_func)Dlfcn.dlsym((PointerBase)gio_handle, g_file_new_for_path_Holder.get());
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder g_file_query_info_Holder = CTypeConversion.toCString((CharSequence)"g_file_query_info");){
                Util_sun_nio_fs_GnomeFileTypeDetector.g_file_query_info = (Util_sun_nio_fs_GnomeFileTypeDetector.g_file_query_info_func)Dlfcn.dlsym((PointerBase)gio_handle, g_file_query_info_Holder.get());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder g_file_info_get_content_type_Holder = CTypeConversion.toCString((CharSequence)"g_file_info_get_content_type");){
                Util_sun_nio_fs_GnomeFileTypeDetector.g_file_info_get_content_type = (Util_sun_nio_fs_GnomeFileTypeDetector.g_file_info_get_content_type_func)Dlfcn.dlsym((PointerBase)gio_handle, g_file_info_get_content_type_Holder.get());
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            if (Util_sun_nio_fs_GnomeFileTypeDetector.g_type_init.isNull() || Util_sun_nio_fs_GnomeFileTypeDetector.g_object_unref.isNull() || Util_sun_nio_fs_GnomeFileTypeDetector.g_file_new_for_path.isNull() || Util_sun_nio_fs_GnomeFileTypeDetector.g_file_query_info.isNull() || Util_sun_nio_fs_GnomeFileTypeDetector.g_file_info_get_content_type.isNull()) {
                Dlfcn.dlclose((PointerBase)gio_handle);
                trace.string("  symbols not found: returns false]").newline();
                return false;
            }
            Util_sun_nio_fs_GnomeFileTypeDetector.g_type_init.invoke();
            trace.string("  returns true]").newline();
            return true;
        }

        @Substitute
        static byte[] probeUsingGio(long pathAddress) {
            Log trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_GnomeFileTypeDetector.probeUsingGio:").newline();
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            trace.string("  pathAddress: ").string(path);
            Util_sun_nio_fs_GnomeFileTypeDetector.GFile gfile = (Util_sun_nio_fs_GnomeFileTypeDetector.GFile)WordFactory.nullPointer();
            Util_sun_nio_fs_GnomeFileTypeDetector.GFileInfo gfileinfo = (Util_sun_nio_fs_GnomeFileTypeDetector.GFileInfo)WordFactory.nullPointer();
            byte[] result = null;
            gfile = Util_sun_nio_fs_GnomeFileTypeDetector.g_file_new_for_path.invoke(path);
            try (CTypeConversion.CCharPointerHolder gfasctHolder = CTypeConversion.toCString((CharSequence)"standard::content-type");){
                gfileinfo = Util_sun_nio_fs_GnomeFileTypeDetector.g_file_query_info.invoke(gfile, gfasctHolder.get(), 0, (Util_sun_nio_fs_GnomeFileTypeDetector.GCancellable)WordFactory.nullPointer(), (Util_sun_nio_fs_GnomeFileTypeDetector.GErrorPointer)WordFactory.nullPointer());
            }
            if (gfileinfo.isNonNull()) {
                CCharPointer mime = Util_sun_nio_fs_GnomeFileTypeDetector.g_file_info_get_content_type.invoke(gfileinfo);
                if (mime.isNonNull()) {
                    int len = (int)SubstrateUtil.strlen(mime).rawValue();
                    result = new byte[len];
                    VmPrimsJNI.SetByteArrayRegion(result, 0, len, mime);
                }
                Util_sun_nio_fs_GnomeFileTypeDetector.g_object_unref.invoke((Util_sun_nio_fs_GnomeFileTypeDetector.gpointer)((Object)gfileinfo));
            }
            Util_sun_nio_fs_GnomeFileTypeDetector.g_object_unref.invoke((Util_sun_nio_fs_GnomeFileTypeDetector.gpointer)((Object)gfile));
            trace.string("  returns:  result: ").object(result).string("]").newline();
            return result;
        }

        @Substitute
        static boolean initializeGnomeVfs() {
            WordPointer vfs_handle;
            Throwable throwable;
            Log trace;
            block50: {
                trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_GnomeFileTypeDetector.initializeGnomeVfs:").newline();
                throwable = null;
                try (CTypeConversion.CCharPointerHolder libgnomevfs_2_so_Holder = CTypeConversion.toCString((CharSequence)"libgnomevfs-2.so");){
                    vfs_handle = (WordPointer)Dlfcn.dlopen(libgnomevfs_2_so_Holder.get(), Dlfcn.RTLD_LAZY());
                    if (!vfs_handle.isNull()) break block50;
                    try (CTypeConversion.CCharPointerHolder libgnomevfs_2_so_0_Holder = CTypeConversion.toCString((CharSequence)"libgnomevfs-2.so.0");){
                        vfs_handle = (WordPointer)Dlfcn.dlopen(libgnomevfs_2_so_0_Holder.get(), Dlfcn.RTLD_LAZY());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            if (vfs_handle.isNull()) {
                trace.string("  library not found: returns false]").newline();
                return false;
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder gnome_vfs_init_Holder = CTypeConversion.toCString((CharSequence)"gnome_vfs_init");){
                Util_sun_nio_fs_GnomeFileTypeDetector.gnome_vfs_init = (Util_sun_nio_fs_GnomeFileTypeDetector.gnome_vfs_init_function)Dlfcn.dlsym((PointerBase)vfs_handle, gnome_vfs_init_Holder.get());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            throwable = null;
            try (CTypeConversion.CCharPointerHolder gnome_vfs_mime_type_from_name_Holder = CTypeConversion.toCString((CharSequence)"gnome_vfs_mime_type_from_name");){
                Util_sun_nio_fs_GnomeFileTypeDetector.gnome_vfs_mime_type_from_name = (Util_sun_nio_fs_GnomeFileTypeDetector.gnome_vfs_mime_type_from_name_function)Dlfcn.dlsym((PointerBase)vfs_handle, gnome_vfs_mime_type_from_name_Holder.get());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            if (Util_sun_nio_fs_GnomeFileTypeDetector.gnome_vfs_init.isNull() || Util_sun_nio_fs_GnomeFileTypeDetector.gnome_vfs_mime_type_from_name.isNull()) {
                Dlfcn.dlclose((PointerBase)vfs_handle);
                trace.string("  symbols not found: returns false]").newline();
                return false;
            }
            Util_sun_nio_fs_GnomeFileTypeDetector.gnome_vfs_init.invoke();
            trace.string("  returns true]").newline();
            return true;
        }

        @Substitute
        static byte[] probeUsingGnomeVfs(long pathAddress) {
            Log trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_GnomeFileTypeDetector.probeUsingGnomeVfs:").newline();
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            trace.string("  path: ").string(path).newline();
            CCharPointer mime = Util_sun_nio_fs_GnomeFileTypeDetector.gnome_vfs_mime_type_from_name.invoke(path);
            if (mime.isNull()) {
                trace.string("  mime.isNull: returns null]").newline();
                return null;
            }
            int len = (int)SubstrateUtil.strlen(mime).rawValue();
            byte[] result = new byte[len];
            VmPrimsJNI.SetByteArrayRegion(result, 0, len, mime);
            trace.string("  returns:  result: ").object(result).string("]").newline();
            return result;
        }

        static final class GnomeVfsAvailableInjector {
            GnomeVfsAvailableInjector() {
            }

            static boolean getGnomeVfsAvailable(Target_sun_nio_fs_GnomeFileTypeDetector that) {
                Log trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_GnomeFileTypeDetector.GnomeVfsAvailableInjector.getGnomeVfsAvailable:").newline();
                if (that.injectedGnomeVfsAvailable == null) {
                    trace.string("  injectedGnomeVfsAvailable: null").newline();
                    that.injectedGnomeVfsAvailable = Target_sun_nio_fs_GnomeFileTypeDetector.initializeGnomeVfs() ? Boolean.TRUE : Boolean.FALSE;
                }
                boolean result = that.injectedGnomeVfsAvailable;
                trace.string("  returns: ").bool(result).string("]").newline();
                return result;
            }
        }

        static final class GioAvailableInjector {
            GioAvailableInjector() {
            }

            static boolean getGioAvailable(Target_sun_nio_fs_GnomeFileTypeDetector that) {
                Log trace = Log.noopLog().string("[PosixJavaNIOSubstitutions.Target_sun_nio_fs_GnomeFileTypeDetector.GioAvailableInjector.getGioAvailable:").newline();
                if (that.injectedGioAvailable == null) {
                    trace.string("  injectedGioAvailable: null").newline();
                    that.injectedGioAvailable = Target_sun_nio_fs_GnomeFileTypeDetector.initializeGio() ? Boolean.TRUE : Boolean.FALSE;
                }
                boolean result = that.injectedGioAvailable;
                trace.string("  returns: ").bool(result).string("]").newline();
                return result;
            }
        }
    }

    @TargetClass(value=FileSystems.class)
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_java_nio_file_FileSystems {
        Target_java_nio_file_FileSystems() {
        }

        @Substitute
        static FileSystem getDefault() {
            if (Util_Target_java_nio_file_FileSystems.defaultFilesystem == null) {
                String userDir = System.getProperty("user.dir");
                Target_sun_nio_fs_UnixFileSystemProvider provider = (Target_sun_nio_fs_UnixFileSystemProvider)Target_sun_nio_fs_UnixFileSystemProvider.class.cast(Util_Target_java_nio_file_FileSystems.defaultProvider);
                Util_Target_java_nio_file_FileSystems.defaultFilesystem = provider.newFileSystem(userDir);
            }
            return (FileSystem)FileSystem.class.cast(Util_Target_java_nio_file_FileSystems.defaultFilesystem);
        }

        @Delete
        @TargetClass(value=FileSystems.class, innerClass={"DefaultFileSystemHolder"})
        static final class Target_java_nio_file_FileSystems_DefaultFileSystemHolder {
            Target_java_nio_file_FileSystems_DefaultFileSystemHolder() {
            }
        }
    }

    static final class Util_Target_java_nio_file_FileSystems {
        static FileSystemProvider defaultProvider = FileSystems.getDefault().provider();
        static Target_sun_nio_fs_UnixFileSystem defaultFilesystem;

        Util_Target_java_nio_file_FileSystems() {
        }
    }

    @TargetClass(className="sun.nio.fs.UnixFileSystemProvider")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_UnixFileSystemProvider {
        Target_sun_nio_fs_UnixFileSystemProvider() {
        }

        @Alias
        native Target_sun_nio_fs_UnixFileSystem newFileSystem(String var1);
    }

    @TargetClass(className="sun.nio.fs.UnixFileSystem")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_UnixFileSystem {
        Target_sun_nio_fs_UnixFileSystem() {
        }
    }

    @TargetClass(className="sun.nio.ch.UnixAsynchronousServerSocketChannelImpl")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_UnixAsynchronousServerSocketChannelImpl {
        Target_sun_nio_ch_UnixAsynchronousServerSocketChannelImpl() {
        }

        @TargetElement(onlyWith={JDK11OrEarlier.class})
        @Substitute
        int accept0(FileDescriptor ssfd, FileDescriptor newfd, InetSocketAddress[] isaa) throws IOException {
            return Util_sun_nio_ch_ServerSocketChannelImpl.accept0(ssfd, newfd, isaa);
        }
    }

    @TargetClass(className="sun.nio.ch.UnixAsynchronousSocketChannelImpl")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_UnixAsynchronousSocketChannelImpl {
        Target_sun_nio_ch_UnixAsynchronousSocketChannelImpl() {
        }

        @Substitute
        static void checkConnect(int fd) throws IOException {
            CIntPointer errorPointer = (CIntPointer)StackValue.get(CIntPointer.class);
            errorPointer.write(0);
            CIntPointer arglenPointer = (CIntPointer)StackValue.get(CIntPointer.class);
            arglenPointer.write(SizeOf.get(CIntPointer.class));
            int result = Socket.getsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_ERROR(), (PointerBase)errorPointer, arglenPointer);
            if (result < 0) {
                throw PosixUtils.newIOExceptionWithLastError("getsockopt");
            }
            if (CTypeConversion.toBoolean((int)errorPointer.read())) {
                Util_sun_nio_ch_Net.handleSocketError(errorPointer.read());
            }
        }
    }

    @TargetClass(className="sun.nio.ch.SocketChannelImpl")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_SocketChannelImpl {
        Target_sun_nio_ch_SocketChannelImpl() {
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static int checkConnect(FileDescriptor fdo, boolean block, boolean ready) throws IOException {
            CIntPointer error_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            error_Pointer.write(0);
            CIntPointer n_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            n_Pointer.write(SizeOf.get(CIntPointer.class));
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            int result = 0;
            Poll.pollfd poller = (Poll.pollfd)StackValue.get(Poll.pollfd.class);
            poller.set_revents(1);
            if (!ready) {
                poller.set_fd(fd);
                poller.set_events(Poll.POLLOUT());
                poller.set_revents(0);
                result = Poll.poll(poller, 1, block ? -1 : 0);
                if (result < 0) {
                    throw PosixUtils.newIOExceptionWithLastError("Poll failed");
                }
                if (!block && result == 0) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
                }
            }
            if (CTypeConversion.toBoolean((int)poller.revents())) {
                Errno.set_errno(0);
                result = Socket.getsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_ERROR(), (PointerBase)error_Pointer, n_Pointer);
                if (result < 0) {
                    Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
                    return Target_jni.JNI_FALSE();
                }
                if (CTypeConversion.toBoolean((int)error_Pointer.read())) {
                    Util_sun_nio_ch_Net.handleSocketError(error_Pointer.read());
                    return Target_jni.JNI_FALSE();
                }
                return 1;
            }
            return 0;
        }

        @Substitute
        @TargetElement(onlyWith={JDK11OrLater.class, JDK11OrEarlier.class})
        static int checkConnect(FileDescriptor fdo, boolean block) throws IOException {
            CIntPointer error_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            error_Pointer.write(0);
            CIntPointer n_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            n_Pointer.write(SizeOf.get(CIntPointer.class));
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            int result = 0;
            Poll.pollfd poller = (Poll.pollfd)StackValue.get(Poll.pollfd.class);
            poller.set_fd(fd);
            poller.set_events(Poll.POLLOUT());
            poller.set_revents(0);
            result = Poll.poll(poller, 1, block ? -1 : 0);
            if (result < 0) {
                if (Errno.errno() == Errno.EINTR()) {
                    return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
                }
                throw PosixUtils.newIOExceptionWithLastError("poll failed");
            }
            if (!block && result == 0) {
                return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
            }
            if (result > 0) {
                Errno.set_errno(0);
                result = Socket.getsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_ERROR(), (PointerBase)error_Pointer, n_Pointer);
                if (result < 0) {
                    return Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
                }
                if (CTypeConversion.toBoolean((int)error_Pointer.read())) {
                    return Util_sun_nio_ch_Net.handleSocketError(error_Pointer.read());
                }
                if ((poller.revents() & Poll.POLLHUP()) != 0) {
                    return Util_sun_nio_ch_Net.handleSocketError(Errno.ENOTCONN());
                }
                return 1;
            }
            return 0;
        }
    }

    @TargetClass(className="sun.nio.fs.UnixCopyFile")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_UnixCopyFile {
        Target_sun_nio_fs_UnixCopyFile() {
        }

        @Substitute
        private static void transfer(int dst, int src, long cancelAddress) throws Exception {
            int bufsize = 8192;
            CCharPointer buf = (CCharPointer)StackValue.get((int)bufsize, CCharPointer.class);
            CIntPointer cancel = (CIntPointer)WordFactory.pointer((long)cancelAddress);
            while (true) {
                SignedWord n;
                if ((n = Unistd.read(src, (PointerBase)buf, WordFactory.unsigned((int)bufsize))).equal(-1) && Errno.errno() == Errno.EINTR()) {
                    continue;
                }
                if (n.lessOrEqual(0)) {
                    if (n.lessThan(0)) {
                        throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
                    }
                    return;
                }
                if (!cancel.isNull() && cancel.read() != 0) {
                    throw PosixJavaNIOSubstitutions.throwUnixException(Errno.ECANCELED());
                }
                SignedWord pos = (SignedWord)WordFactory.zero();
                SignedWord len = n;
                do {
                    CCharPointer bufp = buf;
                    bufp = bufp.addressOf(pos);
                    while ((n = Unistd.write(dst, (PointerBase)bufp, (UnsignedWord)len)).equal(-1) && Errno.errno() == Errno.EINTR()) {
                    }
                    if (n.equal(-1)) {
                        throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
                    }
                    pos = pos.add(n);
                } while ((len = len.subtract(n)).greaterThan(0));
            }
        }
    }

    @TargetClass(className="sun.nio.ch.FileKey")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_FileKey {
        @Alias
        long st_dev;
        @Alias
        long st_ino;

        Target_sun_nio_ch_FileKey() {
        }

        @Substitute
        private static void initIDs() {
            throw new InternalError("initIDs() is only called from static initializers, so not reachable in Substrate VM");
        }

        @Substitute
        private void init(FileDescriptor fdo) throws IOException {
            int res;
            Stat.stat fbuf = (Stat.stat)StackValue.get(Stat.stat.class);
            while ((res = Stat.fstat(PosixJavaNIOSubstitutions.fdval(fdo), fbuf)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0) {
                throw PosixUtils.newIOExceptionWithLastError("fstat64 failed");
            }
            this.st_dev = fbuf.st_dev();
            this.st_ino = fbuf.st_ino();
        }
    }

    @TargetClass(className="sun.nio.ch.FileChannelImpl")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_FileChannelImpl {
        @Alias
        @TargetElement(name="fd")
        private FileDescriptor fdfield;
        @Alias
        private static int MAP_RO;
        @Alias
        private static int MAP_RW;
        @Alias
        private static int MAP_PV;

        Target_sun_nio_ch_FileChannelImpl() {
        }

        @Substitute
        private static long initIDs() {
            throw new InternalError("initIDs() is only called from static initializers, so not reachable in Substrate VM");
        }

        @Substitute
        private long map0(int prot, long off, long len) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(this.fdfield);
            int protections = 0;
            int flags = 0;
            if (prot == MAP_RO) {
                protections = Mman.PROT_READ();
                flags = Mman.MAP_SHARED();
            } else if (prot == MAP_RW) {
                protections = Mman.PROT_WRITE() | Mman.PROT_READ();
                flags = Mman.MAP_SHARED();
            } else if (prot == MAP_PV) {
                protections = Mman.PROT_WRITE() | Mman.PROT_READ();
                flags = Mman.MAP_PRIVATE();
            }
            Pointer mapAddress = Mman.mmap(WordFactory.nullPointer(), WordFactory.unsigned((long)len), protections, flags, fd, off);
            if (mapAddress.equal((ComparableWord)Mman.MAP_FAILED())) {
                if (Errno.errno() == Errno.ENOMEM()) {
                    throw PosixJavaNIOSubstitutions.throwOutOfMemoryError("Map failed");
                }
                return PosixJavaNIOSubstitutions.handle(-1, "Map failed");
            }
            return mapAddress.rawValue();
        }

        @Substitute
        private static int unmap0(long address, long len) throws IOException {
            PointerBase a = WordFactory.pointer((long)address);
            return PosixJavaNIOSubstitutions.handle(Mman.munmap(a, WordFactory.unsigned((long)len)), "Unmap failed");
        }

        @Substitute
        @TargetElement(name="transferTo0")
        @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
        private long transferTo0Linux(FileDescriptor src, long position, long count, FileDescriptor dst) throws IOException {
            CLongPointer offset = (CLongPointer)StackValue.get(CLongPointer.class);
            offset.write(position);
            SignedWord n = LinuxSendfile.sendfile(PosixJavaNIOSubstitutions.fdval(dst), PosixJavaNIOSubstitutions.fdval(src), offset, WordFactory.unsigned((long)count));
            if (n.lessThan(0)) {
                if (Errno.errno() == Errno.EAGAIN()) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
                }
                if (Errno.errno() == Errno.EINVAL() && count >= 0L) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNSUPPORTED_CASE;
                }
                if (Errno.errno() == Errno.EINTR()) {
                    return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
                }
                throw PosixUtils.newIOExceptionWithLastError("Transfer failed");
            }
            return n.rawValue();
        }

        @Substitute
        @TargetElement(name="transferTo0")
        @Platforms(value={DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
        private long transferTo0Darwin(FileDescriptor src, long position, long count, FileDescriptor dst) throws IOException {
            CLongPointer numBytes = (CLongPointer)StackValue.get(CLongPointer.class);
            numBytes.write(count);
            int result = DarwinSendfile.sendfile(PosixJavaNIOSubstitutions.fdval(src), PosixJavaNIOSubstitutions.fdval(dst), position, numBytes, (DarwinSendfile.sf_hdtr)WordFactory.nullPointer(), 0);
            if (numBytes.read() > 0L) {
                return numBytes.rawValue();
            }
            if (result == -1) {
                if (Errno.errno() == Errno.EAGAIN()) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
                }
                if (Errno.errno() == Errno.EOPNOTSUPP() || Errno.errno() == Errno.ENOTSOCK() || Errno.errno() == Errno.ENOTCONN()) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNSUPPORTED_CASE;
                }
                if (Errno.errno() == Errno.EINVAL() && count >= 0L) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNSUPPORTED_CASE;
                }
                if (Errno.errno() == Errno.EINTR()) {
                    return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
                }
                throw PosixUtils.newIOExceptionWithLastError("Transfer failed");
            }
            return result;
        }
    }

    @TargetClass(className="sun.nio.fs.MacOSXNativeDispatcher")
    @Platforms(value={DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_MacOSXNativeDispatcher {
        Target_sun_nio_fs_MacOSXNativeDispatcher() {
        }

        @Substitute
        private static char[] normalizepath(char[] path, int form) {
            CoreFoundation.CFMutableStringRef csref = DarwinCoreFoundationUtils.toCFStringRef(String.valueOf(path));
            CoreFoundation.CFStringNormalize(csref, WordFactory.signed((int)form));
            String res = DarwinCoreFoundationUtils.fromCFStringRef(csref);
            CoreFoundation.CFRelease(csref);
            return res.toCharArray();
        }
    }

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    static final class Util_sun_nio_fs_LinuxNativeDispatcher {
        static fgetxattr_func my_fgetxattr_func;
        static fsetxattr_func my_fsetxattr_func;
        static fremovexattr_func my_fremovexattr_func;
        static flistxattr_func my_flistxattr_func;
        static volatile boolean initialized;

        Util_sun_nio_fs_LinuxNativeDispatcher() {
        }

        static void initialize() {
            my_fgetxattr_func = (fgetxattr_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "fgetxattr");
            my_fsetxattr_func = (fsetxattr_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "fsetxattr");
            my_fremovexattr_func = (fremovexattr_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "fremovexattr");
            my_flistxattr_func = (flistxattr_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "flistxattr");
            initialized = true;
        }
    }

    @TargetClass(className="sun.nio.fs.LinuxNativeDispatcher")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_LinuxNativeDispatcher {
        Target_sun_nio_fs_LinuxNativeDispatcher() {
        }

        @Substitute
        private static long setmntent0(long pathAddress, long modeAddress) throws Exception {
            Stdio.FILE fp;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            CCharPointer mode = (CCharPointer)WordFactory.pointer((long)modeAddress);
            while ((fp = Mntent.setmntent(path, mode)).isNull() && Errno.errno() == Errno.EINTR()) {
            }
            if (fp.isNull()) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return fp.rawValue();
        }

        @Substitute
        private static int getmntent(long value, Target_sun_nio_fs_UnixMountEntry entry) {
            Mntent.mntent ent = (Mntent.mntent)StackValue.get(Mntent.mntent.class);
            int buflen = 1024;
            CCharPointer buf = (CCharPointer)StackValue.get((int)buflen, CCharPointer.class);
            Stdio.FILE fp = (Stdio.FILE)WordFactory.pointer((long)value);
            Mntent.mntent m = Mntent.getmntent_r(fp, ent, buf, buflen);
            if (m.isNull()) {
                return -1;
            }
            entry.name = PosixJavaNIOSubstitutions.toByteArray(m.mnt_fsname());
            entry.dir = PosixJavaNIOSubstitutions.toByteArray(m.mnt_dir());
            entry.fstype = PosixJavaNIOSubstitutions.toByteArray(m.mnt_type());
            entry.opts = PosixJavaNIOSubstitutions.toByteArray(m.mnt_opts());
            return 0;
        }

        @Substitute
        private static void endmntent(long stream) {
            Stdio.FILE fp = (Stdio.FILE)WordFactory.pointer((long)stream);
            Mntent.endmntent(fp);
        }

        @Substitute
        private static int fgetxattr0(int fd, long nameAddress, long valueAddress, int valueLen) throws Exception {
            CCharPointer name = (CCharPointer)WordFactory.pointer((long)nameAddress);
            PointerBase value = WordFactory.pointer((long)valueAddress);
            if (!Util_sun_nio_fs_LinuxNativeDispatcher.initialized) {
                Util_sun_nio_fs_LinuxNativeDispatcher.initialize();
            }
            if (Util_sun_nio_fs_LinuxNativeDispatcher.my_fgetxattr_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.ENOTSUP());
            }
            int res = (int)Util_sun_nio_fs_LinuxNativeDispatcher.my_fgetxattr_func.invoke(fd, name, value, WordFactory.unsigned((int)valueLen)).rawValue();
            if (res == -1) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return res;
        }

        @Substitute
        private static void fsetxattr0(int fd, long nameAddress, long valueAddress, int valueLen) throws Exception {
            CCharPointer name = (CCharPointer)WordFactory.pointer((long)nameAddress);
            PointerBase value = WordFactory.pointer((long)valueAddress);
            if (!Util_sun_nio_fs_LinuxNativeDispatcher.initialized) {
                Util_sun_nio_fs_LinuxNativeDispatcher.initialize();
            }
            if (Util_sun_nio_fs_LinuxNativeDispatcher.my_fsetxattr_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.ENOTSUP());
            }
            int res = Util_sun_nio_fs_LinuxNativeDispatcher.my_fsetxattr_func.invoke(fd, name, value, WordFactory.unsigned((int)valueLen), 0);
            if (res == -1) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void fremovexattr0(int fd, long nameAddress) throws Exception {
            CCharPointer name = (CCharPointer)WordFactory.pointer((long)nameAddress);
            if (!Util_sun_nio_fs_LinuxNativeDispatcher.initialized) {
                Util_sun_nio_fs_LinuxNativeDispatcher.initialize();
            }
            if (Util_sun_nio_fs_LinuxNativeDispatcher.my_fremovexattr_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.ENOTSUP());
            }
            int res = Util_sun_nio_fs_LinuxNativeDispatcher.my_fremovexattr_func.invoke(fd, name);
            if (res == -1) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static int flistxattr(int fd, long listAddress, int size) throws Exception {
            CCharPointer list = (CCharPointer)WordFactory.pointer((long)listAddress);
            if (!Util_sun_nio_fs_LinuxNativeDispatcher.initialized) {
                Util_sun_nio_fs_LinuxNativeDispatcher.initialize();
            }
            if (Util_sun_nio_fs_LinuxNativeDispatcher.my_flistxattr_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.ENOTSUP());
            }
            int res = Util_sun_nio_fs_LinuxNativeDispatcher.my_flistxattr_func.invoke(fd, list, WordFactory.unsigned((int)size));
            if (res == -1) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return res;
        }

        @Substitute
        private static void init() {
            throw new InternalError("init() is only called from static initializers, so not reachable in Substrate VM");
        }
    }

    static interface flistxattr_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int invoke(int var1, CCharPointer var2, UnsignedWord var3);
    }

    static interface fremovexattr_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int invoke(int var1, CCharPointer var2);
    }

    static interface fsetxattr_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int invoke(int var1, CCharPointer var2, PointerBase var3, UnsignedWord var4, int var5);
    }

    static interface fgetxattr_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public UnsignedWord invoke(int var1, CCharPointer var2, PointerBase var3, UnsignedWord var4);
    }

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Util_sun_nio_fs_UnixNativeDispatcher {
        static final int ENT_BUF_SIZE = 1024;
        static openat64_func my_openat64_func;
        static fstatat64_func my_fstatat64_func;
        static unlinkat_func my_unlinkat_func;
        static renameat_func my_renameat_func;
        static futimesat_func my_futimesat_func;
        static fdopendir_func my_fdopendir_func;
        static volatile boolean initialized;
        private static boolean hasAtSysCalls;

        Util_sun_nio_fs_UnixNativeDispatcher() {
        }

        static void initialize() {
            my_openat64_func = (openat64_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "openat64");
            my_fstatat64_func = (fstatat64_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "fstatat64");
            my_unlinkat_func = (unlinkat_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "unlinkat");
            my_renameat_func = (renameat_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "renameat");
            my_futimesat_func = (futimesat_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "futimesat");
            my_fdopendir_func = (fdopendir_func)PosixJavaNIOSubstitutions.dlsym(Dlfcn.RTLD_DEFAULT(), "fdopendir");
            hasAtSysCalls = !my_openat64_func.isNull() && !my_fstatat64_func.isNull() && !my_unlinkat_func.isNull() && !my_renameat_func.isNull() && !my_futimesat_func.isNull() && !my_fdopendir_func.isNull();
            initialized = true;
        }

        static void prepAttributes(Stat.stat buf, Target_sun_nio_fs_UnixFileAttributes attrs) {
            Target_sun_nio_fs_UnixFileAttributes alias = attrs;
            alias.st_mode = buf.st_mode();
            alias.st_ino = buf.st_ino();
            alias.st_dev = buf.st_dev();
            alias.st_rdev = buf.st_rdev();
            alias.st_nlink = (int)buf.st_nlink();
            alias.st_uid = buf.st_uid();
            alias.st_gid = buf.st_gid();
            alias.st_size = buf.st_size();
            alias.st_atime_sec = buf.st_atime();
            alias.st_mtime_sec = buf.st_mtime();
            alias.st_ctime_sec = buf.st_ctime();
        }
    }

    @TargetClass(className="sun.nio.fs.UnixNativeDispatcher")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_UnixNativeDispatcher {
        Target_sun_nio_fs_UnixNativeDispatcher() {
        }

        @Substitute
        private static byte[] getcwd() throws Exception {
            int bufsize = Limits.PATH_MAX() + 1;
            CCharPointer buf = (CCharPointer)StackValue.get((int)bufsize, CCharPointer.class);
            CCharPointer cwd = Unistd.getcwd(buf, WordFactory.unsigned((int)bufsize));
            if (cwd.isNull()) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            byte[] result = PosixJavaNIOSubstitutions.toByteArray(buf);
            return result;
        }

        @Substitute
        private static int dup(int fd) throws Exception {
            int res = -1;
            while ((res = Unistd.dup(fd)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return res;
        }

        @Substitute
        private static int open0(long pathAddress, int flags, int mode) throws Exception {
            int fd;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((fd = Fcntl.open(path, flags, mode)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (fd == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return fd;
        }

        @Substitute
        private static int openat0(int dfd, long pathAddress, int flags, int mode) throws Exception {
            int fd;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            if (Util_sun_nio_fs_UnixNativeDispatcher.my_openat64_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwInternalError("should not reach here");
            }
            while ((fd = Util_sun_nio_fs_UnixNativeDispatcher.my_openat64_func.invoke(dfd, path, flags, mode)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (fd == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return fd;
        }

        @Substitute
        private static void close(int fd) {
            int err;
            while ((err = Unistd.close(fd)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
        }

        @Substitute
        private static long fopen0(long pathAddress, long modeAddress) throws Exception {
            Stdio.FILE fp = (Stdio.FILE)WordFactory.nullPointer();
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            CCharPointer mode = (CCharPointer)WordFactory.pointer((long)modeAddress);
            while ((fp = Stdio.fopen(path, mode)).isNull() && Errno.errno() == Errno.EINTR()) {
            }
            if (fp.isNull()) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return fp.rawValue();
        }

        @Substitute
        private static void fclose(long stream) throws Exception {
            int res;
            Stdio.FILE fp = (Stdio.FILE)WordFactory.pointer((long)stream);
            while ((res = Stdio.fclose(fp)) == Stdio.EOF() && Errno.errno() == Errno.EINTR()) {
            }
            if (res == Stdio.EOF()) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void link0(long existingAddress, long newAddress) throws Exception {
            int err;
            CCharPointer existing = (CCharPointer)WordFactory.pointer((long)existingAddress);
            CCharPointer newname = (CCharPointer)WordFactory.pointer((long)newAddress);
            while ((err = Unistd.link(existing, newname)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void unlink0(long pathAddress) throws Exception {
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            if (Unistd.unlink(path) == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void unlinkat0(int dfd, long pathAddress, int flags) throws Exception {
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            if (Util_sun_nio_fs_UnixNativeDispatcher.my_unlinkat_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwInternalError("should not reach here");
            }
            if (Util_sun_nio_fs_UnixNativeDispatcher.my_unlinkat_func.invoke(dfd, path, flags) == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void mknod0(long pathAddress, int mode, long dev) throws Exception {
            int err;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Stat.mknod(path, mode, dev)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void rename0(long fromAddress, long toAddress) throws Exception {
            CCharPointer to;
            CCharPointer from = (CCharPointer)WordFactory.pointer((long)fromAddress);
            if (Stdio.rename(from, to = (CCharPointer)WordFactory.pointer((long)toAddress)) == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void renameat0(int fromfd, long fromAddress, int tofd, long toAddress) throws Exception {
            CCharPointer from = (CCharPointer)WordFactory.pointer((long)fromAddress);
            CCharPointer to = (CCharPointer)WordFactory.pointer((long)toAddress);
            if (Util_sun_nio_fs_UnixNativeDispatcher.my_renameat_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwInternalError("should not reach here");
            }
            if (Util_sun_nio_fs_UnixNativeDispatcher.my_renameat_func.invoke(fromfd, from, tofd, to) == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void mkdir0(long pathAddress, int mode) throws Exception {
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            if (Stat.mkdir(path, mode) == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void rmdir0(long pathAddress) throws Exception {
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            if (Unistd.rmdir(path) == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static byte[] readlink0(long pathAddress) throws Exception {
            int targetsize = Limits.PATH_MAX() + 1;
            CCharPointer target = (CCharPointer)StackValue.get((int)targetsize, CCharPointer.class);
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            int n = (int)Unistd.readlink(path, target, WordFactory.unsigned((int)targetsize)).rawValue();
            if (n == -1) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            if (n == targetsize) {
                --n;
            }
            target.write(n, (byte)0);
            byte[] result = PosixJavaNIOSubstitutions.toByteArray(target);
            return result;
        }

        @Substitute
        private static byte[] realpath0(long pathAddress) throws Exception {
            CCharPointer resolved = (CCharPointer)StackValue.get((int)(Limits.PATH_MAX() + 1), CCharPointer.class);
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            if (Stdlib.realpath(path, resolved).isNull()) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            byte[] result = PosixJavaNIOSubstitutions.toByteArray(resolved);
            return result;
        }

        @Substitute
        private static void symlink0(long targetAddress, long linkAddress) throws Exception {
            CCharPointer link;
            CCharPointer target = (CCharPointer)WordFactory.pointer((long)targetAddress);
            if (Unistd.symlink(target, link = (CCharPointer)WordFactory.pointer((long)linkAddress)) == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void stat0(long pathAddress, Target_sun_nio_fs_UnixFileAttributes attrs) throws Exception {
            int err;
            Stat.stat buf = (Stat.stat)StackValue.get(Stat.stat.class);
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Stat.stat(path, buf)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            } else {
                Util_sun_nio_fs_UnixNativeDispatcher.prepAttributes(buf, attrs);
            }
        }

        @Substitute
        @TargetElement(onlyWith={JDK11OrLater.class})
        private static int stat1(long pathAddress) {
            int err;
            Stat.stat buf = (Stat.stat)StackValue.get(Stat.stat.class);
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Stat.stat(path, buf)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                return 0;
            }
            return buf.st_mode();
        }

        @Substitute
        @TargetElement(onlyWith={JDK11OrLater.class})
        private static boolean exists0(long pathAddress) {
            int err;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Unistd.access(path, Unistd.F_OK())) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            return err == 0;
        }

        @Substitute
        private static void lstat0(long pathAddress, Target_sun_nio_fs_UnixFileAttributes attrs) throws Exception {
            int err;
            Stat.stat buf = (Stat.stat)StackValue.get(Stat.stat.class);
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Stat.lstat(path, buf)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            } else {
                Util_sun_nio_fs_UnixNativeDispatcher.prepAttributes(buf, attrs);
            }
        }

        @Substitute
        private static void fstat(int fd, Target_sun_nio_fs_UnixFileAttributes attrs) throws Exception {
            int err;
            Stat.stat buf = (Stat.stat)StackValue.get(Stat.stat.class);
            while ((err = Stat.fstat(fd, buf)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            } else {
                Util_sun_nio_fs_UnixNativeDispatcher.prepAttributes(buf, attrs);
            }
        }

        @Substitute
        private static void fstatat0(int dfd, long pathAddress, int flag, Target_sun_nio_fs_UnixFileAttributes attrs) throws Exception {
            int err;
            Stat.stat buf = (Stat.stat)StackValue.get(Stat.stat.class);
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            if (Util_sun_nio_fs_UnixNativeDispatcher.my_fstatat64_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwInternalError("should not reach here");
            }
            while ((err = Util_sun_nio_fs_UnixNativeDispatcher.my_fstatat64_func.invoke(dfd, path, buf, flag)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            } else {
                Util_sun_nio_fs_UnixNativeDispatcher.prepAttributes(buf, attrs);
            }
        }

        @Substitute
        private static void chown0(long pathAddress, int uid, int gid) throws Exception {
            int err;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Unistd.chown(path, uid, gid)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void lchown0(long pathAddress, int uid, int gid) throws Exception {
            int err;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Unistd.lchown(path, uid, gid)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void fchown(int fd, int uid, int gid) throws Exception {
            int err;
            while ((err = Unistd.fchown(fd, uid, gid)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void chmod0(long pathAddress, int mode) throws Exception {
            int err;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Stat.chmod(path, mode)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void fchmod(int fd, int mode) throws Exception {
            int err;
            while ((err = Stat.fchmod(fd, mode)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void utimes0(long pathAddress, long accessTime, long modificationTime) throws Exception {
            int err;
            Time.timeval times = (Time.timeval)StackValue.get((int)2, Time.timeval.class);
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            times.addressOf(0).set_tv_sec(accessTime / 1000000L);
            times.addressOf(0).set_tv_usec(accessTime % 1000000L);
            times.addressOf(1).set_tv_sec(modificationTime / 1000000L);
            times.addressOf(1).set_tv_usec(modificationTime % 1000000L);
            while ((err = Time.utimes(path, times)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static void futimes(int fd, long accessTime, long modificationTime) throws Exception {
            Time.timeval times = (Time.timeval)StackValue.get((int)2, Time.timeval.class);
            int err = 0;
            times.addressOf(0).set_tv_sec(accessTime / 1000000L);
            times.addressOf(0).set_tv_usec(accessTime % 1000000L);
            times.addressOf(1).set_tv_sec(modificationTime / 1000000L);
            times.addressOf(1).set_tv_usec(modificationTime % 1000000L);
            while ((err = Time.futimes(fd, times)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static long opendir0(long pathAddress) throws Exception {
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            Dirent.DIR dir = Dirent.opendir(path);
            if (dir.isNull()) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return dir.rawValue();
        }

        @Substitute
        private static long fdopendir(int dfd) throws Exception {
            if (Util_sun_nio_fs_UnixNativeDispatcher.my_fdopendir_func.isNull()) {
                throw PosixJavaNIOSubstitutions.throwInternalError("should not reach here");
            }
            Dirent.DIR dir = Util_sun_nio_fs_UnixNativeDispatcher.my_fdopendir_func.invoke(dfd);
            if (dir.isNull()) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return dir.rawValue();
        }

        @Substitute
        private static void closedir(long dir) throws Exception {
            int err;
            Dirent.DIR dirp = (Dirent.DIR)WordFactory.pointer((long)dir);
            while ((err = Dirent.closedir(dirp)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (Errno.errno() == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static byte[] readdir(long value) throws Exception {
            Dirent.direntPointer result = (Dirent.direntPointer)StackValue.get(Dirent.direntPointer.class);
            Dirent.dirent ptr = (Dirent.dirent)StackValue.get((int)(SizeOf.get(Dirent.dirent.class) + Limits.PATH_MAX() + 1));
            Dirent.DIR dirp = (Dirent.DIR)WordFactory.pointer((long)value);
            int res = Dirent.readdir_r(dirp, ptr, result);
            if (res != 0) {
                throw PosixJavaNIOSubstitutions.throwUnixException(res);
            }
            if (result.read().isNull()) {
                return null;
            }
            return PosixJavaNIOSubstitutions.toByteArray(ptr.d_name());
        }

        @Substitute
        private static int read(int fd, long address, int nbytes) throws Exception {
            int n;
            PointerBase bufp = WordFactory.pointer((long)address);
            while ((n = (int)Unistd.read(fd, bufp, WordFactory.unsigned((int)nbytes)).rawValue()) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (n == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return n;
        }

        @Substitute
        private static int write(int fd, long address, int nbytes) throws Exception {
            int n;
            PointerBase bufp = WordFactory.pointer((long)address);
            while ((n = (int)Unistd.write(fd, bufp, WordFactory.unsigned((int)nbytes)).rawValue()) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (n == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return n;
        }

        @Substitute
        private static void access0(long pathAddress, int amode) throws Exception {
            int err;
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Unistd.access(path, amode)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
        }

        @Substitute
        private static byte[] getpwuid(int uid) throws Exception {
            CCharPointer pwbuf;
            int buflen = (int)Unistd.sysconf(Unistd._SC_GETPW_R_SIZE_MAX());
            if (buflen == -1) {
                buflen = 1024;
            }
            if ((pwbuf = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)buflen))).isNull()) {
                throw PosixJavaNIOSubstitutions.throwOutOfMemoryError("native heap");
            }
            Pwd.passwd pwent = (Pwd.passwd)StackValue.get(Pwd.passwd.class);
            Pwd.passwdPointer p = (Pwd.passwdPointer)StackValue.get(Pwd.passwdPointer.class);
            p.write(WordFactory.nullPointer());
            int res = 0;
            Errno.set_errno(0);
            while ((res = Pwd.getpwuid_r(uid, pwent, pwbuf, WordFactory.unsigned((int)buflen), p)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res != 0 || p.read().isNull() || p.read().pw_name().isNull() || p.read().pw_name().read() == 0) {
                throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno() == 0 ? Errno.ENOENT() : Errno.errno());
            }
            byte[] result = PosixJavaNIOSubstitutions.toByteArray(p.read().pw_name());
            LibC.free((PointerBase)pwbuf);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Substitute
        private static byte[] getgrgid(int gid) throws Exception {
            boolean retry;
            byte[] result = null;
            int buflen = (int)Unistd.sysconf(Unistd._SC_GETGR_R_SIZE_MAX());
            if (buflen == -1) {
                buflen = 1024;
            }
            do {
                Grp.group grent = (Grp.group)StackValue.get(Grp.group.class);
                Grp.groupPointer g = (Grp.groupPointer)StackValue.get(Grp.groupPointer.class);
                g.write(WordFactory.nullPointer());
                int res = 0;
                CCharPointer grbuf = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)buflen));
                if (grbuf.isNull()) {
                    throw PosixJavaNIOSubstitutions.throwOutOfMemoryError("native heap");
                }
                Errno.set_errno(0);
                while ((res = Grp.getgrgid_r(gid, grent, grbuf, WordFactory.unsigned((int)buflen), g)) == -1 && Errno.errno() == Errno.EINTR()) {
                }
                retry = false;
                if (res != 0 || g.read().isNull() || g.read().gr_name().isNull() || g.read().gr_name().read() == 0) {
                    if (Errno.errno() != Errno.ERANGE()) throw PosixJavaNIOSubstitutions.throwUnixException(Errno.errno() == 0 ? Errno.ENOENT() : Errno.errno());
                    buflen += 1024;
                    retry = true;
                } else {
                    result = PosixJavaNIOSubstitutions.toByteArray(g.read().gr_name());
                }
                LibC.free((PointerBase)grbuf);
            } while (retry);
            return result;
        }

        @Substitute
        private static int getpwnam0(long nameAddress) throws Exception {
            CCharPointer pwbuf;
            int uid = -1;
            int buflen = (int)Unistd.sysconf(Unistd._SC_GETPW_R_SIZE_MAX());
            if (buflen == -1) {
                buflen = 1024;
            }
            if ((pwbuf = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)buflen))).isNull()) {
                throw PosixJavaNIOSubstitutions.throwOutOfMemoryError("native heap");
            }
            Pwd.passwd pwent = (Pwd.passwd)StackValue.get(Pwd.passwd.class);
            Pwd.passwdPointer p = (Pwd.passwdPointer)StackValue.get(Pwd.passwdPointer.class);
            p.write(WordFactory.nullPointer());
            int res = 0;
            CCharPointer name = (CCharPointer)WordFactory.pointer((long)nameAddress);
            Errno.set_errno(0);
            while ((res = Pwd.getpwnam_r(name, pwent, pwbuf, WordFactory.unsigned((int)buflen), p)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res != 0 || p.read().isNull() || p.read().pw_name().isNull() || p.read().pw_name().read() == 0) {
                if (Errno.errno() != 0 && Errno.errno() != Errno.ENOENT() && Errno.errno() != Errno.ESRCH()) {
                    PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
                }
            } else {
                uid = p.read().pw_uid();
            }
            LibC.free((PointerBase)pwbuf);
            return uid;
        }

        @Substitute
        private static int getgrnam0(long nameAddress) throws Exception {
            boolean retry;
            int gid = -1;
            int buflen = (int)Unistd.sysconf(Unistd._SC_GETGR_R_SIZE_MAX());
            if (buflen == -1) {
                buflen = 1024;
            }
            do {
                Grp.group grent = (Grp.group)StackValue.get(Grp.group.class);
                Grp.groupPointer g = (Grp.groupPointer)StackValue.get(Grp.groupPointer.class);
                g.write(WordFactory.nullPointer());
                int res = 0;
                CCharPointer name = (CCharPointer)WordFactory.pointer((long)nameAddress);
                CCharPointer grbuf = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)buflen));
                if (grbuf.isNull()) {
                    throw PosixJavaNIOSubstitutions.throwOutOfMemoryError("native heap");
                }
                Errno.set_errno(0);
                while ((res = Grp.getgrnam_r(name, grent, grbuf, WordFactory.unsigned((int)buflen), g)) == -1 && Errno.errno() == Errno.EINTR()) {
                }
                retry = false;
                if (res != 0 || g.read().isNull() || g.read().gr_name().isNull() || g.read().gr_name().read() == 0) {
                    if (Errno.errno() != 0 && Errno.errno() != Errno.ENOENT() && Errno.errno() != Errno.ESRCH()) {
                        if (Errno.errno() == Errno.ERANGE()) {
                            buflen += 1024;
                            retry = true;
                        } else {
                            PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
                        }
                    }
                } else {
                    gid = g.read().gr_gid();
                }
                LibC.free((PointerBase)grbuf);
            } while (retry);
            return gid;
        }

        @Substitute
        private static void statvfs0(long pathAddress, Target_sun_nio_fs_UnixFileStoreAttributes attrs) throws Exception {
            int err;
            Statvfs.statvfs buf = (Statvfs.statvfs)StackValue.get(Statvfs.statvfs.class);
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            while ((err = Statvfs.statvfs(path, buf)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (err == -1) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            } else {
                attrs.f_frsize = buf.f_frsize();
                attrs.f_blocks = buf.f_blocks();
                attrs.f_bfree = buf.f_bfree();
                attrs.f_bavail = buf.f_bavail();
            }
        }

        @Substitute
        private static long pathconf0(long pathAddress, int name) throws Exception {
            CCharPointer path = (CCharPointer)WordFactory.pointer((long)pathAddress);
            long err = Unistd.pathconf(path, name);
            if (err == -1L) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return err;
        }

        @Substitute
        private static long fpathconf(int fd, int name) throws Exception {
            long err = Target_sun_nio_fs_UnixNativeDispatcher.fpathconf(fd, name);
            if (err == -1L) {
                PosixJavaNIOSubstitutions.throwUnixException(Errno.errno());
            }
            return err;
        }

        @Substitute
        private static byte[] strerror(int errnum) {
            return PosixJavaNIOSubstitutions.toByteArray(Errno.strerror(errnum));
        }

        @Substitute
        private static int init() {
            throw new InternalError("init() is only called from static initializers, so not reachable in Substrate VM");
        }

        @Substitute
        private static boolean openatSupported() {
            if (!Util_sun_nio_fs_UnixNativeDispatcher.initialized) {
                Util_sun_nio_fs_UnixNativeDispatcher.initialize();
            }
            return Util_sun_nio_fs_UnixNativeDispatcher.hasAtSysCalls;
        }
    }

    static interface fdopendir_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public Dirent.DIR invoke(int var1);
    }

    static interface futimesat_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int invoke(int var1, CCharPointer var2, Time.timeval var3);
    }

    static interface renameat_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int invoke(int var1, CCharPointer var2, int var3, CCharPointer var4);
    }

    static interface unlinkat_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int invoke(int var1, CCharPointer var2, int var3);
    }

    static interface fstatat64_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int invoke(int var1, CCharPointer var2, Stat.stat var3, int var4);
    }

    static interface openat64_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int invoke(int var1, CCharPointer var2, int var3, int var4);
    }

    @TargetClass(className="sun.nio.fs.UnixMountEntry")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_UnixMountEntry {
        @Alias
        byte[] name;
        @Alias
        byte[] dir;
        @Alias
        byte[] fstype;
        @Alias
        byte[] opts;
        @Alias
        long dev;

        Target_sun_nio_fs_UnixMountEntry() {
        }
    }

    @TargetClass(className="sun.nio.fs.UnixFileStoreAttributes")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_UnixFileStoreAttributes {
        @Alias
        long f_frsize;
        @Alias
        long f_blocks;
        @Alias
        long f_bfree;
        @Alias
        long f_bavail;

        Target_sun_nio_fs_UnixFileStoreAttributes() {
        }
    }

    @TargetClass(className="sun.nio.fs.UnixFileAttributes")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_UnixFileAttributes {
        @Alias
        int st_mode;
        @Alias
        long st_ino;
        @Alias
        long st_dev;
        @Alias
        long st_rdev;
        @Alias
        int st_nlink;
        @Alias
        int st_uid;
        @Alias
        int st_gid;
        @Alias
        long st_size;
        @Alias
        long st_atime_sec;
        @Alias
        long st_atime_nsec;
        @Alias
        long st_mtime_sec;
        @Alias
        long st_mtime_nsec;
        @Alias
        long st_ctime_sec;
        @Alias
        long st_ctime_nsec;
        @Alias
        long st_birthtime_sec;

        Target_sun_nio_fs_UnixFileAttributes() {
        }
    }

    @TargetClass(className="sun.nio.fs.UnixException")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_UnixException {
        @Alias
        protected Target_sun_nio_fs_UnixException(int errno) {
        }
    }

    static final class Util_sun_nio_ch_FileDispatcherImpl {
        static int preCloseFD = -1;
        static volatile boolean initialized;

        Util_sun_nio_ch_FileDispatcherImpl() {
        }

        static void closeFileDescriptor(int fd) throws IOException {
            int result;
            if (fd != -1 && (result = Unistd.close(fd)) < 0) {
                throw PosixUtils.newIOExceptionWithLastError("Close failed");
            }
        }

        static void initialize() {
            CIntPointer sp = (CIntPointer)StackValue.get((int)2, CIntPointer.class);
            if (Socket.socketpair(Socket.PF_UNIX(), Socket.SOCK_STREAM(), 0, sp) == 0) {
                preCloseFD = sp.read(0);
                Unistd.close(sp.read(1));
            }
            initialized = true;
        }
    }

    @TargetClass(className="sun.nio.ch.FileDispatcherImpl")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_FileDispatcherImpl {
        Target_sun_nio_ch_FileDispatcherImpl() {
        }

        @Substitute
        private static int read0(FileDescriptor fdo, long address, int len) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            PointerBase buf = WordFactory.pointer((long)address);
            return PosixJavaNIOSubstitutions.convertReturnVal((WordBase)Unistd.read(fd, buf, WordFactory.unsigned((int)len)), true);
        }

        @Substitute
        private static int pread0(FileDescriptor fdo, long address, int len, long offset) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            PointerBase buf = WordFactory.pointer((long)address);
            return PosixJavaNIOSubstitutions.convertReturnVal((WordBase)Unistd.pread(fd, buf, WordFactory.unsigned((int)len), offset), true);
        }

        @Substitute
        private static long readv0(FileDescriptor fdo, long address, int len) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            Uio.iovec iov = (Uio.iovec)WordFactory.pointer((long)address);
            return PosixJavaNIOSubstitutions.convertLongReturnVal((WordBase)Uio.readv(fd, iov, len), true);
        }

        @Substitute
        private static int write0(FileDescriptor fdo, long address, int len) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            PointerBase buf = (PointerBase)WordFactory.unsigned((long)address);
            return PosixJavaNIOSubstitutions.convertReturnVal((WordBase)Unistd.write(fd, buf, WordFactory.unsigned((int)len)), false);
        }

        @Substitute
        private static int pwrite0(FileDescriptor fdo, long address, int len, long offset) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            PointerBase buf = (PointerBase)WordFactory.unsigned((long)address);
            return PosixJavaNIOSubstitutions.convertReturnVal((WordBase)Unistd.pwrite(fd, buf, WordFactory.unsigned((int)len), offset), false);
        }

        @Substitute
        private static long writev0(FileDescriptor fdo, long address, int len) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            Uio.iovec iov = (Uio.iovec)WordFactory.pointer((long)address);
            return PosixJavaNIOSubstitutions.convertLongReturnVal((WordBase)Uio.writev(fd, iov, len), false);
        }

        @Substitute
        private static int force0(FileDescriptor fdo, boolean metaData) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            int result = 0;
            result = !metaData ? Unistd.fdatasync(fd) : Unistd.fsync(fd);
            return PosixJavaNIOSubstitutions.handle(result, "Force failed");
        }

        @Substitute
        @TargetElement(onlyWith={ContainsAllocate0.class})
        private static int allocate0(FileDescriptor fd, long size) throws IOException {
            if (IsDefined.__linux__()) {
                return PosixJavaNIOSubstitutions.handle(Fcntl.fallocate(PosixJavaNIOSubstitutions.fdval(fd), 0, (SignedWord)WordFactory.zero(), WordFactory.signed((long)size)), "Allocation failed");
            }
            return PosixJavaNIOSubstitutions.handle(Unistd.ftruncate(PosixJavaNIOSubstitutions.fdval(fd), size), "Truncation failed");
        }

        @Substitute
        private static int truncate0(FileDescriptor fdo, long size) throws IOException {
            return PosixJavaNIOSubstitutions.handle(Unistd.ftruncate(PosixJavaNIOSubstitutions.fdval(fdo), size), "Truncation failed");
        }

        @Substitute
        private static long size0(FileDescriptor fdo) throws IOException {
            Stat.stat fbuf = (Stat.stat)StackValue.get(Stat.stat.class);
            if (Stat.fstat(PosixJavaNIOSubstitutions.fdval(fdo), fbuf) < 0) {
                return PosixJavaNIOSubstitutions.handle(-1, "Size failed");
            }
            return fbuf.st_size();
        }

        @Substitute
        private static int lock0(FileDescriptor fdo, boolean blocking, long pos, long size, boolean shared) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            int lockResult = 0;
            int cmd = 0;
            Fcntl.flock fl = (Fcntl.flock)StackValue.get(Fcntl.flock.class);
            fl.set_l_whence(Unistd.SEEK_SET());
            if (size == Long.MAX_VALUE) {
                fl.set_l_len((SignedWord)WordFactory.zero());
            } else {
                fl.set_l_len(WordFactory.signed((long)size));
            }
            fl.set_l_start(WordFactory.signed((long)pos));
            if (shared) {
                fl.set_l_type(Fcntl.F_RDLCK());
            } else {
                fl.set_l_type(Fcntl.F_WRLCK());
            }
            cmd = blocking ? Fcntl.F_SETLKW() : Fcntl.F_SETLK();
            lockResult = Fcntl.fcntl(fd, cmd, fl);
            if (lockResult < 0) {
                if (cmd == Fcntl.F_SETLK() && (Errno.errno() == Errno.EAGAIN() || Errno.errno() == Errno.EACCES())) {
                    return Target_sun_nio_ch_FileDispatcher.FD_NO_LOCK;
                }
                if (Errno.errno() == Errno.EINTR()) {
                    return Target_sun_nio_ch_FileDispatcher.FD_INTERRUPTED;
                }
                throw PosixUtils.newIOExceptionWithLastError("Lock failed");
            }
            return 0;
        }

        @Substitute
        private static void release0(FileDescriptor fdo, long pos, long size) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            int lockResult = 0;
            Fcntl.flock fl = (Fcntl.flock)StackValue.get(Fcntl.flock.class);
            int cmd = Fcntl.F_SETLK();
            fl.set_l_whence(Unistd.SEEK_SET());
            if (size == Long.MAX_VALUE) {
                fl.set_l_len((SignedWord)WordFactory.zero());
            } else {
                fl.set_l_len(WordFactory.signed((long)size));
            }
            fl.set_l_start(WordFactory.signed((long)pos));
            fl.set_l_type(Fcntl.F_UNLCK());
            lockResult = Fcntl.fcntl(fd, cmd, fl);
            if (lockResult < 0) {
                throw PosixUtils.newIOExceptionWithLastError("Release failed");
            }
        }

        @Substitute
        private static void close0(FileDescriptor fdo) throws IOException {
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            Util_sun_nio_ch_FileDispatcherImpl.closeFileDescriptor(fd);
        }

        @Substitute
        private static void preClose0(FileDescriptor fdo) throws IOException {
            if (!Util_sun_nio_ch_FileDispatcherImpl.initialized) {
                Util_sun_nio_ch_FileDispatcherImpl.initialize();
            }
            int fd = PosixJavaNIOSubstitutions.fdval(fdo);
            if (Util_sun_nio_ch_FileDispatcherImpl.preCloseFD >= 0 && Unistd.dup2(Util_sun_nio_ch_FileDispatcherImpl.preCloseFD, fd) < 0) {
                throw PosixUtils.newIOExceptionWithLastError("dup2 failed");
            }
        }

        @Substitute
        private static void closeIntFD(int fd) throws IOException {
            Util_sun_nio_ch_FileDispatcherImpl.closeFileDescriptor(fd);
        }

        @Substitute
        private static void init() {
            throw new InternalError("init() is only called from static initializers, so not reachable in Substrate VM");
        }

        @Substitute
        private static long seek0(FileDescriptor fd, long offset) throws IOException {
            int f = PosixJavaNIOSubstitutions.fdval(fd);
            long result = 0L;
            result = offset < 0L ? Unistd.lseek(f, (SignedWord)WordFactory.zero(), Unistd.SEEK_CUR()).rawValue() : Unistd.lseek(f, WordFactory.signed((long)offset), Unistd.SEEK_SET()).rawValue();
            return PosixJavaNIOSubstitutions.handle(result, "lseek failed");
        }

        static class ContainsAllocate0
        implements Predicate<Class<?>> {
            ContainsAllocate0() {
            }

            @Override
            public boolean test(Class<?> originalClass) {
                try {
                    originalClass.getDeclaredMethod("allocate0", FileDescriptor.class, Long.TYPE);
                    return true;
                }
                catch (NoSuchMethodException ex) {
                    return false;
                }
            }
        }
    }

    static final class Util_sun_nio_ch_Net {
        Util_sun_nio_ch_Net() {
        }

        static int handleSocketError(int errorValue) throws IOException {
            String exceptionString = "NioSocketError";
            if (errorValue == Errno.EINPROGRESS()) {
                return 0;
            }
            IOException xn = errorValue == Errno.EPROTO() ? new ProtocolException(PosixUtils.errorString(errorValue, "NioSocketError")) : (errorValue == Errno.ECONNREFUSED() ? new ConnectException(PosixUtils.errorString(errorValue, "NioSocketError")) : (errorValue == Errno.ETIMEDOUT() ? new ConnectException(PosixUtils.errorString(errorValue, "NioSocketError")) : (errorValue == Errno.EHOSTUNREACH() ? new NoRouteToHostException(PosixUtils.errorString(errorValue, "NioSocketError")) : (errorValue == Errno.EADDRINUSE() || errorValue == Errno.EADDRNOTAVAIL() ? new BindException(PosixUtils.errorString(errorValue, "NioSocketError")) : new SocketException(PosixUtils.errorString(errorValue, "NioSocketError"))))));
            Errno.set_errno(errorValue);
            throw xn;
        }
    }

    static final class Util_sun_nio_ch_ServerSocketChannelImpl {
        Util_sun_nio_ch_ServerSocketChannelImpl() {
        }

        static int accept0(FileDescriptor ssfdo, FileDescriptor newfdo, InetSocketAddress[] isaa) throws IOException {
            InetSocketAddress isa;
            CIntPointer sa_len_Pointer;
            int newfd;
            int ssfd = PosixJavaNIOSubstitutions.fdval(ssfdo);
            Socket.sockaddrPointer sa_Pointer = (Socket.sockaddrPointer)StackValue.get(Socket.sockaddrPointer.class);
            CIntPointer alloc_len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            InetAddress remote_ia = null;
            CIntPointer remote_port_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            JavaNetNetUtilMD.NET_AllocSockaddr(sa_Pointer, alloc_len_Pointer);
            do {
                sa_len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
                sa_len_Pointer.write(alloc_len_Pointer.read());
            } while ((newfd = Socket.accept(ssfd, sa_Pointer.read(), sa_len_Pointer)) < 0 && Errno.errno() == Errno.ECONNABORTED());
            if (newfd < 0) {
                LibC.free(sa_Pointer.read());
                if (Errno.errno() == Errno.EAGAIN()) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
                }
                if (Errno.errno() == Errno.EINTR()) {
                    return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
                }
                throw PosixUtils.newIOExceptionWithLastError("Accept failed");
            }
            PosixUtils.setFD(newfdo, newfd);
            remote_ia = JavaNetNetUtil.NET_SockaddrToInetAddress(sa_Pointer.read(), remote_port_Pointer);
            LibC.free(sa_Pointer.read());
            isaa[0] = isa = new InetSocketAddress(remote_ia, remote_port_Pointer.read());
            return 1;
        }
    }

    @TargetClass(className="sun.nio.ch.ServerSocketChannelImpl")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_ServerSocketChannelImpl {
        Target_sun_nio_ch_ServerSocketChannelImpl() {
        }

        @TargetElement(onlyWith={JDK11OrEarlier.class})
        @Substitute
        int accept0(FileDescriptor ssfdo, FileDescriptor newfdo, InetSocketAddress[] isaa) throws IOException {
            return Util_sun_nio_ch_ServerSocketChannelImpl.accept0(ssfdo, newfdo, isaa);
        }
    }

    @TargetClass(className="sun.nio.ch.Net")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_Net {
        Target_sun_nio_ch_Net() {
        }

        @Substitute
        static int connect0(boolean preferIPv6, FileDescriptor fdo, InetAddress iao, int port) throws IOException {
            Socket.sockaddr sa_Pointer = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer sa_len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            sa_len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            if (JavaNetNetUtilMD.NET_InetAddressToSockaddr(iao, port, sa_Pointer, sa_len_Pointer, preferIPv6) != 0) {
                return Target_sun_nio_ch_IOStatus.IOS_THROWN;
            }
            int rv = Socket.connect(PosixJavaNIOSubstitutions.fdval(fdo), sa_Pointer, sa_len_Pointer.read());
            if (rv != 0) {
                if (Errno.errno() == Errno.EINPROGRESS()) {
                    return Target_sun_nio_ch_IOStatus.IOS_UNAVAILABLE;
                }
                if (Errno.errno() == Errno.EINTR()) {
                    return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
                }
                return Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
            }
            return 1;
        }

        @Substitute
        static boolean isIPv6Available0() {
            return JavaNetNetUtil.ipv6_available();
        }

        @Substitute
        static InetAddress localInetAddress(FileDescriptor fdo) throws IOException {
            Socket.sockaddr sa_Pointer = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer sa_len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            sa_len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer port_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            if (Socket.getsockname(PosixJavaNIOSubstitutions.fdval(fdo), sa_Pointer, sa_len_Pointer) < 0) {
                Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
                return null;
            }
            return JavaNetNetUtil.NET_SockaddrToInetAddress(sa_Pointer, port_Pointer);
        }

        @Substitute
        static int localPort(FileDescriptor fdo) throws IOException {
            Socket.sockaddr sa_Pointer = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer sa_len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            sa_len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            if (Socket.getsockname(PosixJavaNIOSubstitutions.fdval(fdo), sa_Pointer, sa_len_Pointer) < 0) {
                Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
                return -1;
            }
            return JavaNetNetUtilMD.NET_GetPortFromSockaddr(sa_Pointer);
        }

        @Substitute
        static int poll(FileDescriptor fdo, int events, long timeout) throws IOException {
            Poll.pollfd pfd = (Poll.pollfd)StackValue.get(Poll.pollfd.class);
            pfd.set_fd(PosixJavaNIOSubstitutions.fdval(fdo));
            pfd.set_events((short)events);
            int rv = Poll.poll(pfd, 1, (int)timeout);
            if (rv >= 0) {
                return pfd.events();
            }
            if (Errno.errno() == Errno.EINTR()) {
                return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
            }
            Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
            return Target_sun_nio_ch_IOStatus.IOS_THROWN;
        }

        @Substitute
        static int socket0(boolean preferIPv6, boolean stream, boolean reuse, boolean fastLoopback) throws IOException {
            CIntPointer arg_Pointer;
            int type = stream ? Socket.SOCK_STREAM() : Socket.SOCK_DGRAM();
            int domain = JavaNetNetUtil.ipv6_available() && preferIPv6 ? Socket.AF_INET6() : Socket.AF_INET();
            int fd = Socket.socket(domain, type, 0);
            if (fd < 0) {
                return Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
            }
            if (domain == Socket.AF_INET6()) {
                arg_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
                arg_Pointer.write(0);
                if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_V6ONLY(), (PointerBase)arg_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
                    try {
                        throw new SocketException(PosixUtils.lastErrorString("Unable to set IPV6_V6ONLY"));
                    }
                    catch (Throwable throwable) {
                        Unistd.close(fd);
                        throw throwable;
                    }
                }
            }
            if (reuse) {
                arg_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
                arg_Pointer.write(1);
                if (Socket.setsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_REUSEADDR(), (PointerBase)arg_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
                    try {
                        throw new SocketException(PosixUtils.lastErrorString("Unable to set SO_REUSEADDR"));
                    }
                    catch (Throwable throwable) {
                        Unistd.close(fd);
                        throw throwable;
                    }
                }
            }
            if (Platform.includedIn(DeprecatedPlatform.LINUX_SUBSTITUTION.class) && type == Socket.SOCK_DGRAM()) {
                int level;
                arg_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
                arg_Pointer.write(0);
                int n = level = domain == Socket.AF_INET6() ? NetinetIn.IPPROTO_IPV6() : NetinetIn.IPPROTO_IP();
                if (Socket.setsockopt(fd, level, NetinetIn.IP_MULTICAST_ALL(), (PointerBase)arg_Pointer, SizeOf.get(CIntPointer.class)) < 0 && Errno.errno() != Errno.ENOPROTOOPT()) {
                    try {
                        throw new SocketException(PosixUtils.lastErrorString("Unable to set IP_MULTICAST_ALL"));
                    }
                    catch (Throwable throwable) {
                        Unistd.close(fd);
                        throw throwable;
                    }
                }
            }
            if (Platform.includedIn(DeprecatedPlatform.LINUX_SUBSTITUTION.class) && domain == Socket.AF_INET6() && type == Socket.SOCK_DGRAM()) {
                arg_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
                arg_Pointer.write(1);
                if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_HOPS(), (PointerBase)arg_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
                    try {
                        throw new SocketException(PosixUtils.lastErrorString("Unable to set IPV6_MULTICAST_HOPS"));
                    }
                    catch (Throwable throwable) {
                        Unistd.close(fd);
                        throw throwable;
                    }
                }
            }
            return fd;
        }

        @Substitute
        static void bind0(FileDescriptor fd, boolean preferIPv6, boolean useExclBind, InetAddress addr, int port) throws IOException {
            Socket.sockaddr sa = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer sa_len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            sa_len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            int rv = 0;
            if (JavaNetNetUtilMD.NET_InetAddressToSockaddr(addr, port, sa, sa_len_Pointer, preferIPv6) != 0) {
                return;
            }
            rv = JavaNetNetUtilMD.NET_Bind(PosixUtils.getFD(fd), sa, sa_len_Pointer.read());
            if (rv != 0) {
                Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
            }
        }

        @Substitute
        static void listen(FileDescriptor fdo, int backlog) throws IOException {
            if (Target_os.listen(PosixUtils.getFD(fdo), backlog) < 0) {
                Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
            }
        }

        @Substitute
        static int getIntOption0(FileDescriptor fdo, boolean mayNeedConversion, int level, int opt) throws IOException {
            int n;
            CIntPointer result_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            Socket.linger linger2 = (Socket.linger)StackValue.get(Socket.linger.class);
            CCharPointer carg_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
            CIntPointer arglen_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            VoidPointer arg = (VoidPointer)result_Pointer;
            arglen_Pointer.write(SizeOf.get(CIntPointer.class));
            if (level == NetinetIn.IPPROTO_IP() && (opt == NetinetIn.IP_MULTICAST_TTL() || opt == NetinetIn.IP_MULTICAST_LOOP())) {
                arg = (VoidPointer)carg_Pointer;
                arglen_Pointer.write(SizeOf.get(CCharPointer.class));
            }
            if (level == Socket.SOL_SOCKET() && opt == Socket.SO_LINGER()) {
                arg = (VoidPointer)linger2;
                arglen_Pointer.write(SizeOf.get(Socket.linger.class));
            }
            if ((n = mayNeedConversion ? JavaNetNetUtilMD.NET_GetSockOpt(PosixJavaNIOSubstitutions.fdval(fdo), level, opt, (PointerBase)arg, arglen_Pointer) : Socket.getsockopt(PosixJavaNIOSubstitutions.fdval(fdo), level, opt, (PointerBase)arg, arglen_Pointer)) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("sun.nio.ch.Net.getIntOption"));
            }
            if (level == NetinetIn.IPPROTO_IP() && (opt == NetinetIn.IP_MULTICAST_TTL() || opt == NetinetIn.IP_MULTICAST_LOOP())) {
                return carg_Pointer.read();
            }
            if (level == Socket.SOL_SOCKET() && opt == Socket.SO_LINGER()) {
                return CTypeConversion.toBoolean((int)linger2.l_onoff()) ? linger2.l_linger() : -1;
            }
            return result_Pointer.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Substitute
        static void setIntOption0(FileDescriptor fdo, boolean mayNeedConversion, int level, int opt, int arg, boolean isIPv6) throws IOException {
            CIntPointer local_arg = (CIntPointer)StackValue.get(CIntPointer.class);
            local_arg.write(arg);
            Socket.linger linger2 = (Socket.linger)StackValue.get(Socket.linger.class);
            CCharPointer carg_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
            WordPointer parg = (WordPointer)local_arg;
            long arglen = SizeOf.get(CIntPointer.class);
            if (level == NetinetIn.IPPROTO_IP() && (opt == NetinetIn.IP_MULTICAST_TTL() || opt == NetinetIn.IP_MULTICAST_LOOP())) {
                parg = (WordPointer)carg_Pointer;
                arglen = SizeOf.get(CCharPointer.class);
                carg_Pointer.write((byte)arg);
            }
            if (level == Socket.SOL_SOCKET() && opt == Socket.SO_LINGER()) {
                parg = (WordPointer)linger2;
                arglen = SizeOf.get(Socket.linger.class);
                if (arg >= 0) {
                    linger2.set_l_onoff(1);
                    linger2.set_l_linger(arg);
                } else {
                    linger2.set_l_onoff(0);
                    linger2.set_l_linger(0);
                }
            }
            int n = mayNeedConversion ? JavaNetNetUtilMD.NET_SetSockOpt(PosixJavaNIOSubstitutions.fdval(fdo), level, opt, parg, (int)arglen) : Socket.setsockopt(PosixJavaNIOSubstitutions.fdval(fdo), level, opt, (PointerBase)parg, (int)arglen);
            try {
                if (n < 0) {
                    throw new SocketException(PosixUtils.lastErrorString("sun.nio.ch.Net.setIntOption"));
                }
            }
            finally {
                if (IsDefined.__linux__() && level == NetinetIn.IPPROTO_IPV6() && opt == NetinetIn.IPV6_TCLASS() && isIPv6) {
                    Socket.setsockopt(PosixJavaNIOSubstitutions.fdval(fdo), NetinetIn.IPPROTO_IP(), NetinetIn.IP_TOS(), (PointerBase)parg, (int)arglen);
                }
            }
        }

        @Substitute
        static void shutdown(FileDescriptor fdo, int jhow) throws IOException {
            int how;
            int n = jhow == 0 ? 0 : (how = jhow == 1 ? 1 : 2);
            if (Socket.shutdown(PosixJavaNIOSubstitutions.fdval(fdo), how) < 0 && Errno.errno() != Errno.ENOTCONN()) {
                Util_sun_nio_ch_Net.handleSocketError(Errno.errno());
            }
        }
    }

    static final class Util_sun_nio_ch_IOUtil {
        Util_sun_nio_ch_IOUtil() {
        }

        static int configureBlocking(int fd, boolean blocking) {
            int flags = Fcntl.fcntl(fd, Fcntl.F_GETFL());
            int newflags = blocking ? flags & ~Fcntl.O_NONBLOCK() : flags | Fcntl.O_NONBLOCK();
            return flags == newflags ? 0 : Fcntl.fcntl(fd, Fcntl.F_SETFL(), newflags);
        }
    }

    @TargetClass(className="sun.nio.ch.IOUtil")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_IOUtil {
        Target_sun_nio_ch_IOUtil() {
        }

        @Substitute
        private static boolean randomBytes(byte[] someBytes) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static int fdVal(FileDescriptor fd) {
            return PosixUtils.getFD(fd);
        }

        @Substitute
        private static void setfdVal(FileDescriptor fd, int value) {
            PosixUtils.setFD(fd, value);
        }

        @Substitute
        private static void configureBlocking(FileDescriptor fdo, boolean blocking) throws IOException {
            if (Util_sun_nio_ch_IOUtil.configureBlocking(PosixJavaNIOSubstitutions.fdval(fdo), blocking) < 0) {
                throw PosixUtils.newIOExceptionWithLastError("Configure blocking failed");
            }
        }

        @Substitute
        private static long makePipe(boolean blocking) throws IOException {
            CIntPointer fd = (CIntPointer)StackValue.get((int)2, CIntPointer.class);
            if (Unistd.pipe(fd) < 0) {
                throw PosixUtils.newIOExceptionWithLastError("Pipe failed");
            }
            if (!(blocking || Util_sun_nio_ch_IOUtil.configureBlocking(fd.read(0), false) >= 0 && Util_sun_nio_ch_IOUtil.configureBlocking(fd.read(1), false) >= 0)) {
                try {
                    throw PosixUtils.newIOExceptionWithLastError("Configure blocking failed");
                }
                catch (Throwable throwable) {
                    Unistd.close(fd.read(0));
                    Unistd.close(fd.read(1));
                    throw throwable;
                }
            }
            return (long)fd.read(0) << 32 | (long)fd.read(1);
        }

        @Substitute
        private static boolean drain(int fd) throws IOException {
            int n;
            int bufsize = 128;
            CCharPointer buf = (CCharPointer)StackValue.get((int)128, CCharPointer.class);
            int tn = 0;
            do {
                n = (int)Unistd.read(fd, (PointerBase)buf, WordFactory.unsigned((int)128)).rawValue();
                tn += n;
                if (n >= 0 || Errno.errno() == Errno.EAGAIN()) continue;
                throw PosixUtils.newIOExceptionWithLastError("Drain");
            } while (n == 128);
            return tn > 0;
        }

        @Substitute
        @TargetElement(onlyWith={JDK11OrLater.class})
        static int drain1(int fd) throws IOException {
            CCharPointer bufPointer = (CCharPointer)StackValue.get((int)1, CCharPointer.class);
            int res = (int)Unistd.read(fd, (PointerBase)bufPointer, WordFactory.unsigned((int)1)).rawValue();
            if (res < 0) {
                if (Errno.errno() == Errno.EAGAIN() || Errno.errno() == Errno.EWOULDBLOCK()) {
                    res = 0;
                } else {
                    if (Errno.errno() == Errno.EINTR()) {
                        return Target_sun_nio_ch_IOStatus.IOS_INTERRUPTED;
                    }
                    throw PosixUtils.newIOExceptionWithLastError("read");
                }
            }
            return res;
        }

        @Substitute
        private static int iovMax() {
            long iovmax = Unistd.sysconf(Unistd._SC_IOV_MAX());
            if (iovmax == -1L) {
                iovmax = 16L;
            }
            return (int)iovmax;
        }

        @Substitute
        private static int fdLimit() throws IOException {
            Resource.rlimit rlp = (Resource.rlimit)StackValue.get(Resource.rlimit.class);
            if (Resource.getrlimit(Resource.RLIMIT_NOFILE(), rlp) < 0) {
                throw PosixUtils.newIOExceptionWithLastError("getrlimit failed");
            }
            if (rlp.rlim_max().belowThan(0) || rlp.rlim_max().aboveThan(Integer.MAX_VALUE)) {
                return Integer.MAX_VALUE;
            }
            return (int)rlp.rlim_max().rawValue();
        }
    }

    @TargetClass(className="sun.nio.ch.NativeThread")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_NativeThread {
        Target_sun_nio_ch_NativeThread() {
        }

        @Substitute
        static long current() {
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                return Pthread.pthread_self().rawValue();
            }
            return -1L;
        }

        @Substitute
        private static void signal(long thread) throws IOException {
            int ret;
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue() && (ret = PosixInterruptSignalUtils.interruptPThread((Pthread.pthread_t)WordFactory.pointer((long)thread))) != 0) {
                throw PosixUtils.newIOExceptionWithLastError("Thread signal failed");
            }
        }

        @Substitute
        private static void init() throws IOException {
            PosixInterruptSignalUtils.ensureInitialized();
        }
    }

    @TargetClass(className="sun.nio.fs.Cancellable")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_fs_Cancellable {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Manual)
        private long pollingAddress;

        Target_sun_nio_fs_Cancellable() {
        }
    }

    @TargetClass(className="sun.nio.ch.FileDispatcher")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    static final class Target_sun_nio_ch_FileDispatcher {
        @Alias
        @TargetElement(name="NO_LOCK")
        protected static int FD_NO_LOCK;
        @Alias
        @TargetElement(name="LOCKED")
        protected static int FD_LOCKED;
        @Alias
        @TargetElement(name="RET_EX_LOCK")
        protected static int FD_RET_EX_LOCK;
        @Alias
        @TargetElement(name="INTERRUPTED")
        protected static int FD_INTERRUPTED;

        Target_sun_nio_ch_FileDispatcher() {
        }
    }

    @TargetClass(className="sun.nio.ch.IOStatus")
    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    public static final class Target_sun_nio_ch_IOStatus {
        @Alias
        @TargetElement(name="EOF")
        public static int IOS_EOF;
        @Alias
        @TargetElement(name="UNAVAILABLE")
        public static int IOS_UNAVAILABLE;
        @Alias
        @TargetElement(name="INTERRUPTED")
        public static int IOS_INTERRUPTED;
        @Alias
        @TargetElement(name="UNSUPPORTED")
        public static int IOS_UNSUPPORTED;
        @Alias
        @TargetElement(name="THROWN")
        public static int IOS_THROWN;
        @Alias
        @TargetElement(name="UNSUPPORTED_CASE")
        public static int IOS_UNSUPPORTED_CASE;
    }
}

