/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class DirectSubstrateObjectConstant
extends SubstrateObjectConstant {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final AtomicReferenceFieldUpdater<DirectSubstrateObjectConstant, Object> ROOT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DirectSubstrateObjectConstant.class, Object.class, "root");
    private final Object object;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private volatile Object root;

    DirectSubstrateObjectConstant(Object object, boolean compressed) {
        super(compressed);
        this.object = object;
        assert (object != null);
        if (SubstrateUtil.isInLibgraal()) {
            throw new InternalError();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Object getObject() {
        return this.object;
    }

    @Override
    public ResolvedJavaType getType(MetaAccessProvider provider) {
        return provider.lookupJavaType(this.object.getClass());
    }

    @Override
    public SubstrateObjectConstant compress() {
        assert (!this.compressed);
        return new DirectSubstrateObjectConstant(this.object, true);
    }

    @Override
    public SubstrateObjectConstant uncompress() {
        assert (this.compressed);
        return new DirectSubstrateObjectConstant(this.object, false);
    }

    @Override
    public boolean setRoot(Object newRoot) {
        if (this.root == null && newRoot != null) {
            return ROOT_UPDATER.compareAndSet(this, null, newRoot);
        }
        return false;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    protected int getIdentityHashCode() {
        return System.identityHashCode(this.object);
    }

    public String toValueString() {
        Object obj = KnownIntrinsics.convertUnknownValue(this.object, Object.class);
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.getClass().getName();
    }
}

