/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.genscavenge.RuntimeCodeCacheReachabilityAnalyzer;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public class RuntimeCodeCacheWalker
implements RuntimeCodeCache.CodeInfoVisitor {
    private final RuntimeCodeCacheReachabilityAnalyzer checkForUnreachableObjectsVisitor = new RuntimeCodeCacheReachabilityAnalyzer();
    private final ObjectReferenceVisitor greyToBlackObjectVisitor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeCacheWalker(ObjectReferenceVisitor greyToBlackObjectVisitor) {
        this.greyToBlackObjectVisitor = greyToBlackObjectVisitor;
    }

    @Override
    public <T extends CodeInfo> boolean visitCode(T codeInfo) {
        Object tether = UntetheredCodeInfoAccess.getTetherUnsafe(codeInfo);
        if (tether != null && !RuntimeCodeCacheWalker.isReachable(tether)) {
            if (CodeInfoAccess.getState(codeInfo) == 3) {
                return true;
            }
            if (this.referencesUnreachableObjects(codeInfo)) {
                this.referencesUnreachableObjects(codeInfo);
                RuntimeCodeInfoAccess.walkObjectFields(codeInfo, this.greyToBlackObjectVisitor);
                CodeInfoAccess.setState(codeInfo, 2);
                return true;
            }
        }
        RuntimeCodeInfoAccess.walkStrongReferences(codeInfo, this.greyToBlackObjectVisitor);
        RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.greyToBlackObjectVisitor);
        return true;
    }

    private static boolean isReachable(Object possiblyForwardedObject) {
        return RuntimeCodeCacheReachabilityAnalyzer.isReachable((Pointer)Word.objectToUntrackedPointer((Object)possiblyForwardedObject));
    }

    private boolean referencesUnreachableObjects(CodeInfo codeInfo) {
        this.checkForUnreachableObjectsVisitor.initialize();
        RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.checkForUnreachableObjectsVisitor);
        return this.checkForUnreachableObjectsVisitor.hasUnreachableObjects();
    }
}

