/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.NativeImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Queue;
import org.graalvm.compiler.options.OptionType;

class DefaultOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private static final String verboseOption = "--verbose";
    private static final String requireValidJarFileMessage = "-jar requires a valid jarfile";
    private static final String newStyleClasspathOptionName = "--class-path";
    static final String helpText = NativeImage.getResource("/Help.txt");
    static final String helpExtraText = NativeImage.getResource("/HelpExtra.txt");
    static final String noServerOption = "--no-server";
    static final String verboseServerOption = "--verbose-server";
    static final String serverOptionPrefix = "--server-";
    boolean useDebugAttach = false;

    DefaultOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
    }

    private static void singleArgumentCheck(Queue<String> args, String arg) {
        if (!args.isEmpty()) {
            NativeImage.showError("Option " + arg + " cannot be combined with other options.");
        }
    }

    @Override
    public boolean consume(Queue<String> args) {
        String headArg;
        switch (headArg = args.peek()) {
            case "--help": {
                args.poll();
                DefaultOptionHandler.singleArgumentCheck(args, headArg);
                this.nativeImage.showMessage(helpText);
                this.nativeImage.showNewline();
                this.nativeImage.apiOptionHandler.printOptions(this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                this.nativeImage.optionRegistry.showOptions(null, true, this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                System.exit(0);
                return true;
            }
            case "--version": {
                args.poll();
                DefaultOptionHandler.singleArgumentCheck(args, headArg);
                String message = "GraalVM Version " + NativeImage.graalvmVersion;
                if (!NativeImage.graalvmConfig.isEmpty()) {
                    message = message + " " + NativeImage.graalvmConfig;
                }
                message = message + " (Java Version " + System.getProperty("java.version") + ")";
                this.nativeImage.showMessage(message);
                System.exit(0);
                return true;
            }
            case "--help-extra": {
                args.poll();
                DefaultOptionHandler.singleArgumentCheck(args, headArg);
                this.nativeImage.showMessage(helpExtraText);
                this.nativeImage.optionRegistry.showOptions(MacroOption.MacroOptionKind.Macro, true, this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                System.exit(0);
                return true;
            }
            case "-cp": 
            case "-classpath": 
            case "--class-path": {
                args.poll();
                String cpArgs = args.poll();
                if (cpArgs == null) {
                    NativeImage.showError(headArg + " requires class path specification");
                }
                this.processClasspathArgs(cpArgs);
                return true;
            }
            case "--configurations-path": {
                args.poll();
                String configPath = args.poll();
                if (configPath == null) {
                    NativeImage.showError(headArg + " requires a " + File.pathSeparator + " separated list of directories");
                }
                for (String configDir : configPath.split(File.pathSeparator)) {
                    this.nativeImage.addMacroOptionRoot(this.nativeImage.canonicalize(Paths.get(configDir, new String[0])));
                }
                return true;
            }
            case "-jar": {
                args.poll();
                String jarFilePathStr = args.poll();
                if (jarFilePathStr == null) {
                    NativeImage.showError(requireValidJarFileMessage);
                }
                this.handleJarFileArg(this.nativeImage.canonicalize(Paths.get(jarFilePathStr, new String[0])));
                this.nativeImage.setJarOptionMode(true);
                return true;
            }
            case "--verbose": {
                args.poll();
                this.nativeImage.setVerbose(true);
                return true;
            }
            case "--dry-run": {
                args.poll();
                this.nativeImage.setDryRun(true);
                return true;
            }
            case "--expert-options": {
                args.poll();
                this.nativeImage.setPrintFlagsOptionQuery(OptionType.User.name());
                return true;
            }
            case "--expert-options-all": {
                args.poll();
                this.nativeImage.setPrintFlagsOptionQuery("");
                return true;
            }
            case "--expert-options-detail": {
                args.poll();
                String optionNames = args.poll();
                this.nativeImage.setPrintFlagsWithExtraHelpOptionQuery(optionNames);
                return true;
            }
            case "--no-server": 
            case "--verbose-server": {
                args.poll();
                NativeImage.showWarning("Ignoring server-mode native-image argument " + headArg + ".");
                return true;
            }
        }
        String debugAttach = "--debug-attach";
        if (headArg.startsWith(debugAttach)) {
            if (this.useDebugAttach) {
                throw NativeImage.showError("The " + debugAttach + " option can only be used once.");
            }
            this.useDebugAttach = true;
            String debugAttachArg = args.poll();
            String addressSuffix = debugAttachArg.substring(debugAttach.length());
            String address = addressSuffix.isEmpty() ? "8000" : addressSuffix.substring(1);
            this.nativeImage.addImageBuilderJavaArgs("-agentlib:jdwp=transport=dt_socket,server=y,address=" + address + ",suspend=y");
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHDeadlockWatchdogInterval + "0");
            return true;
        }
        String singleArgClasspathPrefix = "--class-path=";
        if (headArg.startsWith(singleArgClasspathPrefix)) {
            String cpArgs = args.poll().substring(singleArgClasspathPrefix.length());
            if (cpArgs.isEmpty()) {
                NativeImage.showError(headArg + " requires class path specification");
            }
            this.processClasspathArgs(cpArgs);
            return true;
        }
        if (headArg.startsWith("-H:") || headArg.startsWith("-R:")) {
            args.poll();
            this.nativeImage.addCustomImageBuilderArgs(headArg);
            return true;
        }
        String javaArgsPrefix = "-D";
        if (headArg.startsWith(javaArgsPrefix)) {
            args.poll();
            this.nativeImage.addCustomJavaArgs(headArg);
            return true;
        }
        String optionKeyPrefix = "-V";
        if (headArg.startsWith(optionKeyPrefix)) {
            args.poll();
            String keyValueStr = headArg.substring(optionKeyPrefix.length());
            String[] keyValue = keyValueStr.split("=");
            if (keyValue.length != 2) {
                throw NativeImage.showError("Use " + optionKeyPrefix + "<key>=<value>");
            }
            this.nativeImage.addOptionKeyValue(keyValue[0], keyValue[1]);
            return true;
        }
        if (headArg.startsWith("-J")) {
            args.poll();
            if (headArg.equals("-J")) {
                NativeImage.showError("The -J option should not be followed by a space");
            } else {
                this.nativeImage.addCustomJavaArgs(headArg.substring(2));
            }
            return true;
        }
        String optimizeOption = "-O";
        if (headArg.startsWith(optimizeOption)) {
            args.poll();
            if (headArg.equals(optimizeOption)) {
                NativeImage.showError("The " + optimizeOption + " option should not be followed by a space");
            } else {
                this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHOptimize + headArg.substring(2));
            }
            return true;
        }
        if (headArg.startsWith(serverOptionPrefix)) {
            args.poll();
            NativeImage.showWarning("Ignoring server-mode native-image argument " + headArg + ".");
            return true;
        }
        return false;
    }

    private void processClasspathArgs(String cpArgs) {
        for (String cp : cpArgs.split(File.pathSeparator, Integer.MAX_VALUE)) {
            String cpEntry = cp.isEmpty() ? "." : cp;
            this.nativeImage.addCustomImageClasspath(cpEntry);
        }
    }

    private void handleJarFileArg(Path filePath) {
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            NativeImage.showError(filePath + " is a directory. (" + requireValidJarFileMessage + ")");
        }
        if (!NativeImage.processJarManifestMainAttributes(filePath, this.nativeImage::handleMainClassAttribute)) {
            NativeImage.showError("No manifest in " + filePath);
        }
        this.nativeImage.addCustomImageClasspath(filePath);
    }

    @Override
    void addFallbackBuildArgs(List<String> buildArgs) {
        if (this.nativeImage.isVerbose()) {
            buildArgs.add(verboseOption);
        }
    }
}

