/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.config.SignatureUtil;
import java.util.Objects;

public class MethodInfo {
    private final String name;
    private final String signature;
    private final String declaringClassName;

    public MethodInfo(String name, String signature, String declaringClassName) {
        this.name = name;
        this.signature = signature;
        this.declaringClassName = declaringClassName;
    }

    public String getJavaMethodNameAndSignature() {
        String[] parameterTypes = SignatureUtil.toParameterTypes(this.signature);
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("(");
        boolean first = false;
        for (String parameterType : parameterTypes) {
            if (!first) {
                first = true;
            } else {
                sb.append(",");
            }
            sb.append(parameterType);
        }
        sb.append(")");
        return sb.toString();
    }

    public String getJavaDeclaringClassName() {
        return this.declaringClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInfo that = (MethodInfo)o;
        return this.name.equals(that.name) && this.signature.equals(that.signature) && this.declaringClassName.equals(that.declaringClassName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.signature, this.declaringClassName);
    }

    public String toString() {
        return this.getJavaDeclaringClassName() + "#" + this.getJavaMethodNameAndSignature();
    }
}

