/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.command;

import com.oracle.svm.configure.ConfigurationTool;
import com.oracle.svm.configure.command.ConfigurationCommand;
import java.util.Collection;
import java.util.Iterator;

public class ConfigurationHelpCommand
extends ConfigurationCommand {
    @Override
    public String getName() {
        return "help";
    }

    @Override
    public void apply(Iterator<String> argumentsIterator) {
        Collection<ConfigurationCommand> commands = ConfigurationTool.getCommands();
        System.out.println();
        System.out.println(this.getToolName());
        System.out.println();
        System.out.println(this.getToolDescription());
        System.out.println();
        System.out.print("Usage: ");
        commands.forEach(command -> System.out.println(command.getUsage()));
        System.out.println();
        commands.forEach(command -> System.out.println(command.getDescription()));
    }

    @Override
    public String getUsage() {
        return "native-image-configure help";
    }

    @Override
    protected String getDescription0() {
        return "                      prints this help message." + System.lineSeparator();
    }

    protected String getToolName() {
        return "GraalVM native-image-configure tool";
    }

    protected String getToolDescription() {
        return "This tool can be used to prepare a configuration of JNI, reflection and" + System.lineSeparator() + "resources for a native-image build.";
    }
}

