/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public abstract class ForeignConfigurationParser<FD, LO>
extends ConfigurationParser {
    private static final String PARAMETER_TYPES = "parameterTypes";
    private static final String RETURN_TYPE = "returnType";

    public ForeignConfigurationParser(EnumSet<ConfigurationParserOption> parserOptions) {
        super(parserOptions);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        Object foreignJson = this.getFromGlobalFile(json, "foreign");
        if (foreignJson == null) {
            return;
        }
        EconomicMap<String, Object> topLevel = ForeignConfigurationParser.asMap(foreignJson, "first level of document must be a map");
        this.checkAttributes(topLevel, "foreign methods categories", List.of(), List.of("downcalls", "upcalls", "directUpcalls"));
        List<Object> downcalls = ForeignConfigurationParser.asList(topLevel.get((Object)"downcalls", List.of()), "downcalls must be an array of function descriptor and linker options");
        for (Object object : downcalls) {
            this.parseAndRegisterForeignCall(object, false);
        }
        List<Object> upcalls = ForeignConfigurationParser.asList(topLevel.get((Object)"upcalls", List.of()), "upcalls must be an array of function descriptor and linker options");
        for (Object upcall : upcalls) {
            this.parseAndRegisterForeignCall(upcall, true);
        }
        List<Object> list = ForeignConfigurationParser.asList(topLevel.get((Object)"directUpcalls", List.of()), "direct upcalls must be an array of method references, function descriptors, and linker options");
        for (Object upcall : list) {
            this.parseAndRegisterDirectUpcall(upcall);
        }
    }

    private void parseAndRegisterForeignCall(Object call, boolean forUpcall) {
        EconomicMap<String, Object> map = ForeignConfigurationParser.asMap(call, "a foreign call must be a map");
        this.checkAttributes(map, "foreign call", List.of(RETURN_TYPE, PARAMETER_TYPES), List.of("options"));
        FD descriptor = this.createFunctionDescriptor(map);
        EconomicMap<String, Object> optionsMap = ForeignConfigurationParser.asMap(map.get((Object)"options", (Object)EconomicMap.emptyMap()), "options must be a map");
        if (forUpcall) {
            LO upcallOptions = this.createUpcallOptions(optionsMap, descriptor);
            try {
                this.registerUpcall(ConfigurationCondition.alwaysTrue(), descriptor, upcallOptions);
            }
            catch (Exception e) {
                this.handleRegistrationError(e, map);
            }
        } else {
            LO downcallOptions = this.createDowncallOptions(optionsMap, descriptor);
            try {
                this.registerDowncall(ConfigurationCondition.alwaysTrue(), descriptor, downcallOptions);
            }
            catch (Exception e) {
                this.handleRegistrationError(e, map);
            }
        }
    }

    private void parseAndRegisterDirectUpcall(Object call) {
        EconomicMap<String, Object> map = ForeignConfigurationParser.asMap(call, "a foreign call must be a map");
        this.checkAttributes(map, "foreign call", List.of("class", "method"), List.of(RETURN_TYPE, PARAMETER_TYPES, "options"));
        String className = ForeignConfigurationParser.asString(map.get((Object)"class"), "class");
        String methodName = ForeignConfigurationParser.asString(map.get((Object)"method"), "method");
        Object returnTypeInput = map.get((Object)RETURN_TYPE);
        Object parameterTypesInput = map.get((Object)PARAMETER_TYPES);
        EconomicMap<String, Object> optionsMap = ForeignConfigurationParser.asMap(map.get((Object)"options", (Object)EconomicMap.emptyMap()), "options must be a map");
        if (returnTypeInput != null || parameterTypesInput != null) {
            FD descriptor = this.createFunctionDescriptor(map);
            LO upcallOptions = this.createUpcallOptions(optionsMap, descriptor);
            try {
                this.registerDirectUpcallWithDescriptor(className, methodName, descriptor, upcallOptions);
            }
            catch (Exception e) {
                this.handleRegistrationError(e, map);
            }
        } else {
            try {
                this.registerDirectUpcallWithoutDescriptor(className, methodName, optionsMap);
            }
            catch (Exception e) {
                this.handleRegistrationError(e, map);
            }
        }
    }

    private FD createFunctionDescriptor(EconomicMap<String, Object> map) {
        String returnTypeInput = ForeignConfigurationParser.asString(map.get((Object)RETURN_TYPE), RETURN_TYPE);
        List<Object> tmpParameterTypes = ForeignConfigurationParser.asList(map.get((Object)PARAMETER_TYPES), "Element 'parameterTypes' must be a list");
        String[] parameterTypes = new String[tmpParameterTypes.size()];
        for (int i = 0; i < tmpParameterTypes.size(); ++i) {
            parameterTypes[i] = ForeignConfigurationParser.asString(tmpParameterTypes.get(i), String.format("%s[%d]", PARAMETER_TYPES, i));
        }
        return this.createFunctionDescriptor(returnTypeInput, List.of(parameterTypes));
    }

    protected abstract FD createFunctionDescriptor(String var1, List<String> var2);

    protected abstract LO createDowncallOptions(EconomicMap<String, Object> var1, FD var2);

    protected abstract LO createUpcallOptions(EconomicMap<String, Object> var1, FD var2);

    protected abstract void registerDowncall(ConfigurationCondition var1, FD var2, LO var3);

    protected abstract void registerUpcall(ConfigurationCondition var1, FD var2, LO var3);

    protected abstract void registerDirectUpcallWithoutDescriptor(String var1, String var2, EconomicMap<String, Object> var3);

    protected abstract void registerDirectUpcallWithDescriptor(String var1, String var2, FD var3, LO var4);

    protected abstract void handleRegistrationError(Exception var1, EconomicMap<String, Object> var2);
}

