/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import jdk.vm.ci.meta.JavaKind;

public class ClassNameSupport {
    public static String reflectionNameToTypeName(String reflectionName) {
        if (!ClassNameSupport.isValidReflectionName(reflectionName)) {
            return reflectionName;
        }
        return ClassNameSupport.reflectionNameToTypeNameUnchecked(reflectionName);
    }

    public static String jniNameToTypeName(String jniName) {
        if (!ClassNameSupport.isValidJNIName(jniName)) {
            return jniName;
        }
        return ClassNameSupport.reflectionNameToTypeNameUnchecked(ClassNameSupport.jniNameToReflectionNameUnchecked(jniName));
    }

    private static String reflectionNameToTypeNameUnchecked(String reflectionName) {
        int arrayDimension = ClassNameSupport.wrappingArrayDimension(reflectionName);
        if (arrayDimension > 0) {
            return ClassNameSupport.arrayElementTypeToTypeName(reflectionName, arrayDimension) + "[]".repeat(arrayDimension);
        }
        return reflectionName;
    }

    public static String typeNameToReflectionName(String typeName) {
        if (!ClassNameSupport.isValidTypeName(typeName)) {
            return typeName;
        }
        return ClassNameSupport.typeNameToReflectionNameUnchecked(typeName);
    }

    public static String typeNameToJNIName(String typeName) {
        if (!ClassNameSupport.isValidTypeName(typeName)) {
            return typeName;
        }
        return ClassNameSupport.reflectionNameToJNINameUnchecked(ClassNameSupport.typeNameToReflectionNameUnchecked(typeName));
    }

    private static String typeNameToReflectionNameUnchecked(String typeName) {
        int arrayDimension = ClassNameSupport.trailingArrayDimension(typeName);
        if (arrayDimension > 0) {
            return "[".repeat(arrayDimension) + ClassNameSupport.typeNameToArrayElementType(typeName.substring(0, typeName.length() - arrayDimension * 2));
        }
        return typeName;
    }

    public static String jniNameToReflectionName(String jniName) {
        if (!ClassNameSupport.isValidJNIName(jniName)) {
            return jniName;
        }
        return ClassNameSupport.jniNameToReflectionNameUnchecked(jniName);
    }

    private static String jniNameToReflectionNameUnchecked(String jniName) {
        return jniName.replace('/', '.');
    }

    public static String reflectionNameToJNIName(String reflectionName) {
        if (!ClassNameSupport.isValidReflectionName(reflectionName)) {
            return reflectionName;
        }
        return ClassNameSupport.reflectionNameToJNINameUnchecked(reflectionName);
    }

    private static String reflectionNameToJNINameUnchecked(String reflectionName) {
        return reflectionName.replace('.', '/');
    }

    public static String getArrayReflectionName(String componentReflectionName) {
        if (!ClassNameSupport.isValidReflectionName(componentReflectionName)) {
            return componentReflectionName;
        }
        return "[" + (ClassNameSupport.wrappingArrayDimension(componentReflectionName) > 0 ? componentReflectionName : ClassNameSupport.typeNameToArrayElementType(componentReflectionName));
    }

    private static String arrayElementTypeToTypeName(String arrayElementType, int startIndex) {
        char typeChar = arrayElementType.charAt(startIndex);
        return switch (typeChar) {
            case 'L' -> arrayElementType.substring(startIndex + 1, arrayElementType.length() - 1);
            case 'B', 'C', 'D', 'F', 'I', 'J', 'S', 'Z' -> JavaKind.fromPrimitiveOrVoidTypeChar((char)typeChar).getJavaName();
            default -> null;
        };
    }

    private static String typeNameToArrayElementType(String typeName) {
        Class<?> primitiveType = ClassNameSupport.forPrimitiveName(typeName);
        if (primitiveType != null) {
            return String.valueOf(JavaKind.fromJavaClass(primitiveType).getTypeChar());
        }
        return "L" + typeName + ";";
    }

    public static boolean isValidTypeName(String name) {
        return ClassNameSupport.isValidFullyQualifiedClassName(name, 0, name.length() - ClassNameSupport.trailingArrayDimension(name) * 2, '.');
    }

    public static boolean isValidReflectionName(String name) {
        return ClassNameSupport.isValidWrappingArraySyntaxName(name, '.');
    }

    public static boolean isValidJNIName(String name) {
        return ClassNameSupport.isValidWrappingArraySyntaxName(name, '/');
    }

    private static boolean isValidWrappingArraySyntaxName(String name, char packageSeparator) {
        int arrayDimension = ClassNameSupport.wrappingArrayDimension(name);
        if (arrayDimension > 0) {
            return ClassNameSupport.isValidWrappingArrayElementType(name, arrayDimension, packageSeparator);
        }
        return ClassNameSupport.isValidFullyQualifiedClassName(name, 0, name.length(), packageSeparator);
    }

    private static boolean isValidWrappingArrayElementType(String name, int startIndex, char packageSeparator) {
        if (startIndex == name.length()) {
            return false;
        }
        return switch (name.charAt(startIndex)) {
            case 'L' -> {
                if (name.charAt(name.length() - 1) == ';' && ClassNameSupport.isValidFullyQualifiedClassName(name, startIndex + 1, name.length() - 1, packageSeparator)) {
                    yield true;
                }
                yield false;
            }
            case 'B', 'C', 'D', 'F', 'I', 'J', 'S', 'Z' -> {
                if (startIndex == name.length() - 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isValidFullyQualifiedClassName(String name, int startIndex, int endIndex, char packageSeparator) {
        int lastPackageSeparatorIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            char current = name.charAt(i);
            if (current == packageSeparator) {
                if (lastPackageSeparatorIndex == i - 1) {
                    return false;
                }
                lastPackageSeparatorIndex = i;
                continue;
            }
            if (current != '.' && current != ';' && current != '[' && current != '/') continue;
            return false;
        }
        return true;
    }

    private static int wrappingArrayDimension(String name) {
        int arrayDimension;
        for (arrayDimension = 0; arrayDimension < name.length() && name.charAt(arrayDimension) == '['; ++arrayDimension) {
        }
        return arrayDimension;
    }

    private static int trailingArrayDimension(String name) {
        int arrayDimension = 0;
        while (ClassNameSupport.endsWithTrailingArraySyntax(name, name.length() - arrayDimension * 2)) {
            ++arrayDimension;
        }
        return arrayDimension;
    }

    private static boolean endsWithTrailingArraySyntax(String string, int endIndex) {
        return endIndex >= "[]".length() && string.charAt(endIndex - 2) == '[' && string.charAt(endIndex - 1) == ']';
    }

    public static Class<?> forPrimitiveName(String primitiveName) {
        return switch (primitiveName) {
            case "int" -> Integer.TYPE;
            case "long" -> Long.TYPE;
            case "short" -> Short.TYPE;
            case "char" -> Character.TYPE;
            case "byte" -> Byte.TYPE;
            case "float" -> Float.TYPE;
            case "double" -> Double.TYPE;
            case "boolean" -> Boolean.TYPE;
            case "void" -> Void.TYPE;
            default -> null;
        };
    }
}

