/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shaded.org.capnproto;

import com.oracle.svm.shaded.org.capnproto.BufferedInputStream;
import com.oracle.svm.shaded.org.capnproto.BufferedInputStreamWrapper;
import com.oracle.svm.shaded.org.capnproto.BufferedOutputStream;
import com.oracle.svm.shaded.org.capnproto.BufferedOutputStreamWrapper;
import com.oracle.svm.shaded.org.capnproto.MessageBuilder;
import com.oracle.svm.shaded.org.capnproto.MessageReader;
import com.oracle.svm.shaded.org.capnproto.PackedInputStream;
import com.oracle.svm.shaded.org.capnproto.PackedOutputStream;
import com.oracle.svm.shaded.org.capnproto.ReaderOptions;
import com.oracle.svm.shaded.org.capnproto.Serialize;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;

public final class SerializePacked {
    public static Optional<MessageReader> tryRead(BufferedInputStream input) throws IOException {
        return SerializePacked.tryRead(input, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static Optional<MessageReader> tryRead(BufferedInputStream input, ReaderOptions options) throws IOException {
        PackedInputStream packedInput = new PackedInputStream(input);
        return Serialize.tryRead(packedInput, options);
    }

    public static MessageReader read(BufferedInputStream input) throws IOException {
        return SerializePacked.read(input, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(BufferedInputStream input, ReaderOptions options) throws IOException {
        PackedInputStream packedInput = new PackedInputStream(input);
        return Serialize.read(packedInput, options);
    }

    public static Optional<MessageReader> tryReadFromUnbuffered(ReadableByteChannel input) throws IOException {
        return SerializePacked.tryReadFromUnbuffered(input, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static Optional<MessageReader> tryReadFromUnbuffered(ReadableByteChannel input, ReaderOptions options) throws IOException {
        PackedInputStream packedInput = new PackedInputStream(new BufferedInputStreamWrapper(input));
        return Serialize.tryRead(packedInput, options);
    }

    public static MessageReader readFromUnbuffered(ReadableByteChannel input) throws IOException {
        return SerializePacked.readFromUnbuffered(input, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader readFromUnbuffered(ReadableByteChannel input, ReaderOptions options) throws IOException {
        PackedInputStream packedInput = new PackedInputStream(new BufferedInputStreamWrapper(input));
        return Serialize.read(packedInput, options);
    }

    public static void write(BufferedOutputStream output, MessageBuilder message) throws IOException {
        PackedOutputStream packedOutputStream = new PackedOutputStream(output);
        Serialize.write((WritableByteChannel)packedOutputStream, message);
    }

    public static void write(BufferedOutputStream output, MessageReader message) throws IOException {
        PackedOutputStream packedOutputStream = new PackedOutputStream(output);
        Serialize.write((WritableByteChannel)packedOutputStream, message);
    }

    public static void writeToUnbuffered(WritableByteChannel output, MessageBuilder message) throws IOException {
        BufferedOutputStreamWrapper buffered = new BufferedOutputStreamWrapper(output);
        SerializePacked.write((BufferedOutputStream)buffered, message);
        buffered.flush();
    }

    public static void writeToUnbuffered(WritableByteChannel output, MessageReader message) throws IOException {
        BufferedOutputStreamWrapper buffered = new BufferedOutputStreamWrapper(output);
        SerializePacked.write((BufferedOutputStream)buffered, message);
        buffered.flush();
    }
}

