/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shaded.org.capnproto;

import com.oracle.svm.shaded.org.capnproto.ListBuilder;
import com.oracle.svm.shaded.org.capnproto.ListFactory;
import com.oracle.svm.shaded.org.capnproto.ListReader;
import com.oracle.svm.shaded.org.capnproto.SegmentBuilder;
import com.oracle.svm.shaded.org.capnproto.SegmentReader;

public class EnumList {
    static <T> T clampOrdinal(T[] values, short ordinal) {
        int index = ordinal;
        if (ordinal < 0 || ordinal >= values.length) {
            index = values.length - 1;
        }
        return values[index];
    }

    public static final class Builder<T extends Enum>
    extends ListBuilder {
        public final T[] values;

        public Builder(T[] values, SegmentBuilder segment, int ptr, int elementCount, int step, int structDataSize, short structPointerCount) {
            super(segment, ptr, elementCount, step, structDataSize, structPointerCount);
            this.values = values;
        }

        public T get(int index) {
            return (T)((Enum)EnumList.clampOrdinal(this.values, this._getShortElement(index)));
        }

        public void set(int index, T value) {
            this._setShortElement(index, (short)((Enum)value).ordinal());
        }

        public final Reader<T> asReader() {
            return new Reader(this.values, (SegmentReader)this.segment, this.ptr, this.elementCount, this.step, this.structDataSize, this.structPointerCount, Integer.MAX_VALUE);
        }
    }

    public static final class Reader<T extends Enum>
    extends ListReader {
        public final T[] values;

        public Reader(T[] values, SegmentReader segment, int ptr, int elementCount, int step, int structDataSize, short structPointerCount, int nestingLimit) {
            super(segment, ptr, elementCount, step, structDataSize, structPointerCount, nestingLimit);
            this.values = values;
        }

        public T get(int index) {
            return (T)((Enum)EnumList.clampOrdinal(this.values, this._getShortElement(index)));
        }
    }

    public static final class Factory<T extends Enum>
    extends ListFactory<Builder<T>, Reader<T>> {
        public final T[] values;

        public Factory(T[] values) {
            super((byte)3);
            this.values = values;
        }

        @Override
        public final Reader<T> constructReader(SegmentReader segment, int ptr, int elementCount, int step, int structDataSize, short structPointerCount, int nestingLimit) {
            return new Reader(this.values, segment, ptr, elementCount, step, structDataSize, structPointerCount, nestingLimit);
        }

        @Override
        public final Builder<T> constructBuilder(SegmentBuilder segment, int ptr, int elementCount, int step, int structDataSize, short structPointerCount) {
            return new Builder(this.values, segment, ptr, elementCount, step, structDataSize, structPointerCount);
        }
    }
}

