/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.tracing;

import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.configure.ConfigurationFile;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConfigurationResultWriter
extends Tracer
implements TracingResultWriter {
    private final TraceProcessor processor;

    public ConfigurationResultWriter(TraceProcessor processor) {
        this.processor = processor;
    }

    @Override
    protected void traceEntry(Map<String, Object> entry) {
        this.processor.processEntry(ConfigurationResultWriter.arraysToLists(entry));
    }

    public static Map<String, Object> arraysToLists(Map<String, Object> map) {
        for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
            if (!(mapEntry.getValue() instanceof Object[])) continue;
            mapEntry.setValue(ConfigurationResultWriter.arraysToLists((Object[])mapEntry.getValue()));
        }
        return map;
    }

    private static List<?> arraysToLists(Object[] array) {
        Object[] newArray = Arrays.copyOf(array, array.length);
        for (int i = 0; i < newArray.length; ++i) {
            if (!(newArray[i] instanceof Object[])) continue;
            newArray[i] = ConfigurationResultWriter.arraysToLists((Object[])newArray[i]);
        }
        return Arrays.asList(newArray);
    }

    @Override
    public boolean supportsPeriodicTraceWriting() {
        return true;
    }

    @Override
    public boolean supportsOnUnloadTraceWriting() {
        return true;
    }

    @Override
    public List<Path> writeToDirectory(Path directoryPath) throws IOException {
        ArrayList<Path> writtenPaths = new ArrayList<Path>();
        for (ConfigurationFile configFile : ConfigurationFile.values()) {
            if (!configFile.canBeGeneratedByAgent()) continue;
            Path filePath = directoryPath.resolve(configFile.getFileName());
            try (JsonWriter writer = new JsonWriter(filePath, new OpenOption[0]);){
                this.processor.getConfiguration(configFile).printJson(writer);
                writer.newline();
            }
            writtenPaths.add(filePath);
        }
        return writtenPaths;
    }
}

