/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.Support;

public class ResourceAccessVerifier
extends AbstractAccessVerifier {
    private final ResourceConfiguration configuration;

    public ResourceAccessVerifier(ResourceConfiguration configuration, AccessAdvisor advisor) {
        super(advisor);
        this.configuration = configuration;
    }

    public boolean verifyGetResources(JNIEnvironment env, JNIObjectHandle name, JNIObjectHandle callerClass) {
        return this.verifyGetResources0(env, name, callerClass);
    }

    public boolean verifyGetSystemResources(JNIEnvironment env, JNIObjectHandle name, JNIObjectHandle callerClass) {
        return this.verifyGetResources0(env, name, callerClass);
    }

    private boolean verifyGetResources0(JNIEnvironment env, JNIObjectHandle name, JNIObjectHandle callerClass) {
        String resource = Support.fromJniString((JNIEnvironment)env, (JNIObjectHandle)name);
        return this.configuration.anyResourceMatches(resource);
    }

    public boolean verifyGetBundle(JNIEnvironment env, JNIObjectHandle baseName, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(LazyValueUtils.lazyNull(), ResourceAccessVerifier.lazyClassNameOrNull(env, callerClass))) {
            return true;
        }
        String bundleName = Support.fromJniString((JNIEnvironment)env, (JNIObjectHandle)baseName);
        return this.configuration.anyBundleMatches(bundleName);
    }
}

