/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonPrinter;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class ResourceConfiguration
implements JsonPrintable {
    private final ConcurrentMap<String, Pattern> addedResources = new ConcurrentHashMap<String, Pattern>();
    private final ConcurrentMap<String, Pattern> ignoredResources = new ConcurrentHashMap<String, Pattern>();
    private final ConcurrentHashMap.KeySetView<String, Boolean> bundles = ConcurrentHashMap.newKeySet();

    public void addResourcePattern(String pattern) {
        this.addedResources.computeIfAbsent(pattern, Pattern::compile);
    }

    public void ignoreResourcePattern(String pattern) {
        this.ignoredResources.computeIfAbsent(pattern, Pattern::compile);
    }

    public void addBundle(String bundle) {
        this.bundles.add(bundle);
    }

    public boolean anyResourceMatches(String s) {
        for (Pattern pattern : this.ignoredResources.values()) {
            if (!pattern.matcher(s).matches()) continue;
            return false;
        }
        for (Pattern pattern : this.addedResources.values()) {
            if (!pattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean anyBundleMatches(String s) {
        return this.bundles.contains(s);
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        writer.quote("resources").append(':').append('{').newline();
        writer.quote("includes").append(':');
        JsonPrinter.printCollection(writer, this.addedResources.keySet(), Comparator.naturalOrder(), (p, w) -> w.append('{').quote("pattern").append(':').quote((String)p).append('}'));
        if (!this.ignoredResources.isEmpty()) {
            writer.append(',').newline();
            writer.quote("excludes").append(':');
            JsonPrinter.printCollection(writer, this.ignoredResources.keySet(), Comparator.naturalOrder(), (p, w) -> w.append('{').quote("pattern").append(':').quote((String)p).append('}'));
        }
        writer.append('}').append(',').newline();
        writer.quote("bundles").append(':');
        JsonPrinter.printCollection(writer, this.bundles, Comparator.naturalOrder(), (p, w) -> w.append('{').quote("name").append(':').quote((String)p).append('}'));
        writer.unindent().newline().append('}').newline();
    }

    public static class ParserAdapter
    implements ResourcesRegistry {
        private final ResourceConfiguration configuration;

        public ParserAdapter(ResourceConfiguration configuration) {
            this.configuration = configuration;
        }

        public void addResources(String pattern) {
            this.configuration.addResourcePattern(pattern);
        }

        public void ignoreResources(String pattern) {
            this.configuration.ignoreResourcePattern(pattern);
        }

        public void addResourceBundles(String name) {
            this.configuration.addBundle(name);
        }
    }
}

