/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.NativeImageAgent;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.agent.restrict.TypeAccessChecker;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.core.util.WordPredicate;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import java.util.function.Supplier;
import org.graalvm.compiler.phases.common.LazyValue;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class ReflectAccessVerifier
extends AbstractAccessVerifier {
    private final TypeAccessChecker typeAccessChecker;
    private final NativeImageAgent agent;

    public ReflectAccessVerifier(TypeAccessChecker typeAccessChecker, AccessAdvisor advisor, NativeImageAgent agent) {
        super(advisor);
        this.typeAccessChecker = typeAccessChecker;
        this.agent = agent;
    }

    public boolean verifyForName(JNIEnvironment env, JNIObjectHandle callerClass, String className) {
        if (this.shouldApproveWithoutChecks(LazyValueUtils.lazyValue(className), ReflectAccessVerifier.lazyClassNameOrNull(env, callerClass))) {
            return true;
        }
        return className == null || this.typeAccessChecker.getConfiguration().get(className) != null;
    }

    public boolean verifyLoadClass(JNIEnvironment env, JNIObjectHandle callerClass, String className) {
        LazyValue<String> callerClassName;
        LazyValue<String> lazyName = LazyValueUtils.lazyValue(className);
        if (this.shouldApproveWithoutChecks(lazyName, callerClassName = ReflectAccessVerifier.lazyClassNameOrNull(env, callerClass))) {
            return true;
        }
        if (this.accessAdvisor.shouldIgnoreLoadClass(lazyName, callerClassName)) {
            return true;
        }
        return className == null || this.typeAccessChecker.getConfiguration().get(className) != null;
    }

    public boolean verifyGetField(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle name, JNIObjectHandle result, JNIObjectHandle declaring, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return true;
        }
        JNIFieldId field = Support.jniFunctions().getFromReflectedField().invoke(env, result);
        return field.isNull() || this.typeAccessChecker.isFieldAccessible(env, clazz, () -> Support.fromJniString((JNIEnvironment)env, (JNIObjectHandle)name), field, declaring);
    }

    public boolean verifyObjectFieldOffset(JNIEnvironment env, JNIObjectHandle name, JNIObjectHandle declaring, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, declaring, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.isFieldUnsafeAccessible(() -> Support.fromJniString((JNIEnvironment)env, (JNIObjectHandle)name), declaring);
    }

    public boolean verifyGetMethod(JNIEnvironment env, JNIObjectHandle clazz, String name, Supplier<String> signature, JNIObjectHandle result, JNIObjectHandle declaring, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return true;
        }
        JNIMethodId method = Support.jniFunctions().getFromReflectedMethod().invoke(env, result);
        return this.verifyGetMethod0(env, clazz, name, signature, method, declaring);
    }

    public boolean verifyGetConstructor(JNIEnvironment env, JNIObjectHandle clazz, Supplier<String> signature, JNIObjectHandle result, JNIObjectHandle callerClass) {
        return this.verifyGetMethod(env, clazz, "<init>", signature, result, clazz, callerClass);
    }

    public boolean verifyNewInstance(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, JNIMethodId result, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return true;
        }
        return this.verifyGetMethod0(env, clazz, name, () -> signature, result, clazz);
    }

    public boolean verifyNewArray(JNIEnvironment env, JNIObjectHandle arrayClass, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, arrayClass, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.getType(arrayClass) != null;
    }

    public boolean verifyGetEnclosingMethod(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, JNIObjectHandle result, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return true;
        }
        JNIMethodId method = Support.jniFunctions().getFromReflectedMethod().invoke(env, result);
        return method.isNull() || this.typeAccessChecker.isMethodAccessible(env, clazz, name, () -> signature, method, clazz);
    }

    private boolean verifyGetMethod0(JNIEnvironment env, JNIObjectHandle clazz, String name, Supplier<String> signature, JNIMethodId method, JNIObjectHandle declaring) {
        return method.isNull() || this.typeAccessChecker.isMethodAccessible(env, clazz, name, signature, method, declaring);
    }

    public JNIObjectHandle filterGetFields(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle array, boolean declaredOnly, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return array;
        }
        WordPredicate predicate = f -> this.shouldRetainField(env, clazz, (JNIObjectHandle)f, declaredOnly);
        return ReflectAccessVerifier.filterArray(env, array, (Support.WordSupplier<JNIObjectHandle>)((Support.WordSupplier)() -> ((NativeImageAgentJNIHandleSet)this.agent.handles()).getJavaLangReflectField(env)), (WordPredicate<JNIObjectHandle>)predicate);
    }

    public JNIObjectHandle filterGetMethods(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle array, Support.WordSupplier<JNIObjectHandle> elementClass, boolean declaredOnly, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return array;
        }
        WordPredicate predicate = m -> this.shouldRetainMethod(env, clazz, (JNIObjectHandle)m, declaredOnly);
        return ReflectAccessVerifier.filterArray(env, array, elementClass, (WordPredicate<JNIObjectHandle>)predicate);
    }

    private boolean shouldRetainMethod(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle methodObj, boolean declaredOnly) {
        JNIMethodId method = Support.jniFunctions().getFromReflectedMethod().invoke(env, methodObj);
        if (method.isNonNull() && !Support.clearException((JNIEnvironment)env)) {
            JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            if (declaredOnly) {
                declaring = clazz;
            } else {
                WordPointer declaringPtr = (WordPointer)StackValue.get(WordPointer.class);
                if (Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), method, declaringPtr) == JvmtiError.JVMTI_ERROR_NONE) {
                    declaring = (JNIObjectHandle)declaringPtr.read();
                }
            }
            if (declaring.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), method, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
                    boolean accessible = this.typeAccessChecker.isMethodAccessible(env, clazz, Support.fromCString((CCharPointer)namePtr.read()), () -> Support.fromCString((CCharPointer)signaturePtr.read()), method, declaring);
                    Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
                    Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
                    if (accessible) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static JNIObjectHandle filterArray(JNIEnvironment env, JNIObjectHandle array, Support.WordSupplier<JNIObjectHandle> elementClass, WordPredicate<JNIObjectHandle> shouldRetain) {
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        int length = Support.jniFunctions().getGetArrayLength().invoke(env, array);
        if (length > 0 && !Support.clearException((JNIEnvironment)env)) {
            int i;
            JNIObjectHandle[] newArrayContents = new JNIObjectHandle[length];
            int newLength = 0;
            for (i = 0; i < length; ++i) {
                JNIObjectHandle element = Support.jniFunctions().getGetObjectArrayElement().invoke(env, array, i);
                if (Support.clearException((JNIEnvironment)env) || !shouldRetain.test((WordBase)element)) continue;
                newArrayContents[newLength] = element;
                ++newLength;
            }
            if (newLength == length) {
                result = array;
            } else {
                result = Support.jniFunctions().getNewObjectArray().invoke(env, newLength, (JNIObjectHandle)elementClass.get(), (JNIObjectHandle)JNIObjectHandles.nullHandle());
                if (result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && !Support.clearException((JNIEnvironment)env)) {
                    for (i = 0; i < newLength; ++i) {
                        Support.jniFunctions().getSetObjectArrayElement().invoke(env, result, i, newArrayContents[i]);
                        if (!Support.clearException((JNIEnvironment)env)) continue;
                        result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                        break;
                    }
                }
            }
        }
        return result;
    }

    private boolean shouldRetainField(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle fieldObj, boolean declaredOnly) {
        JNIFieldId field = Support.jniFunctions().getFromReflectedField().invoke(env, fieldObj);
        if (field.isNonNull() && !Support.clearException((JNIEnvironment)env)) {
            Supplier<String> nameSupplier;
            JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            if (declaredOnly) {
                declaring = clazz;
            } else {
                WordPointer declaringPtr = (WordPointer)StackValue.get(WordPointer.class);
                if (Support.jvmtiFunctions().GetFieldDeclaringClass().invoke(Support.jvmtiEnv(), clazz, field, declaringPtr) == JvmtiError.JVMTI_ERROR_NONE) {
                    declaring = (JNIObjectHandle)declaringPtr.read();
                }
            }
            if (declaring.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && this.typeAccessChecker.isFieldAccessible(env, clazz, nameSupplier = () -> Support.getFieldName((JNIObjectHandle)clazz, (JNIFieldId)field), field, declaring)) {
                return true;
            }
        }
        return false;
    }
}

