/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.NativeImageAgent;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.agent.restrict.TypeAccessChecker;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.compiler.phases.common.LazyValue;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;

public class JniAccessVerifier
extends AbstractAccessVerifier {
    private final TypeAccessChecker typeAccessChecker;
    private final TypeAccessChecker reflectTypeAccessChecker;
    private final NativeImageAgent agent;

    public JniAccessVerifier(TypeAccessChecker typeAccessChecker, TypeAccessChecker reflectTypeAccessChecker, AccessAdvisor advisor, NativeImageAgent agent) {
        super(advisor);
        this.typeAccessChecker = typeAccessChecker;
        this.reflectTypeAccessChecker = reflectTypeAccessChecker;
        this.agent = agent;
    }

    public boolean verifyDefineClass(JNIEnvironment env, CCharPointer name, JNIObjectHandle loader, CCharPointer buf, int bufLen, JNIObjectHandle callerClass) {
        LazyValue<String> javaName = JniAccessVerifier.lazyConvertFindClassName(name);
        if (this.shouldApproveWithoutChecks(javaName, JniAccessVerifier.lazyClassNameOrNull(env, callerClass))) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: defining classes is not permitted: " + (String)javaName.get()));){
            Support.jniFunctions().getThrowNew().invoke(env, ((NativeImageAgentJNIHandleSet)this.agent.handles()).javaLangSecurityException, message.get());
        }
        return false;
    }

    public boolean verifyFindClass(JNIEnvironment env, CCharPointer name, JNIObjectHandle callerClass) {
        LazyValue<String> javaName = JniAccessVerifier.lazyConvertFindClassName(name);
        if (this.shouldApproveWithoutChecks(javaName, JniAccessVerifier.lazyClassNameOrNull(env, callerClass))) {
            return true;
        }
        if (javaName.get() != null && this.typeAccessChecker.getConfiguration().get((String)javaName.get()) != null) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit access to class: " + (String)javaName.get()));){
            Support.jniFunctions().getThrowNew().invoke(env, ((NativeImageAgentJNIHandleSet)this.agent.handles()).javaLangNoClassDefFoundError, message.get());
        }
        return false;
    }

    private static LazyValue<String> lazyConvertFindClassName(CCharPointer name) {
        return LazyValueUtils.lazyGet(() -> {
            String s = Support.fromCString((CCharPointer)name);
            if (s != null) {
                if (!s.startsWith("[") && s.length() > 1) {
                    s = "L" + s + ";";
                }
                try {
                    return MetaUtil.internalNameToJava((String)s, (boolean)true, (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    public boolean verifyGetMethodID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer cname, CCharPointer csignature, JNIMethodId result, JNIObjectHandle callerClass) {
        JNIObjectHandle declaring;
        LazyValue<String> callerClassName;
        LazyValue<String> clazzName = JniAccessVerifier.lazyClassNameOrNull(env, clazz);
        if (this.shouldApproveWithoutChecks(clazzName, callerClassName = JniAccessVerifier.lazyClassNameOrNull(env, callerClass))) {
            return true;
        }
        assert (result.isNonNull());
        String name = Support.fromCString((CCharPointer)cname);
        if (this.accessAdvisor.shouldIgnoreJniMethodLookup(clazzName, LazyValueUtils.lazyValue(name), LazyValueUtils.lazyGet(() -> Support.fromCString((CCharPointer)csignature)), callerClassName)) {
            return true;
        }
        WordPointer declaringPtr = (WordPointer)StackValue.get(WordPointer.class);
        if (Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), result, declaringPtr) == JvmtiError.JVMTI_ERROR_NONE && this.typeAccessChecker.isMethodAccessible(env, clazz, name, () -> Support.fromCString((CCharPointer)csignature), result, declaring = (JNIObjectHandle)declaringPtr.read())) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit access to method: " + Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)clazz, (String)"(null)", (String)"(?)") + "." + name + Support.fromCString((CCharPointer)csignature)));){
            Support.jniFunctions().getThrowNew().invoke(env, ((NativeImageAgentJNIHandleSet)this.agent.handles()).javaLangNoSuchMethodError, message.get());
        }
        return false;
    }

    public boolean verifyGetFieldID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer cname, CCharPointer csignature, JNIFieldId result, JNIObjectHandle callerClass) {
        JNIObjectHandle declaring;
        assert (result.isNonNull());
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return true;
        }
        WordPointer declaringPtr = (WordPointer)StackValue.get(WordPointer.class);
        if (Support.jvmtiFunctions().GetFieldDeclaringClass().invoke(Support.jvmtiEnv(), clazz, result, declaringPtr) == JvmtiError.JVMTI_ERROR_NONE && this.typeAccessChecker.isFieldAccessible(env, clazz, () -> Support.fromCString((CCharPointer)cname), result, declaring = (JNIObjectHandle)declaringPtr.read())) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit access to field: " + Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)clazz, (String)"(null)", (String)"(?)") + "." + Support.fromCString((CCharPointer)cname)));){
            Support.jniFunctions().getThrowNew().invoke(env, ((NativeImageAgentJNIHandleSet)this.agent.handles()).javaLangNoSuchFieldError, message.get());
        }
        return false;
    }

    public boolean verifyThrowNew(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle callerClass) {
        JNIMethodId result;
        LazyValue<String> callerClassName = JniAccessVerifier.lazyClassNameOrNull(env, callerClass);
        if (this.shouldApproveWithoutChecks(JniAccessVerifier.lazyClassNameOrNull(env, clazz), callerClassName)) {
            return true;
        }
        String name = "<init>";
        String signature = "(Ljava/lang/String;)V";
        if (this.accessAdvisor.shouldIgnoreJniMethodLookup(JniAccessVerifier.lazyClassNameOrNull(env, clazz), LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(signature), callerClassName)) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)name);
             CTypeConversion.CCharPointerHolder csignature = Support.toCString((String)signature);){
            result = Support.jniFunctions().getGetMethodID().invoke(env, clazz, cname.get(), csignature.get());
        }
        return result.isNull() || this.typeAccessChecker.isMethodAccessible(env, clazz, name, () -> signature, result, clazz);
    }

    public boolean verifyFromReflectedMethod(JNIEnvironment env, JNIObjectHandle declaring, String name, String signature, JNIMethodId result, JNIObjectHandle callerClass) {
        assert (result.isNonNull());
        if (this.shouldApproveWithoutChecks(env, declaring, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.isMethodAccessible(env, declaring, name, () -> signature, result, declaring);
    }

    public boolean verifyFromReflectedField(JNIEnvironment env, JNIObjectHandle declaring, String name, JNIFieldId result, JNIObjectHandle callerClass) {
        assert (result.isNonNull());
        if (this.shouldApproveWithoutChecks(env, declaring, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.isFieldAccessible(env, declaring, () -> name, result, declaring);
    }

    public boolean verifyToReflectedMethod(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle declaring, JNIMethodId methodId, String name, String signature, JNIObjectHandle callerClass) {
        assert (methodId.isNonNull());
        if (this.reflectTypeAccessChecker == null) {
            return true;
        }
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return true;
        }
        return this.reflectTypeAccessChecker.isMethodAccessible(env, clazz, name, () -> signature, methodId, declaring);
    }

    public boolean verifyToReflectedField(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle declaring, String name, JNIFieldId fieldId, JNIObjectHandle callerClass) {
        assert (fieldId.isNonNull());
        if (this.reflectTypeAccessChecker == null) {
            return true;
        }
        if (this.shouldApproveWithoutChecks(env, clazz, callerClass)) {
            return true;
        }
        return this.reflectTypeAccessChecker.isFieldAccessible(env, clazz, () -> name, fieldId, declaring);
    }

    public boolean verifyNewObjectArray(JNIEnvironment env, JNIObjectHandle arrayClass, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, arrayClass, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.getType(arrayClass) != null;
    }
}

