/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class TypeAccessChecker {
    private final TypeConfiguration configuration;

    public TypeAccessChecker(TypeConfiguration configuration) {
        this.configuration = configuration;
    }

    public TypeConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isFieldAccessible(JNIEnvironment env, JNIObjectHandle clazz, Supplier<String> name, JNIFieldId field, JNIObjectHandle declaring) {
        if (this.getType(clazz) == null) {
            return false;
        }
        ConfigurationType declaringType = this.getType(declaring);
        if (declaringType != null && (declaringType.haveAllDeclaredFields() || declaringType.hasIndividualField(name.get()))) {
            return true;
        }
        CIntPointer modifiers = (CIntPointer)StackValue.get(CIntPointer.class);
        if (Support.jvmtiFunctions().GetFieldModifiers().invoke(Support.jvmtiEnv(), clazz, field, modifiers) == JvmtiError.JVMTI_ERROR_NONE) {
            boolean isPublic;
            boolean bl = isPublic = (modifiers.read() & 1) != 0;
            if (isPublic) {
                if (declaringType != null && declaringType.haveAllPublicFields()) {
                    return true;
                }
                if (declaring.notEqual((ComparableWord)clazz)) {
                    JNIObjectHandle current = clazz;
                    do {
                        ConfigurationType currentType;
                        if ((currentType = this.getType(current)) != null && currentType.haveAllPublicFields()) {
                            return true;
                        }
                        if (!this.testInterfacesBetween(env, declaring, current, ConfigurationType::haveAllPublicFields)) continue;
                        return true;
                    } while ((current = Support.jniFunctions().getGetSuperclass().invoke(env, current)).notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && Support.jniFunctions().getIsAssignableFrom().invoke(env, current, declaring));
                }
            }
        }
        return false;
    }

    public boolean isFieldUnsafeAccessible(Supplier<String> name, JNIObjectHandle declaring) {
        ConfigurationType declaringType = this.getType(declaring);
        return declaringType != null && declaringType.hasIndividualUnsafeAccessField(name.get());
    }

    public boolean isMethodAccessible(JNIEnvironment env, JNIObjectHandle clazz, String name, Supplier<String> signature, JNIMethodId method, JNIObjectHandle declaring) {
        if (this.getType(clazz) == null) {
            return false;
        }
        boolean isConstructor = "<init>".equals(name);
        ConfigurationType declaringType = this.getType(declaring);
        if (declaringType != null) {
            boolean haveAllDeclared;
            boolean bl = haveAllDeclared = isConstructor ? declaringType.haveAllDeclaredConstructors() : declaringType.haveAllDeclaredMethods();
            if (haveAllDeclared || declaringType.hasIndividualMethod(name, signature.get())) {
                return true;
            }
        }
        CIntPointer modifiers = (CIntPointer)StackValue.get(CIntPointer.class);
        if (Support.jvmtiFunctions().GetMethodModifiers().invoke(Support.jvmtiEnv(), method, modifiers) == JvmtiError.JVMTI_ERROR_NONE) {
            boolean isStatic;
            boolean isPublic;
            boolean bl = isPublic = (modifiers.read() & 1) != 0;
            if (isPublic && declaringType != null && (isConstructor ? declaringType.haveAllPublicConstructors() : declaringType.haveAllPublicMethods())) {
                return true;
            }
            boolean bl2 = isStatic = (modifiers.read() & 8) != 0;
            if (isPublic && !isStatic && !isConstructor && declaring.notEqual((ComparableWord)clazz)) {
                JNIObjectHandle current = clazz;
                do {
                    ConfigurationType currentType;
                    if ((currentType = this.getType(current)) != null && currentType.haveAllPublicMethods()) {
                        return true;
                    }
                    if (!this.testInterfacesBetween(env, declaring, current, ConfigurationType::haveAllPublicMethods)) continue;
                    return true;
                } while ((current = Support.jniFunctions().getGetSuperclass().invoke(env, current)).notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && Support.jniFunctions().getIsAssignableFrom().invoke(env, current, declaring));
            }
        }
        return false;
    }

    public ConfigurationType getType(JNIObjectHandle clazz) {
        WordPointer signaturePtr = (WordPointer)StackValue.get(WordPointer.class);
        if (Support.jvmtiFunctions().GetClassSignature().invoke(Support.jvmtiEnv(), clazz, signaturePtr, (WordPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
            String className = Support.fromCString((CCharPointer)((CCharPointer)signaturePtr.read()));
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
            return this.configuration.getByInternalName(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testInterfacesBetween(JNIEnvironment env, JNIObjectHandle declaring, JNIObjectHandle clazz, Predicate<ConfigurationType> predicate) {
        CIntPointer ifaceCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        WordPointer ifaceArrayPtr = (WordPointer)StackValue.get(WordPointer.class);
        if (Support.jvmtiFunctions().GetImplementedInterfaces().invoke(Support.jvmtiEnv(), clazz, ifaceCountPtr, ifaceArrayPtr) == JvmtiError.JVMTI_ERROR_NONE) {
            WordPointer ifaceArray = (WordPointer)ifaceArrayPtr.read();
            try {
                int ifaceCount = ifaceCountPtr.read();
                for (int i = 0; i < ifaceCount; ++i) {
                    JNIObjectHandle iface = (JNIObjectHandle)ifaceArray.read(i);
                    if (!Support.jniFunctions().getIsAssignableFrom().invoke(env, iface, declaring)) continue;
                    ConfigurationType ifaceType = this.getType(iface);
                    if (ifaceType != null && predicate.test(ifaceType)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (!this.testInterfacesBetween(env, declaring, iface, predicate)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)ifaceArray);
            }
        }
        return false;
    }
}

