/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class TraceWriter
implements Closeable {
    public static final String EXPLICIT_NULL = new String("null");
    public static final String UNKNOWN_VALUE = new String("\u0000");

    static Object handleSpecialValue(Object obj) {
        if (obj == EXPLICIT_NULL) {
            return null;
        }
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            Object[] newArray = null;
            for (int i = 0; i < array.length; ++i) {
                Object newValue = TraceWriter.handleSpecialValue(array[i]);
                if (newValue == array[i]) continue;
                if (newArray == null) {
                    newArray = Arrays.copyOf(array, array.length);
                }
                newArray[i] = newValue;
            }
            return newArray != null ? newArray : array;
        }
        return obj;
    }

    void traceInitialization() {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("tracer", "meta");
        entry.put("event", "initialization");
        entry.put("version", "1");
        this.traceEntry(entry);
    }

    public void tracePhaseChange(String phase) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("tracer", "meta");
        entry.put("event", "phase_change");
        entry.put("phase", phase);
        this.traceEntry(entry);
    }

    public void traceCall(String tracer, String function, Object clazz, Object declaringClass, Object callerClass, Object result, Object ... args) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("tracer", tracer);
        entry.put("function", function);
        if (clazz != null) {
            entry.put("class", TraceWriter.handleSpecialValue(clazz));
        }
        if (declaringClass != null) {
            entry.put("declaring_class", TraceWriter.handleSpecialValue(declaringClass));
        }
        if (callerClass != null) {
            entry.put("caller_class", TraceWriter.handleSpecialValue(callerClass));
        }
        if (result != null) {
            entry.put("result", TraceWriter.handleSpecialValue(result));
        }
        if (args != null) {
            entry.put("args", TraceWriter.handleSpecialValue(args));
        }
        this.traceEntry(entry);
    }

    abstract void traceEntry(Map<String, Object> var1);

    @Override
    public abstract void close();
}

