/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationMemberKind;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.compiler.phases.common.LazyValue;

class JniProcessor
extends AbstractProcessor {
    private final TypeConfiguration configuration;
    private final TypeConfiguration reflectionConfiguration;
    private final AccessAdvisor advisor;

    JniProcessor(AccessAdvisor advisor, TypeConfiguration configuration, TypeConfiguration reflectionConfiguration) {
        this.advisor = advisor;
        this.configuration = configuration;
        this.reflectionConfiguration = reflectionConfiguration;
    }

    public TypeConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    void processEntry(Map<String, ?> entry) {
        boolean invalidResult = Boolean.FALSE.equals(entry.get("result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get("function");
        String clazz = (String)entry.get("class");
        String declaringClass = (String)entry.get("declaring_class");
        String callerClass = (String)entry.get("caller_class");
        List args = (List)entry.get("args");
        LazyValue callerClassLazyValue = new LazyValue(() -> callerClass);
        if (this.advisor.shouldIgnore((LazyValue<String>)callerClassLazyValue)) {
            return;
        }
        String declaringClassOrClazz = declaringClass != null ? declaringClass : clazz;
        ConfigurationMemberKind memberKind = declaringClass != null ? ConfigurationMemberKind.DECLARED : ConfigurationMemberKind.PRESENT;
        TypeConfiguration config = this.configuration;
        switch (function) {
            case "DefineClass": {
                String name = (String)JniProcessor.singleElement(args);
                if (name.startsWith("com/sun/proxy/$Proxy")) break;
                JniProcessor.logWarning("Unsupported JNI function DefineClass used to load class " + name);
                break;
            }
            case "FindClass": {
                String qualifiedJavaName;
                String name = (String)JniProcessor.singleElement(args);
                if (name.charAt(0) != '[') {
                    name = "L" + name + ";";
                }
                if (this.advisor.shouldIgnoreJniClassLookup((LazyValue<String>)new LazyValue(() -> JniProcessor.lambda$processEntry$1(qualifiedJavaName = MetaUtil.internalNameToJava((String)name, (boolean)true, (boolean)false))), (LazyValue<String>)callerClassLazyValue)) break;
                config.getOrCreateType(qualifiedJavaName);
                break;
            }
            case "GetStaticMethodID": 
            case "GetMethodID": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                String signature = (String)args.get(1);
                if (this.advisor.shouldIgnoreJniMethodLookup((LazyValue<String>)new LazyValue(() -> clazz), (LazyValue<String>)new LazyValue(() -> name), (LazyValue<String>)new LazyValue(() -> signature), (LazyValue<String>)callerClassLazyValue)) break;
                config.getOrCreateType(declaringClassOrClazz).addMethod(name, signature, memberKind);
                break;
            }
            case "GetFieldID": 
            case "GetStaticFieldID": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                config.getOrCreateType(declaringClassOrClazz).addField(name, memberKind, false, false);
                break;
            }
            case "ThrowNew": {
                JniProcessor.expectSize(args, 1);
                String name = "<init>";
                String signature = "(Ljava/lang/String;)V";
                if (this.advisor.shouldIgnoreJniMethodLookup((LazyValue<String>)new LazyValue(() -> clazz), (LazyValue<String>)new LazyValue(() -> name), (LazyValue<String>)new LazyValue(() -> signature), (LazyValue<String>)callerClassLazyValue)) break;
                config.getOrCreateType(declaringClassOrClazz).addMethod(name, signature, memberKind);
                break;
            }
            case "ToReflectedField": {
                config = this.reflectionConfiguration;
            }
            case "FromReflectedField": {
                JniProcessor.expectSize(args, 1);
                String name = (String)args.get(0);
                config.getOrCreateType(declaringClassOrClazz).addField(name, memberKind, false, false);
                break;
            }
            case "ToReflectedMethod": {
                config = this.reflectionConfiguration;
            }
            case "FromReflectedMethod": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                String signature = (String)args.get(1);
                config.getOrCreateType(declaringClassOrClazz).addMethod(name, signature, memberKind);
                break;
            }
        }
    }

    private static /* synthetic */ String lambda$processEntry$1(String qualifiedJavaName) {
        return qualifiedJavaName;
    }
}

