/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import java.util.Arrays;
import org.graalvm.compiler.phases.common.LazyValue;

public class AccessAdvisor {
    private boolean ignoreInternalAccesses = true;
    private boolean isInLivePhase = false;
    private int launchPhase = 0;

    public void setIgnoreInternalAccesses(boolean enabled) {
        this.ignoreInternalAccesses = enabled;
    }

    public void setInLivePhase(boolean live) {
        this.isInLivePhase = live;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isInternalClass(String qualifiedClass) {
        assert (qualifiedClass == null || qualifiedClass.indexOf(47) == -1) : "expecting Java-format qualifiers, not internal format";
        if (qualifiedClass == null) return false;
        if (!Arrays.asList("java.", "javax.", "sun.", "com.sun.", "jdk.", "org.graalvm.compiler.").stream().anyMatch(qualifiedClass::startsWith)) return false;
        return true;
    }

    public boolean shouldIgnore(LazyValue<String> callerClass) {
        return this.ignoreInternalAccesses && (!this.isInLivePhase || AccessAdvisor.isInternalClass((String)callerClass.get()));
    }

    public boolean shouldIgnoreJniMethodLookup(LazyValue<String> queriedClass, LazyValue<String> name, LazyValue<String> signature, LazyValue<String> callerClass) {
        if (!this.ignoreInternalAccesses) {
            return false;
        }
        if (this.shouldIgnore(callerClass)) {
            return true;
        }
        if ("sun.launcher.LauncherHelper".equals(queriedClass.get())) {
            if (this.launchPhase == 0 && "getApplicationClass".equals(name.get()) && "()Ljava/lang/Class;".equals(signature.get())) {
                this.launchPhase = 1;
            }
            return true;
        }
        if (this.launchPhase == 1 && "getCanonicalName".equals(name.get()) && "()Ljava/lang/String;".equals(signature.get())) {
            this.launchPhase = 2;
            return true;
        }
        if (this.launchPhase > 0) {
            this.launchPhase = -1;
            if ("main".equals(name.get()) && "([Ljava/lang/String;)V".equals(signature.get())) {
                return true;
            }
        }
        if (callerClass.get() == null && "jdk.vm.ci.services.Services".equals(queriedClass.get()) && "getJVMCIClassLoader".equals(name.get()) && "()Ljava/lang/ClassLoader;".equals(signature.get())) {
            return true;
        }
        return callerClass.get() == null && "org.graalvm.compiler.hotspot.management.libgraal.runtime.SVMToHotSpotEntryPoints".equals(queriedClass.get());
    }

    public boolean shouldIgnoreJniClassLookup(LazyValue<String> name, LazyValue<String> callerClass) {
        if (!this.ignoreInternalAccesses) {
            return false;
        }
        if (this.shouldIgnore(callerClass)) {
            return true;
        }
        return callerClass.get() == null && "jdk.vm.ci.services.Services".equals(name.get());
    }
}

