/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonPrinter;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ResourceConfiguration
implements JsonPrintable {
    private final Map<String, Pattern> resources = new HashMap<String, Pattern>();

    public void add(String pattern) {
        this.resources.computeIfAbsent(pattern, Pattern::compile);
    }

    public boolean anyMatches(String s) {
        for (Pattern pattern : this.resources.values()) {
            if (!pattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        writer.quote("resources").append(':');
        JsonPrinter.printCollection(writer, this.resources.keySet(), Comparator.naturalOrder(), (p, w) -> w.append('{').quote("pattern").append(':').quote((String)p).append('}'));
        writer.unindent().newline().append('}').newline();
    }

    public static class ParserAdapter
    implements ResourcesRegistry {
        private final ResourceConfiguration configuration;

        public ParserAdapter(ResourceConfiguration configuration) {
            this.configuration = configuration;
        }

        public void addResources(String pattern) {
            this.configuration.add(pattern);
        }

        public void addResourceBundles(String name) {
        }
    }
}

